/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.util.List;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Matrix;

final class CanvasExtent
extends GridExtent {
    private static final long serialVersionUID = 195789629521760720L;
    private final double[] pointOfInterest;

    private CanvasExtent(DimensionNameType[] dimensionNameTypeArray, long[] lArray, long[] lArray2, double[] dArray) {
        super(dimensionNameTypeArray, lArray, lArray2, false);
        this.pointOfInterest = dArray;
    }

    public double[] getPointOfInterest() {
        return (double[])this.pointOfInterest.clone();
    }

    static GridExtent create(GeneralEnvelope generalEnvelope, DirectPosition directPosition, DimensionNameType[] dimensionNameTypeArray, int n) {
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        int n2 = generalEnvelope.getDimension();
        while (--n2 >= 0) {
            lArray[n2] = (long)Math.floor(generalEnvelope.getLower(n2));
            lArray2[n2] = (long)Math.ceil(generalEnvelope.getUpper(n2));
        }
        if (directPosition == null) {
            return new GridExtent(dimensionNameTypeArray, lArray, lArray2, false);
        }
        double[] dArray = new double[n];
        int n3 = directPosition.getDimension();
        while (--n3 >= 0) {
            dArray[n3] = directPosition.getOrdinate(n3);
        }
        return new CanvasExtent(dimensionNameTypeArray, lArray, lArray2, dArray);
    }

    static long findSupplementalDimensions(CoordinateReferenceSystem coordinateReferenceSystem, Matrix matrix, List<CoordinateReferenceSystem> list) {
        int n = Math.min(matrix.getNumCol(), 64);
        int n2 = matrix.getNumRow();
        long l = 0L;
        block0: for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (matrix.getElement(i, j) == 0.0) continue;
                l |= 1L << j;
                continue block0;
            }
        }
        l ^= Numerics.bitmask(n) - 1L;
        long l2 = 0L;
        while (l != 0L) {
            int n3 = Long.numberOfTrailingZeros(l);
            int n4 = Long.numberOfTrailingZeros(l + (1L << n3));
            long l3 = -(1L << n4);
            CoordinateReferenceSystem coordinateReferenceSystem2 = CRS.getComponentAt(coordinateReferenceSystem, n3, n4);
            if (coordinateReferenceSystem2 != null) {
                list.add(coordinateReferenceSystem2);
                l2 |= l & (l3 ^ 0xFFFFFFFFFFFFFFFFL);
            }
            l &= l3;
        }
        return l2;
    }

    static LinearTransform createGridToCRS(Matrix matrix, DirectPosition directPosition, long l) {
        int n;
        int n2;
        int n3 = matrix.getNumCol();
        int n4 = matrix.getNumRow();
        int n5 = n4 + Long.bitCount(l);
        MatrixSIS matrixSIS = Matrices.createZero(n5 + 1, n5 + 1);
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                matrixSIS.setElement(n2, n, matrix.getElement(n2, n));
            }
        }
        while (l != 0L) {
            n = Long.numberOfTrailingZeros(l);
            matrixSIS.setElement(n2, n2, Double.NaN);
            matrixSIS.setElement(n2++, n5, directPosition.getOrdinate(n));
            l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return MathTransforms.linear(matrixSIS);
    }

    static DimensionNameType[] suggestAxisTypes(CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        CoordinateSystem coordinateSystem;
        if (coordinateReferenceSystem != null && (coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()) != null) {
            int n2 = coordinateSystem.getDimension();
            DimensionNameType[] dimensionNameTypeArray = new DimensionNameType[n2];
            while (--n2 >= n) {
                AxisDirection axisDirection = AxisDirections.absolute(coordinateSystem.getAxis(n2).getDirection());
                if (AxisDirection.FUTURE.equals((Object)axisDirection)) {
                    dimensionNameTypeArray[n2] = DimensionNameType.TIME;
                    continue;
                }
                if (!AxisDirection.UP.equals((Object)axisDirection)) continue;
                dimensionNameTypeArray[n2] = DimensionNameType.VERTICAL;
            }
            return dimensionNameTypeArray;
        }
        return new DimensionNameType[n];
    }
}

