/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import org.apache.sis.gui.DataViewer;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.FrequencySortedSet;

public final class RecentChoices {
    public static final int MAXIMUM_REFERENCE_SYSTEMS = 20;
    private static final Preferences NODE = Preferences.userNodeForPackage(DataViewer.class);
    private static final String OPEN = "Open";
    private static final String FILES = "RecentFiles";
    private static final String URLS = "RecentURLs";
    private static final String CRS = "ReferenceSystems";
    private static final FrequencySortedSet<String> CRS_THIS_RUN = new FrequencySortedSet(true);

    private RecentChoices() {
    }

    public static File getOpenDirectory() {
        String value = NODE.get(OPEN, null);
        if (value != null) {
            File file = new File(value);
            do {
                if (!file.isDirectory()) continue;
                return file;
            } while ((file = file.getParentFile()) != null);
        }
        return null;
    }

    public static void setOpenDirectory(List<File> files) {
        File parent = RecentChoices.getCommonParent(files);
        NODE.put(OPEN, parent != null ? parent.getAbsolutePath() : null);
    }

    public static CharSequence[] getFiles() {
        return CharSequences.splitOnEOL((CharSequence)NODE.get(FILES, null));
    }

    public static void setFiles(String files) {
        NODE.put(FILES, files);
    }

    public static void getURLs(Collection<String> addTo) {
        for (CharSequence url : CharSequences.splitOnEOL((CharSequence)NODE.get(URLS, null))) {
            addTo.add(url.toString());
        }
    }

    public static void setURLs(Collection<String> files) {
        NODE.put(URLS, String.join((CharSequence)System.lineSeparator(), files));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getReferenceSystems() {
        String[] codes;
        FrequencySortedSet<String> frequencySortedSet = CRS_THIS_RUN;
        synchronized (frequencySortedSet) {
            int n = CRS_THIS_RUN.size();
            if (n != 0) {
                codes = (String[])CRS_THIS_RUN.toArray((Object[])new String[n]);
            } else {
                String value = NODE.get(CRS, null);
                codes = (String[])CharSequences.split((CharSequence)value, (char)',');
                CRS_THIS_RUN.addAll(Arrays.asList(codes));
            }
        }
        return codes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useReferenceSystem(String code) {
        if (code != null) {
            String[] codes;
            FrequencySortedSet<String> frequencySortedSet = CRS_THIS_RUN;
            synchronized (frequencySortedSet) {
                if (!CRS_THIS_RUN.add((Object)code.trim())) {
                    return;
                }
                codes = (String[])CRS_THIS_RUN.toArray((Object[])new String[CRS_THIS_RUN.size()]);
            }
            RecentChoices.saveReferenceSystems(codes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveReferenceSystems() {
        String[] codes;
        FrequencySortedSet<String> frequencySortedSet = CRS_THIS_RUN;
        synchronized (frequencySortedSet) {
            codes = (String[])CRS_THIS_RUN.toArray((Object[])new String[CRS_THIS_RUN.size()]);
        }
        RecentChoices.saveReferenceSystems(codes);
    }

    private static void saveReferenceSystems(String[] codes) {
        if (codes.length != 0) {
            if (codes.length > 20) {
                codes = Arrays.copyOf(codes, 20);
            }
            NODE.put(CRS, String.join((CharSequence)",", codes));
        }
    }

    private static File getCommonParent(List<File> files) {
        File parent = null;
        for (File file : files) {
            File otherParent = file.getParentFile();
            if (otherParent == null || otherParent.equals(parent)) continue;
            if (parent == null) {
                parent = otherParent;
                continue;
            }
            String path = otherParent.getAbsolutePath();
            while (!path.startsWith(parent.getAbsolutePath())) {
                if ((parent = parent.getParentFile()) != null) continue;
                return null;
            }
        }
        return parent;
    }

    public static <T> void setInList(ComboBox<T> choices, T newValue) {
        ObservableList items = choices.getItems();
        int p = items.indexOf(newValue);
        if (p != 0) {
            if (p > 0) {
                items.remove(p);
            } else {
                int count = items.size();
                if (count >= 20) {
                    items.remove(count - 1);
                }
            }
            items.add(0, newValue);
        }
        choices.getSelectionModel().selectFirst();
    }
}

