/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.referencing.GeodeticObjectBuilder;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;

public abstract class PositionableProjection
extends CodeList<PositionableProjection> {
    private static final List<PositionableProjection> VALUES = new ArrayList<PositionableProjection>(1);
    public static final PositionableProjection ORTHOGRAPHIC = new PositionableProjection("ORTHOGRAPHIC", 52){

        @Override
        protected ProjectedCRS createProjectedCRS(GeographicCRS baseCRS, double latitude, double longitude) throws FactoryException {
            return this.newBuilder(latitude, longitude).setConversionMethod("Orthographic").setParameter("Latitude of natural origin", latitude, Units.DEGREE).setParameter("Longitude of natural origin", longitude, Units.DEGREE).createProjectedCRS(baseCRS, null);
        }
    };
    public static final PositionableProjection AZIMUTHAL_EQUIDISTANT = new PositionableProjection("AZIMUTHAL_EQUIDISTANT", 42){

        @Override
        protected ProjectedCRS createProjectedCRS(GeographicCRS baseCRS, double latitude, double longitude) throws FactoryException {
            return this.newBuilder(latitude, longitude).setConversionMethod("Azimuthal Equidistant (Spherical)").setParameter("Latitude of natural origin", latitude, Units.DEGREE).setParameter("Longitude of natural origin", longitude, Units.DEGREE).createProjectedCRS(baseCRS, null);
        }
    };
    public static final PositionableProjection UTM = new PositionableProjection("UTM", 45){

        @Override
        protected ProjectedCRS createProjectedCRS(GeographicCRS baseCRS, double latitude, double longitude) throws FactoryException {
            CommonCRS cd;
            try {
                cd = CommonCRS.forDatum((CoordinateReferenceSystem)baseCRS);
            }
            catch (IllegalArgumentException e) {
                Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.gui"), PositionableProjection.class, (String)"createProjectedCRS", (Throwable)e);
                cd = CommonCRS.WGS84;
            }
            return cd.universal(latitude, longitude);
        }
    };
    public static final PositionableProjection MERCATOR = new PositionableProjection("MERCATOR", 44){

        @Override
        protected ProjectedCRS createProjectedCRS(GeographicCRS baseCRS, double latitude, double longitude) throws FactoryException {
            return this.newBuilder(latitude, longitude).setConversionMethod("Mercator (variant C)").setParameter("Latitude of false origin", latitude, Units.DEGREE).setParameter("Longitude of natural origin", longitude, Units.DEGREE).createProjectedCRS(baseCRS, null);
        }
    };
    private final short nameKey;

    protected PositionableProjection(String name) {
        super(name, VALUES);
        this.nameKey = 0;
    }

    private PositionableProjection(String name, short nameKey) {
        super(name, VALUES);
        this.nameKey = nameKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PositionableProjection[] values() {
        List<PositionableProjection> list = VALUES;
        synchronized (list) {
            return VALUES.toArray(new PositionableProjection[VALUES.size()]);
        }
    }

    public PositionableProjection[] family() {
        return PositionableProjection.values();
    }

    public String toString() {
        return this.nameKey != 0 ? Resources.format(this.nameKey) : this.name();
    }

    public ProjectedCRS createProjectedCRS(DirectPosition center) throws FactoryException, TransformException {
        ArgumentChecks.ensureNonNull((String)"center", (Object)center);
        CoordinateReferenceSystem inherit = center.getCoordinateReferenceSystem();
        if (inherit == null) {
            throw new IllegalArgumentException(Errors.format((short)157));
        }
        GeographicCRS normalizedCRS = ReferencingUtilities.toNormalizedGeographicCRS((CoordinateReferenceSystem)inherit, (boolean)true, (boolean)false);
        if (normalizedCRS == null) {
            normalizedCRS = CommonCRS.WGS84.geographic();
        }
        if (!Utilities.equalsIgnoreMetadata((Object)normalizedCRS, (Object)inherit)) {
            center = CRS.findOperation((CoordinateReferenceSystem)inherit, (CoordinateReferenceSystem)normalizedCRS, null).getMathTransform().transform(center, null);
        }
        return this.createProjectedCRS(normalizedCRS, Latitude.clamp((double)center.getOrdinate(0)), Longitude.normalize((double)center.getOrdinate(1)));
    }

    protected abstract ProjectedCRS createProjectedCRS(GeographicCRS var1, double var2, double var4) throws FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final GeodeticObjectBuilder newBuilder(double latitude, double longitude) {
        StringBuffer b;
        AngleFormat f = new AngleFormat("DD\u00b0MM\u2032SS\u2033");
        StringBuffer stringBuffer = b = new StringBuffer();
        synchronized (stringBuffer) {
            b.append((Object)this).append(" @ ");
            f.format((Object)new Latitude(latitude), b, null).append(' ');
            f.format((Object)new Longitude(longitude), b, null);
            return (GeodeticObjectBuilder)new GeodeticObjectBuilder().addName((CharSequence)b.toString());
        }
    }
}

