/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.Locale;
import javafx.util.StringConverter;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;

final class ObjectStringConverter<T extends IdentifiedObject>
extends StringConverter<T> {
    private final Iterable<? extends T> items;
    private final Locale locale;
    private String other;

    ObjectStringConverter(Iterable<? extends T> items, Locale locale) {
        this.items = items;
        this.locale = locale;
    }

    public String toString(T object) {
        if (object != RecentReferenceSystems.OTHER) {
            return IdentifiedObjects.getDisplayName(object, (Locale)this.locale);
        }
        if (this.other == null) {
            this.other = Vocabulary.getResources((Locale)this.locale).getString((short)157) + "\u2026";
        }
        return this.other;
    }

    public T fromString(String name) {
        if (name != null) {
            IdentifiedObject fallback = null;
            for (IdentifiedObject item : this.items) {
                String candidate = this.toString((T)item);
                if (name.equals(candidate)) {
                    return (T)item;
                }
                if (fallback != null || !name.equalsIgnoreCase(candidate)) continue;
                fallback = item;
            }
            if (fallback != null) {
                return (T)fallback;
            }
            for (IdentifiedObject item : this.items) {
                if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)item, (String)name)) continue;
                return (T)item;
            }
        }
        return null;
    }
}

