/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ToggleGroup;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class MenuSync
extends SimpleObjectProperty<ReferenceSystem>
implements EventHandler<ActionEvent> {
    private static final String REFERENCE_SYSTEM_KEY = "ReferenceSystem";
    private static final String CHOOSER = "CHOOSER";
    private final ObservableList<MenuItem> menus;
    private final ToggleGroup group;
    private final RecentReferenceSystems.Listener action;

    MenuSync(ObservableList<ReferenceSystem> systems, Menu bean, RecentReferenceSystems.Listener action) {
        super((Object)bean, "value");
        this.menus = bean.getItems();
        this.group = new ToggleGroup();
        this.action = action;
        Object[] items = new MenuItem[systems.size()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = this.createItem((ReferenceSystem)systems.get(i));
        }
        this.menus.setAll(items);
        this.initialize(systems);
    }

    private void initialize(ObservableList<? extends ReferenceSystem> systems) {
        for (ReferenceSystem system : systems) {
            if (!(system instanceof CoordinateReferenceSystem) || ReferencingUtilities.getDimension((CoordinateReferenceSystem)((CoordinateReferenceSystem)system)) != 2) continue;
            this.set(system);
            break;
        }
    }

    private MenuItem createItem(ReferenceSystem system) {
        Locale locale = this.action.owner().locale;
        if (system != RecentReferenceSystems.OTHER) {
            RadioMenuItem item = new RadioMenuItem(IdentifiedObjects.getDisplayName((IdentifiedObject)system, (Locale)locale));
            item.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)system);
            item.setToggleGroup(this.group);
            item.setOnAction((EventHandler)this);
            return item;
        }
        MenuItem item = new MenuItem(Vocabulary.getResources((Locale)locale).getString((short)157) + "\u2026");
        item.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)CHOOSER);
        item.setOnAction((EventHandler)this);
        return item;
    }

    private static void dispose(MenuItem item) {
        item.setOnAction(null);
        if (item instanceof RadioMenuItem) {
            ((RadioMenuItem)item).setToggleGroup(null);
        }
    }

    final void notifyChanges(ObservableList<? extends ReferenceSystem> systems) {
        IdentityHashMap<Object, MenuItem> mapping = new IdentityHashMap<Object, MenuItem>();
        Iterator it = this.menus.iterator();
        while (it.hasNext()) {
            MenuItem item = (MenuItem)it.next();
            if (mapping.putIfAbsent(item.getProperties().get((Object)REFERENCE_SYSTEM_KEY), item) == null) continue;
            it.remove();
            MenuSync.dispose(item);
        }
        MenuItem[] items = new MenuItem[systems.size()];
        for (int i = 0; i < items.length; ++i) {
            Object key = systems.get(i);
            if (key == RecentReferenceSystems.OTHER) {
                key = CHOOSER;
            }
            items[i] = (MenuItem)mapping.remove(key);
        }
        ReferenceSystem selected = (ReferenceSystem)this.get();
        Iterator recycle = mapping.values().iterator();
        for (int i = 0; i < items.length; ++i) {
            MenuItem item;
            if (items[i] != null) continue;
            ReferenceSystem system = (ReferenceSystem)systems.get(i);
            if (system != RecentReferenceSystems.OTHER && recycle.hasNext()) {
                item = (MenuItem)recycle.next();
                recycle.remove();
                if (item instanceof RadioMenuItem) {
                    item.setText(IdentifiedObjects.getDisplayName((IdentifiedObject)system, (Locale)this.action.owner().locale));
                    item.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)system);
                } else {
                    item = this.createItem(system);
                }
            } else {
                item = this.createItem(system);
            }
            if (selected != null && system == selected) {
                ((RadioMenuItem)item).setSelected(true);
                selected = null;
            }
            items[i] = item;
        }
        while (recycle.hasNext()) {
            MenuSync.dispose((MenuItem)recycle.next());
        }
        GUIUtilities.copyAsDiff(Arrays.asList(items), this.menus);
        if (this.get() == null) {
            this.initialize(systems);
        }
    }

    public void handle(ActionEvent event) {
        Object value = ((MenuItem)event.getSource()).getProperties().get((Object)REFERENCE_SYSTEM_KEY);
        if (value == CHOOSER) {
            this.action.changed((ObservableValue<? extends ReferenceSystem>)this, (ReferenceSystem)this.get(), RecentReferenceSystems.OTHER);
        } else {
            this.set((ReferenceSystem)value);
        }
    }

    public void set(ReferenceSystem system) {
        ReferenceSystem old = (ReferenceSystem)this.get();
        if (old != system) {
            ComparisonMode mode = (ComparisonMode)this.action.owner().duplicationCriterion.get();
            for (MenuItem item : this.menus) {
                Object current;
                if (!(item instanceof RadioMenuItem) || !Utilities.deepEquals((Object)(current = item.getProperties().get((Object)REFERENCE_SYSTEM_KEY)), (Object)system, (ComparisonMode)mode)) continue;
                system = (ReferenceSystem)current;
                super.set((Object)system);
                ((RadioMenuItem)item).setSelected(true);
                this.action.changed((ObservableValue<? extends ReferenceSystem>)this, old, system);
                return;
            }
            super.set((Object)system);
            this.group.selectToggle(null);
            this.action.owner().addSelected(system);
        }
    }
}

