/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableListBase;
import javafx.concurrent.Task;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.apache.sis.gui.referencing.Code;
import org.apache.sis.gui.referencing.Utils;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

final class AuthorityCodes
extends ObservableListBase<Code>
implements Callback<TableColumn.CellDataFeatures<Code, String>, ObservableValue<String>> {
    private static final long REFRESH_DELAY = 100000000L;
    TableView<Code> owner;
    private static final Class<? extends IdentifiedObject> type = CoordinateReferenceSystem.class;
    private final List<Object> codes;
    private int describedCount;
    final Locale locale;
    private CRSAuthorityFactory factory;
    private Loader loader;
    private volatile boolean hasError;

    AuthorityCodes(CRSAuthorityFactory factory, Locale locale) {
        this.locale = locale;
        this.factory = factory;
        this.codes = new ArrayList<Object>();
        this.loader = new Loader();
        this.loader.start();
    }

    final synchronized CRSAuthorityFactory getFactory() throws FactoryException {
        if (this.factory == null) {
            this.factory = Utils.getDefaultFactory();
        }
        return this.factory;
    }

    public int size() {
        return this.codes.size();
    }

    public Code get(int index) {
        Object value = this.codes.get(index);
        if (value instanceof Code) {
            return (Code)value;
        }
        Code c = new Code((String)value);
        this.codes.set(index, c);
        return c;
    }

    public boolean add(Code code) {
        int i = this.codes.size();
        this.codes.add(code);
        this.beginChange();
        this.nextAdd(i, i + 1);
        this.endChange();
        return true;
    }

    public ObservableValue<String> call(TableColumn.CellDataFeatures<Code, String> cell) {
        return this.getName((Code)cell.getValue()).getReadOnlyProperty();
    }

    final ReadOnlyStringWrapper getName(Code code) {
        ReadOnlyStringWrapper p = code.name();
        String name = p.getValue();
        if (name == null) {
            this.loader.requestName(code);
        }
        return p;
    }

    private void update(PartialResult result) {
        assert (Platform.isFxApplicationThread());
        int s = this.codes.size();
        if (result.codes != null) {
            this.codes.addAll(Arrays.asList(result.codes));
        }
        this.beginChange();
        this.nextAdd(s, this.codes.size());
        if (result.names != null) {
            ListIterator<Object> it = this.codes.listIterator();
            while (it.hasNext()) {
                Object value = it.next();
                String name = result.names.remove(value);
                if (name == null) continue;
                int i = it.previousIndex();
                if (name.isEmpty()) {
                    it.remove();
                    this.nextRemove(i, (Code)value);
                    continue;
                }
                ((Code)value).name().set(name);
                ++this.describedCount;
                this.nextUpdate(i);
            }
        }
        this.endChange();
        if (this.describedCount >= this.codes.size()) {
            this.removeHourglass();
        }
    }

    private void removeHourglass() {
        if (this.owner != null) {
            this.owner.setPlaceholder(null);
            this.owner = null;
        }
    }

    private void errorOccurred(Throwable e) {
        if (!this.hasError) {
            this.hasError = true;
            Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.gui"), AuthorityCodes.class, (String)"get", (Throwable)e);
        }
    }

    private final class Loader
    extends Task<PartialResult> {
        private final List<Code> toDescribe;
        private final boolean loadCodes;
        private boolean isRunning;

        Loader() {
            this.toDescribe = new ArrayList<Code>();
            this.loadCodes = true;
        }

        private Loader(Loader previous) {
            this.toDescribe = previous.toDescribe;
            this.loadCodes = false;
        }

        final void start() {
            this.isRunning = true;
            BackgroundThreads.execute((Runnable)((Object)this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void requestName(Code code) {
            assert (Platform.isFxApplicationThread());
            List<Code> list = this.toDescribe;
            synchronized (list) {
                this.toDescribe.add(code);
            }
            if (!this.isRunning) {
                this.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Code, String> processNameRequests(CRSAuthorityFactory factory) {
            Code[] snapshot;
            List<Code> list = this.toDescribe;
            synchronized (list) {
                int size = this.toDescribe.size();
                if (size == 0) {
                    return null;
                }
                snapshot = this.toDescribe.toArray(new Code[size]);
                this.toDescribe.clear();
            }
            IdentityHashMap<Code, String> updated = new IdentityHashMap<Code, String>(snapshot.length);
            for (Code code : snapshot) {
                String text;
                try {
                    text = Strings.trimOrNull((String)Types.toString((InternationalString)factory.getDescriptionText(code.code), (Locale)AuthorityCodes.this.locale));
                    if (text == null) {
                        text = Vocabulary.getResources((Locale)AuthorityCodes.this.locale).getString((short)208);
                    }
                }
                catch (FactoryException e) {
                    AuthorityCodes.this.errorOccurred(e);
                    text = "";
                }
                updated.put(code, text);
            }
            return updated;
        }

        protected PartialResult call() throws Exception {
            long lastTime = System.nanoTime();
            List codes = Collections.emptyList();
            CRSAuthorityFactory factory = AuthorityCodes.this.getFactory();
            try {
                if (this.loadCodes) {
                    codes = new ArrayList(100);
                    Iterator it = factory.getAuthorityCodes(type).iterator();
                    while (it.hasNext()) {
                        codes.add((String)it.next());
                        if (System.nanoTime() - lastTime <= 100000000L) continue;
                        PartialResult p = new PartialResult(codes.toArray(), this.processNameRequests(factory));
                        codes.clear();
                        Platform.runLater(() -> AuthorityCodes.this.update(p));
                        lastTime = System.nanoTime();
                    }
                }
                if (codes.isEmpty()) {
                    Thread.sleep(100L);
                    return new PartialResult(null, this.processNameRequests(factory));
                }
            }
            catch (BackingStoreException e) {
                throw e.unwrapOrRethrow(Exception.class);
            }
            return new PartialResult(codes.toArray(), null);
        }

        protected void succeeded() {
            AuthorityCodes.this.update((PartialResult)this.getValue());
            this.prepareNewLoader();
        }

        protected void failed() {
            Throwable e = this.getException();
            AuthorityCodes.this.errorOccurred(e);
            if (this.loadCodes) {
                Code code = new Code(Vocabulary.getResources((Locale)AuthorityCodes.this.locale).getString((short)80));
                String message = Exceptions.getLocalizedMessage((Throwable)e, (Locale)AuthorityCodes.this.locale);
                if (message == null) {
                    message = e.getClass().getSimpleName();
                }
                code.name().set(message);
                AuthorityCodes.this.add(code);
            }
            AuthorityCodes.this.removeHourglass();
            this.prepareNewLoader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepareNewLoader() {
            boolean isEmpty;
            assert (Platform.isFxApplicationThread());
            this.isRunning = false;
            AuthorityCodes.this.loader = new Loader(this);
            List<Code> list = this.toDescribe;
            synchronized (list) {
                isEmpty = this.toDescribe.isEmpty();
            }
            if (!isEmpty) {
                AuthorityCodes.this.loader.start();
            }
        }
    }

    private static final class PartialResult {
        final Object[] codes;
        final Map<Code, String> names;

        PartialResult(Object[] codes, Map<Code, String> names) {
            this.codes = codes;
            this.names = names;
        }
    }
}

