/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javax.measure.Unit;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridEvaluator;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.content.TransferFunctionType;

public abstract class ValuesUnderCursor {
    private StatusBar owner;
    protected final Menu valueChoices = new Menu();
    private String lastErrorMessage;

    protected ValuesUnderCursor() {
    }

    public abstract boolean isEmpty();

    public abstract String evaluate(DirectPosition var1);

    final boolean prototype(String main, Iterable<String> others) {
        return this.owner == null || this.owner.computeSizeOfSampleValues(main, others);
    }

    private static Locale getLocale(ObservableValue<?> property) {
        Object bean;
        if (property instanceof ReadOnlyProperty && (bean = ((ReadOnlyProperty)property).getBean()) instanceof Localized) {
            return ((Localized)bean).getLocale();
        }
        return null;
    }

    static void update(StatusBar owner, ValuesUnderCursor oldValue, ValuesUnderCursor newValue) {
        if (oldValue != null && oldValue.owner == owner) {
            oldValue.owner = null;
        }
        if (newValue != null && newValue.owner == null) {
            newValue.owner = owner;
        }
    }

    static ValuesUnderCursor create(MapCanvas canvas) {
        if (canvas instanceof CoverageCanvas) {
            FromCoverage listener = new FromCoverage();
            ObjectProperty<GridCoverage> coverageProperty = ((CoverageCanvas)canvas).coverageProperty;
            coverageProperty.addListener((ChangeListener)new WeakChangeListener((ChangeListener)listener));
            GridCoverage coverage = (GridCoverage)coverageProperty.get();
            if (coverage != null) {
                listener.changed(null, null, coverage);
            }
            return listener;
        }
        return null;
    }

    final void recoverableException(String method, Exception e) {
        String message = e.getMessage();
        if (!message.equals(this.lastErrorMessage)) {
            this.lastErrorMessage = message;
            Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.gui"), ValuesUnderCursor.class, (String)method, (Throwable)e);
        }
    }

    private static class FromCoverage
    extends ValuesUnderCursor
    implements ChangeListener<GridCoverage> {
        private static final char SEPARATOR = '\u2003';
        private static final int DEFAULT_FORMAT = -1;
        private static final int SCIENTIFIC_NOTATION = -2;
        private GridEvaluator evaluator;
        private final BitSet selectedBands;
        private NumberFormat[] sampleFormats;
        private final StringBuffer buffer = new StringBuffer();
        private final FieldPosition field = new FieldPosition(0);
        private String[] units;
        private final Map<Long, String> nodata = new HashMap<Long, String>();
        private String outsideText;
        private boolean needsBandRefresh;

        public FromCoverage() {
            this.selectedBands = new BitSet();
            this.valueChoices.setText(Vocabulary.format((short)178));
        }

        public final GridCoverage getCoverage() {
            return this.evaluator != null ? this.evaluator.getCoverage() : null;
        }

        @Override
        public boolean isEmpty() {
            return this.selectedBands.isEmpty();
        }

        public void changed(ObservableValue<? extends GridCoverage> property, GridCoverage previous, GridCoverage coverage) {
            List bands;
            if (coverage == null || (bands = coverage.getSampleDimensions()) == null) {
                this.evaluator = null;
                this.units = null;
                this.sampleFormats = null;
                this.outsideText = null;
                this.nodata.clear();
                this.selectedBands.clear();
                this.valueChoices.getItems().clear();
                return;
            }
            this.evaluator = coverage.forConvertedValues(true).evaluator();
            this.evaluator.setNullIfOutside(true);
            if (previous != null && bands.equals(previous.getSampleDimensions())) {
                return;
            }
            int numBands = bands.size();
            this.units = new String[numBands];
            this.sampleFormats = new NumberFormat[numBands];
            this.outsideText = null;
            this.selectedBands.clear();
            this.selectedBands.set(0, numBands <= 3 ? numBands : 1, true);
            this.nodata.clear();
            HashMap<Integer, NumberFormat> sharedFormats = new HashMap<Integer, NumberFormat>();
            HashMap sharedSymbols = new HashMap();
            Locale locale = ValuesUnderCursor.getLocale(property);
            UnitFormat unitFormat = new UnitFormat(locale);
            Object[] menuItems = new CheckMenuItem[numBands];
            for (int b = 0; b < numBands; ++b) {
                SampleDimension sd = (SampleDimension)bands.get(b);
                menuItems[b] = this.createMenuItem(b, sd, locale);
                for (Category c : sd.forConvertedValues(true).getCategories()) {
                    float value = ((Number)((Object)c.getSampleRange().getMinValue())).floatValue();
                    if (!Float.isNaN(value)) continue;
                    try {
                        this.nodata.putIfAbsent(FromCoverage.toNodataKey(b, value), c.getName().toString(locale));
                    }
                    catch (IllegalArgumentException e) {
                        this.recoverableException("changed", e);
                    }
                }
                this.units[b] = sd.getUnits().map(unit -> sharedSymbols.computeIfAbsent(unit, key -> this.format(unitFormat, (Unit<?>)key))).orElse("");
                SampleDimension isd = sd.forConvertedValues(false);
                Integer nf = isd.getTransferFunctionFormula().map(formula -> FromCoverage.suggestFractionDigits(formula, isd)).orElse(-1);
                this.sampleFormats[b] = sharedFormats.computeIfAbsent(nf, precision -> {
                    switch (precision) {
                        case 0: {
                            return NumberFormat.getIntegerInstance(locale);
                        }
                        case -1: {
                            return NumberFormat.getNumberInstance(locale);
                        }
                        case -2: {
                            NumberFormat format = NumberFormat.getNumberInstance(locale);
                            if (precision == -2 && format instanceof DecimalFormat) {
                                ((DecimalFormat)format).applyPattern("0.000E00");
                            }
                            return format;
                        }
                    }
                    NumberFormat format = NumberFormat.getNumberInstance(locale);
                    format.setMinimumFractionDigits((int)precision);
                    format.setMaximumFractionDigits((int)precision);
                    return format;
                });
            }
            this.valueChoices.getItems().setAll(menuItems);
            this.onBandSelectionChanged();
        }

        private static Long toNodataKey(int band, float value) {
            return (long)MathFunctions.toNanOrdinal((float)value) << 32 | (long)band;
        }

        private static Integer suggestFractionDigits(TransferFunction formula, SampleDimension isd) {
            int nf;
            if (formula.getType() != TransferFunctionType.LINEAR) {
                nf = -2;
            } else {
                double resolution = formula.getScale();
                if (resolution > 0.0 && resolution <= Double.MAX_VALUE) {
                    Optional range = isd.getSampleRange();
                    if (range.isPresent()) {
                        resolution *= 0.5 / ((NumberRange)range.get()).getSpan() + 1.0;
                    }
                    if ((nf = DecimalFunctions.fractionDigitsForDelta((double)resolution, (boolean)false)) < -9 || nf > 6) {
                        nf = -2;
                    }
                } else {
                    nf = -1;
                }
            }
            return nf;
        }

        private CheckMenuItem createMenuItem(int index, SampleDimension sd, Locale locale) {
            CheckMenuItem item = new CheckMenuItem(sd.getName().toInternationalString().toString(locale));
            item.setSelected(this.selectedBands.get(index));
            item.selectedProperty().addListener((p, o, n) -> {
                this.selectedBands.set(index, (boolean)n);
                this.onBandSelectionChanged();
            });
            return item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String evaluate(DirectPosition point) {
            if (this.needsBandRefresh && this.evaluator != null) {
                this.onBandSelectionChanged();
            }
            if (point != null) {
                StringBuffer stringBuffer = this.buffer;
                synchronized (stringBuffer) {
                    block14: {
                        this.buffer.setLength(0);
                        if (this.evaluator != null) {
                            try {
                                double[] results = this.evaluator.apply(point);
                                if (results == null) break block14;
                                int i = -1;
                                while ((i = this.selectedBands.nextSetBit(i + 1)) >= 0) {
                                    double value;
                                    if (this.buffer.length() != 0) {
                                        this.buffer.append('\u2003');
                                    }
                                    if (Double.isNaN(value = results[i])) {
                                        try {
                                            String label = this.nodata.get(FromCoverage.toNodataKey(i, (float)value));
                                            if (label != null) {
                                                return label;
                                            }
                                        }
                                        catch (IllegalArgumentException e) {
                                            this.recoverableException("evaluate", e);
                                        }
                                    }
                                    this.sampleFormats[i].format(value, this.buffer, this.field).append(this.units[i]);
                                }
                                return this.buffer.toString();
                            }
                            catch (CannotEvaluateException e) {
                                this.recoverableException("evaluate", (Exception)((Object)e));
                            }
                        }
                    }
                }
            }
            return this.outsideText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String format(UnitFormat format, Unit<?> unit) {
            StringBuffer stringBuffer = this.buffer;
            synchronized (stringBuffer) {
                this.buffer.setLength(0);
                format.format(unit, this.buffer, this.field);
                if (this.buffer.length() != 0 && Character.isLetterOrDigit(this.buffer.codePointAt(0))) {
                    this.buffer.insert(0, '\u00a0');
                }
                return this.buffer.toString();
            }
        }

        /*
         * Exception decompiling
         */
        private void onBandSelectionChanged() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:68)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIter.rewriteExpressions(StructuredIter.java:119)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ Comparable[] lambda$onBandSelectionChanged$6() {
            return new Comparable[]{Integer.valueOf(65535)};
        }
    }
}

