/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.CoordinateFormat;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.OperationFinder;
import org.apache.sis.gui.map.ValuesUnderCursor;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class StatusBar
extends Widget
implements EventHandler<MouseEvent> {
    private static final int BIDIMENSIONAL = 2;
    private static final Insets PADDING = new Insets(5.0, 20.0, 6.0, 9.0);
    private static final int VALUES_PADDING = 9;
    private final HBox view;
    private final Label message;
    private double lastX;
    private double lastY;
    private final MapCanvas canvas;
    private final RecentReferenceSystems systemChooser;
    private final ObjectProperty<ReferenceSystem> selectedSystem;
    private CoordinateReferenceSystem objectiveCRS;
    private MathTransform objectiveToPositionCRS;
    public final ObjectProperty<MathTransform> localToObjectiveCRS;
    public final ReadOnlyObjectProperty<ReferenceSystem> positionReferenceSystem = new PositionSystem();
    private MathTransform localToPositionCRS;
    private Predicate<MapCanvas> fullOperationSearchRequired;
    private double[] sourceCoordinates;
    private GeneralDirectPosition targetCoordinates;
    private double[] precisions;
    private double[] inflatePrecisions;
    private Quantity<Length> lowestAccuracy;
    private final CoordinateFormat format;
    protected final Label position;
    private int maximalPositionLength;
    private String outsideText;
    private Label sampleValues;
    public final ObjectProperty<ValuesUnderCursor> sampleValuesProvider;
    private boolean isSampleValuesVisible;

    public StatusBar(RecentReferenceSystems systemChooser, MapCanvas ... toTrack) {
        this.localToObjectiveCRS = new LocalToObjective();
        this.localToPositionCRS = (MathTransform)this.localToObjectiveCRS.get();
        this.targetCoordinates = new GeneralDirectPosition(2);
        this.sourceCoordinates = this.targetCoordinates.coordinates;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
        this.format = new CoordinateFormat();
        this.message = new Label();
        this.message.setVisible(false);
        this.message.setTextFill((Paint)Styles.ERROR_TEXT);
        this.message.setMaxWidth(Double.POSITIVE_INFINITY);
        HBox.setHgrow((Node)this.message, (Priority)Priority.ALWAYS);
        this.position = new Label();
        this.position.setAlignment(Pos.CENTER_RIGHT);
        this.position.setTextAlignment(TextAlignment.RIGHT);
        this.view = new HBox(18.0, new Node[]{this.message, this.position});
        this.view.setPadding(PADDING);
        this.view.setAlignment(Pos.CENTER_RIGHT);
        ContextMenu menu = new ContextMenu();
        this.view.setOnMousePressed(event -> {
            if (event.isSecondaryButtonDown() && !menu.getItems().isEmpty()) {
                menu.show((Node)((HBox)event.getSource()), event.getScreenX(), event.getScreenY());
                event.consume();
            } else {
                menu.hide();
            }
        });
        this.systemChooser = systemChooser;
        if (systemChooser == null) {
            this.selectedSystem = null;
        } else {
            Menu choices = systemChooser.createMenuItems((ChangeListener<ReferenceSystem>)((ChangeListener)(property, oldValue, newValue) -> this.setPositionCRS(newValue instanceof CoordinateReferenceSystem ? (CoordinateReferenceSystem)newValue : null)));
            this.selectedSystem = RecentReferenceSystems.getSelectedProperty(choices);
            menu.getItems().add((Object)choices);
            systemChooser.getItems().addListener(change -> {
                while (change.next()) {
                    if (!change.wasAdded() && !change.wasReplaced()) continue;
                    this.setReplaceablePositionCRS(this.format.getDefaultCRS());
                    break;
                }
            });
        }
        ObservableList items = menu.getItems();
        this.sampleValuesProvider = new SimpleObjectProperty((Object)this, "valueProvider");
        this.sampleValuesProvider.addListener((p, o, n) -> {
            ValuesUnderCursor.update(this, o, n);
            if (o != null) {
                items.remove((Object)o.valueChoices);
            }
            if (n != null) {
                items.add(0, (Object)n.valueChoices);
            }
            this.setSampleValuesVisible(n != null && !n.isEmpty());
        });
        if (toTrack != null && toTrack.length != 0) {
            if (toTrack.length != 1) {
                throw new IllegalArgumentException(Errors.format((short)35, (Object)"toTrack", (Object)1, (Object)toTrack.length));
            }
            this.canvas = toTrack[0];
        } else {
            this.canvas = null;
        }
        if (this.canvas != null) {
            this.sampleValuesProvider.set((Object)ValuesUnderCursor.create(this.canvas));
            this.canvas.errorProperty().addListener((p, o, n) -> this.setRenderingError((Throwable)n));
            this.canvas.renderingProperty().addListener((p, o, n) -> {
                if (!n.booleanValue()) {
                    this.applyCanvasGeometry();
                }
            });
            this.applyCanvasGeometry();
            if (this.canvas.getObjectiveCRS() != null) {
                this.registerMouseListeners();
            } else {
                this.canvas.addPropertyChangeListener("objectiveCRS", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        StatusBar.this.canvas.removePropertyChangeListener("objectiveCRS", this);
                        StatusBar.this.registerMouseListeners();
                    }
                });
            }
        }
    }

    private void registerMouseListeners() {
        Pane floatingPane = this.canvas.floatingPane;
        floatingPane.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)this);
        floatingPane.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)this);
        floatingPane.addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this);
    }

    @Override
    public final Region getView() {
        return this.view;
    }

    private void applyCanvasGeometry() {
        try {
            this.apply(this.canvas.getGridGeometry());
        }
        catch (RenderException e) {
            this.setRenderingError(e);
        }
    }

    public void applyCanvasGeometry(GridGeometry geometry) {
        this.position.setText(null);
        this.apply(geometry);
    }

    private void apply(GridGeometry geometry) {
        LinearTransform localToCRS = null;
        CoordinateReferenceSystem crs = null;
        double resolution = 1.0;
        double[] inflate = null;
        Unit unit = Units.PIXEL;
        if (geometry != null) {
            int i;
            if (geometry.isDefined(1)) {
                crs = geometry.getCoordinateReferenceSystem();
            }
            if (geometry.isDefined(8)) {
                localToCRS = geometry.getGridToCRS(PixelInCell.CELL_CENTER);
            }
            if (geometry.isDefined(16)) {
                double[] resolutions = geometry.getResolution(true);
                if (crs != null && resolutions.length != 0) {
                    CoordinateSystem cs = crs.getCoordinateSystem();
                    unit = cs.getAxis(0).getUnit();
                    for (i = 0; i < resolutions.length; ++i) {
                        double r;
                        if (!unit.equals((Object)cs.getAxis(i).getUnit()) || !((r = resolutions[i]) < resolution)) continue;
                        resolution = r;
                    }
                }
            }
            if (geometry.isDefined(4)) {
                GridExtent extent = geometry.getExtent();
                int n = extent.getDimension();
                inflate = new double[n];
                for (i = 0; i < n; ++i) {
                    inflate[i] = 0.5 / (double)extent.getSize(i) + 1.0;
                }
            }
        }
        boolean sameCRS = Utilities.equalsIgnoreMetadata((Object)this.objectiveCRS, crs);
        if (localToCRS == null) {
            localToCRS = MathTransforms.identity((int)2);
        }
        int srcDim = Math.max(localToCRS.getSourceDimensions(), 2);
        int tgtDim = localToCRS.getTargetDimensions();
        ((LocalToObjective)this.localToObjectiveCRS).setNoCheck((MathTransform)localToCRS);
        this.targetCoordinates = new GeneralDirectPosition(tgtDim);
        this.sourceCoordinates = srcDim == tgtDim ? this.targetCoordinates.coordinates : new double[srcDim];
        this.objectiveCRS = crs;
        this.localToPositionCRS = localToCRS;
        this.inflatePrecisions = inflate;
        this.precisions = null;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
        if (sameCRS) {
            this.updateLocalToPositionCRS();
            if (this.fullOperationSearchRequired != null && this.fullOperationSearchRequired.test(this.canvas)) {
                this.setPositionCRS(this.format.getDefaultCRS());
            }
        } else {
            this.objectiveToPositionCRS = null;
            this.setFormatCRS(crs, null);
            crs = OperationFinder.toGeospatial(crs, this.canvas);
            crs = this.setReplaceablePositionCRS(crs);
        }
        this.format.setGroundPrecision(Quantities.create((double)resolution, (Unit)unit));
        if (!sameCRS && this.selectedSystem != null) {
            this.selectedSystem.set((Object)crs);
        }
    }

    private void updateLocalToPositionCRS() {
        if (this.objectiveToPositionCRS != null) {
            this.localToPositionCRS = MathTransforms.concatenate((MathTransform)((MathTransform)this.localToObjectiveCRS.get()), (MathTransform)this.objectiveToPositionCRS);
        }
        this.setTargetCRS(this.format.getDefaultCRS());
    }

    private void setTargetCRS(CoordinateReferenceSystem crs) {
        int tgtDim = ReferencingUtilities.getDimension((CoordinateReferenceSystem)crs);
        if (tgtDim != 0 && tgtDim != this.targetCoordinates.getDimension()) {
            this.precisions = null;
            this.targetCoordinates = new GeneralDirectPosition(tgtDim);
            if (this.sourceCoordinates.length == tgtDim) {
                this.sourceCoordinates = this.targetCoordinates.coordinates;
            }
        }
        this.targetCoordinates.setCoordinateReferenceSystem(crs);
    }

    private CoordinateReferenceSystem setReplaceablePositionCRS(CoordinateReferenceSystem crs) {
        if (crs != null && this.systemChooser != null) {
            ComparisonMode mode = (ComparisonMode)this.systemChooser.duplicationCriterion.get();
            for (ReferenceSystem system : this.systemChooser.getItems()) {
                if (!Utilities.deepEquals((Object)crs, (Object)system, (ComparisonMode)mode)) continue;
                crs = (CoordinateReferenceSystem)system;
                break;
            }
        }
        if (crs != this.format.getDefaultCRS()) {
            this.setPositionCRS(crs);
        }
        return crs;
    }

    private void setPositionCRS(final CoordinateReferenceSystem crs) {
        if (crs != null && this.objectiveCRS != null && this.objectiveCRS != crs) {
            this.position.setTextFill((Paint)Styles.OUTDATED_TEXT);
            Envelope aoi = this.systemChooser != null ? (Envelope)this.systemChooser.areaOfInterest.get() : null;
            BackgroundThreads.execute((Runnable)((Object)new OperationFinder(this.canvas, aoi, this.objectiveCRS, crs){
                private Quantity<Length> accuracy;

                @Override
                protected MathTransform call() throws Exception {
                    MathTransform value = super.call();
                    double a = CRS.getLinearAccuracy((CoordinateOperation)this.getOperation());
                    if (a > 0.0) {
                        this.accuracy = GUIUtilities.shorter(null, a);
                    }
                    return value;
                }

                protected void succeeded() {
                    StatusBar.this.setPositionCRS(this, this.accuracy);
                }

                protected void failed() {
                    Locale locale = StatusBar.this.getLocale();
                    StatusBar.this.setErrorMessage(Resources.forLocale(locale).getString((short)9, IdentifiedObjects.getDisplayName((IdentifiedObject)crs, (Locale)locale)), this.getException());
                    StatusBar.this.selectedSystem.set((Object)StatusBar.this.format.getDefaultCRS());
                    StatusBar.this.resetPositionCRS(Styles.ERROR_TEXT);
                }

                @Override
                protected Class<?> getCallerClass() {
                    return StatusBar.class;
                }

                @Override
                protected String getCallerMethod() {
                    return "setPositionCRS";
                }
            }));
        } else {
            if (this.objectiveCRS == null) {
                this.objectiveCRS = crs;
            }
            this.position.setMinWidth(0.0);
            this.maximalPositionLength = 0;
            this.resetPositionCRS(Styles.NORMAL_TEXT);
        }
    }

    private void setPositionCRS(OperationFinder finder, Quantity<Length> accuracy) {
        this.setErrorMessage(null, null);
        this.setFormatCRS(finder.getTargetCRS(), accuracy);
        this.objectiveToPositionCRS = (MathTransform)finder.getValue();
        this.fullOperationSearchRequired = finder.fullOperationSearchRequired();
        this.updateLocalToPositionCRS();
        this.position.setTextFill((Paint)Styles.NORMAL_TEXT);
        this.position.setMinWidth(0.0);
        this.maximalPositionLength = 0;
        if (this.isPositionVisible()) {
            double x = this.lastX;
            double y = this.lastY;
            this.lastY = Double.NaN;
            this.lastX = Double.NaN;
            if (!Double.isNaN(x) && !Double.isNaN(y)) {
                this.setLocalCoordinates(x, y);
            }
        }
    }

    private void setFormatCRS(CoordinateReferenceSystem crs, Quantity<Length> accuracy) {
        int dimension;
        CoordinateSystem cs;
        this.format.setDefaultCRS(crs);
        this.format.setGroundAccuracy(Quantities.max(accuracy, this.lowestAccuracy));
        String text = IdentifiedObjects.getDisplayName((IdentifiedObject)crs, (Locale)this.getLocale());
        Tooltip tp = null;
        if (text != null) {
            tp = this.position.getTooltip();
            if (tp == null) {
                tp = new Tooltip(text);
            } else {
                tp.setText(text);
            }
        }
        this.position.setTooltip(tp);
        text = null;
        if (crs != null && (cs = crs.getCoordinateSystem()) != null && (dimension = cs.getDimension()) > 0) {
            StringBuilder b = new StringBuilder().append('(');
            for (int i = 0; i < dimension; ++i) {
                String abbr;
                CoordinateSystemAxis axis;
                if (i != 0) {
                    b.append(", ");
                }
                if ((axis = cs.getAxis(i)) != null && (abbr = Strings.trimOrNull((String)axis.getAbbreviation())) != null) {
                    b.append(abbr);
                    continue;
                }
                b.append('?');
            }
            b.append(')');
            this.format.getGroundAccuracyText().ifPresent(b::append);
            text = b.toString();
        }
        if (this.position.getText() == this.outsideText) {
            this.position.setText(text);
        }
        this.outsideText = text;
        this.setTargetCRS(crs);
        ((PositionSystem)this.positionReferenceSystem).fireValueChangedEvent();
    }

    private void resetPositionCRS(Color textFill) {
        this.objectiveToPositionCRS = null;
        this.localToPositionCRS = (MathTransform)this.localToObjectiveCRS.get();
        this.setFormatCRS(this.objectiveCRS, null);
        this.position.setTextFill((Paint)textFill);
    }

    public Quantity<Length> getLowestAccuracy() {
        return this.lowestAccuracy;
    }

    public void setLowestAccuracy(Quantity<Length> accuracy) {
        this.lowestAccuracy = accuracy;
    }

    public Optional<Point2D> getLocalCoordinates() {
        if (this.isPositionVisible() && !Double.isNaN(this.lastX) && !Double.isNaN(this.lastY)) {
            return Optional.of(new Point2D(this.lastX, this.lastY));
        }
        return Optional.empty();
    }

    public void setLocalCoordinates(double x, double y) {
        if (x != this.lastX || y != this.lastY) {
            String text;
            this.sourceCoordinates[0] = this.lastX = x;
            this.sourceCoordinates[1] = this.lastY = y;
            String values = null;
            try {
                this.convertCoordinates();
                if (this.isSampleValuesVisible) {
                    values = ((ValuesUnderCursor)this.sampleValuesProvider.get()).evaluate((DirectPosition)this.targetCoordinates);
                }
                this.targetCoordinates.normalize();
                text = this.format.format((DirectPosition)this.targetCoordinates);
            }
            catch (RuntimeException | TransformException e) {
                Exception cause = Exceptions.unwrap((Exception)e);
                text = cause.getLocalizedMessage();
                if (text == null) {
                    text = Classes.getShortClassName((Object)cause);
                }
                values = null;
            }
            this.position.setText(text);
            if (this.isSampleValuesVisible) {
                this.sampleValues.setText(values);
            }
            if (text.length() > this.maximalPositionLength) {
                this.maximalPositionLength = text.length();
                this.position.setMinWidth(Math.min(this.view.getWidth() / 2.0, Math.ceil(this.position.prefWidth(this.position.getHeight()))));
            }
        }
    }

    private void convertCoordinates() throws TransformException {
        Matrix derivative;
        try {
            derivative = MathTransforms.derivativeAndTransform((MathTransform)this.localToPositionCRS, (double[])this.sourceCoordinates, (int)0, (double[])this.targetCoordinates.coordinates, (int)0);
        }
        catch (TransformException ignore) {
            this.localToPositionCRS.transform(this.sourceCoordinates, 0, this.targetCoordinates.coordinates, 0, 1);
            derivative = null;
        }
        if (derivative == null) {
            this.precisions = null;
        } else {
            if (this.precisions == null) {
                this.precisions = new double[this.targetCoordinates.getDimension()];
            }
            int j = derivative.getNumRow();
            while (--j >= 0) {
                double p = 0.0;
                int i = derivative.getNumCol();
                while (--i >= 0) {
                    double e = Math.abs(derivative.getElement(j, i));
                    if (this.inflatePrecisions != null) {
                        e *= this.inflatePrecisions[i];
                    }
                    if (!(e > p)) continue;
                    p = e;
                }
                this.precisions[j] = p;
            }
        }
        this.format.setPrecisions(this.precisions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String formatCoordinates(double x, double y) throws TransformException {
        this.sourceCoordinates[0] = x;
        this.sourceCoordinates[1] = y;
        String separator = this.format.getSeparator();
        try {
            this.format.setSeparator("\t");
            this.convertCoordinates();
            String string = this.format.format((DirectPosition)this.targetCoordinates);
            return string;
        }
        finally {
            this.format.setSeparator(separator);
        }
    }

    public void handle(MouseEvent event) {
        if (event != null) {
            EventType type = event.getEventType();
            if (type == MouseEvent.MOUSE_MOVED || type == MouseEvent.MOUSE_ENTERED) {
                this.setLocalCoordinates(event.getX(), event.getY());
                return;
            }
            if (type != MouseEvent.MOUSE_EXITED) {
                return;
            }
        }
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
        this.position.setText(this.outsideText);
        if (this.isSampleValuesVisible) {
            this.sampleValues.setText(((ValuesUnderCursor)this.sampleValuesProvider.get()).evaluate(null));
        }
    }

    private boolean isPositionVisible() {
        if (this.position.isVisible()) {
            String text = this.position.getText();
            return text != null && text != this.outsideText;
        }
        return false;
    }

    private void setSampleValuesVisible(boolean visible) {
        ObservableList c = this.view.getChildren();
        if (visible) {
            if (this.sampleValues == null) {
                this.sampleValues = new Label();
                this.sampleValues.setAlignment(Pos.CENTER_RIGHT);
                this.sampleValues.setTextAlignment(TextAlignment.RIGHT);
                this.sampleValues.setMinWidth(Double.NEGATIVE_INFINITY);
                this.sampleValues.setMaxWidth(Double.NEGATIVE_INFINITY);
            }
            if (c.lastIndexOf((Object)this.sampleValues) < 0) {
                c.add((Object)this.sampleValues);
            }
        } else if (this.sampleValues != null) {
            this.sampleValues.setText(null);
            c.remove((Object)this.sampleValues);
        }
        this.isSampleValuesVisible = visible;
    }

    final boolean computeSizeOfSampleValues(String prototype, Iterable<String> others) {
        this.setSampleValuesVisible(prototype != null && !prototype.isEmpty());
        if (this.isSampleValuesVisible) {
            this.sampleValues.setText(prototype);
            this.sampleValues.setPrefWidth(-1.0);
            double width = this.sampleValues.prefWidth(this.sampleValues.getHeight());
            double max = Math.max(width * 1.25, 200.0);
            for (String other : others) {
                this.sampleValues.setText(other);
                double cw = this.sampleValues.prefWidth(this.sampleValues.getHeight());
                if (!(cw > width) || !((width = cw) > max)) continue;
                width = max;
                break;
            }
            this.sampleValues.setText(null);
            if (!(width > 0.0)) {
                return false;
            }
            this.sampleValues.setPrefWidth(width + 9.0);
        }
        return true;
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.message.getText());
    }

    public void setErrorMessage(String text, Throwable details) {
        text = Strings.trimOrNull((String)text);
        Button more = null;
        if (details != null) {
            Locale locale = this.getLocale();
            if (text == null && (text = Exceptions.getLocalizedMessage((Throwable)details, (Locale)locale)) == null) {
                text = details.getClass().getSimpleName();
            }
            String alert = text;
            more = new Button("\u2139\ufe0f");
            more.setOnAction(e -> ExceptionReporter.show((Node)this.getView(), Resources.forLocale(locale).getString((short)17), alert, details));
        }
        this.message.setVisible(text != null);
        this.message.setGraphic(more);
        this.message.setText(text);
        this.message.setTextFill((Paint)Styles.ERROR_TEXT);
    }

    private void setRenderingError(Throwable details) {
        String text = null;
        if (details != null) {
            text = Resources.forLocale(this.getLocale()).getString((short)8);
        }
        this.setErrorMessage(text, details);
    }

    private final class PositionSystem
    extends ReadOnlyObjectPropertyBase<ReferenceSystem> {
        private PositionSystem() {
        }

        public Object getBean() {
            return StatusBar.this;
        }

        public String getName() {
            return "positionReferenceSystem";
        }

        public ReferenceSystem get() {
            return StatusBar.this.format.getDefaultCRS();
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }

    private final class LocalToObjective
    extends ObjectPropertyBase<MathTransform> {
        LocalToObjective() {
            super((Object)MathTransforms.identity((int)2));
        }

        public Object getBean() {
            return StatusBar.this;
        }

        public String getName() {
            return "localToObjectiveCRS";
        }

        final void setNoCheck(MathTransform newValue) {
            super.set((Object)newValue);
        }

        public void set(MathTransform newValue) {
            ArgumentChecks.ensureNonNull((String)"newValue", (Object)newValue);
            MathTransform oldValue = (MathTransform)this.get();
            ArgumentChecks.ensureDimensionsMatch((String)"newValue", (int)oldValue.getSourceDimensions(), (int)oldValue.getTargetDimensions(), (MathTransform)newValue);
            super.set((Object)newValue);
            StatusBar.this.updateLocalToPositionCRS();
        }
    }
}

