/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.GestureEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.gui.referencing.PositionableProjection;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.MouseDrags;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.portrayal.PlanarCanvas;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public abstract class MapCanvas
extends PlanarCanvas {
    private static final double SCROLL_EVENT_SIZE = 40.0;
    private static final double ZOOM_FACTOR = 0.1;
    private static final double CONTROL_KEY_FACTOR = 10.0;
    private static final long REPAINT_DELAY = 100L;
    private static final long WAIT_CURSOR_DELAY = 900000000L;
    protected final Pane floatingPane;
    protected final StackPane fixedPane;
    private Envelope objectiveBounds;
    private int contentChangeCount;
    private int renderedContentStamp;
    private long renderingStartTime;
    private Task<?> renderingInProgress;
    private Runnable afterRendering;
    private boolean sizeChanged;
    private boolean invalidObjectiveToDisplay;
    private final Affine transform = new Affine();
    private final Affine changeInProgress = new Affine();
    private double xPanStart;
    private double yPanStart;
    private boolean isDragging;
    private boolean isMouseChangeScheduled;
    private boolean isNavigationDisabled;
    private final ReadOnlyBooleanWrapper isRendering;
    private final ReadOnlyObjectWrapper<Throwable> error;
    private boolean hasError;
    private ContextMenu menuShown;

    public MapCanvas(Locale locale) {
        super(locale);
        Pane view = new Pane(){

            protected void layoutChildren() {
                super.layoutChildren();
                if (MapCanvas.this.contentsChanged()) {
                    MapCanvas.this.repaint();
                }
            }
        };
        view.getTransforms().add((Object)this.transform);
        view.setOnZoom(e -> this.applyZoomOrRotate((GestureEvent)e, e.getZoomFactor(), 0.0));
        view.setOnRotate(e -> this.applyZoomOrRotate((GestureEvent)e, 1.0, e.getAngle()));
        view.setOnScroll(this::onScroll);
        view.setFocusTraversable(true);
        view.addEventHandler(KeyEvent.KEY_PRESSED, this::onKeyTyped);
        MouseDrags.setHandlers((Region)view, (EventHandler<? super MouseEvent>)((EventHandler)this::onDrag));
        view.layoutBoundsProperty().addListener(p -> this.onSizeChanged());
        view.setCursor(Cursor.CROSSHAIR);
        this.floatingPane = view;
        this.fixedPane = new StackPane(new Node[]{view});
        GUIUtilities.setClipToBounds((Pane)this.fixedPane);
        this.isRendering = new ReadOnlyBooleanWrapper((Object)this, "isRendering");
        this.error = new ReadOnlyObjectWrapper((Object)this, "error");
    }

    Bounds getBoundsInParent() {
        return null;
    }

    private void onSizeChanged() {
        this.sizeChanged = true;
        Bounds bp = this.getBoundsInParent();
        if (bp != null && bp.getMinX() <= 0.0 && bp.getMinY() <= 0.0 && bp.getMaxX() >= this.floatingPane.getWidth() && bp.getMaxY() >= this.floatingPane.getHeight()) {
            return;
        }
        this.requestRepaint();
    }

    private void onDrag(MouseEvent event) {
        double x = event.getX();
        double y = event.getY();
        EventType type = event.getEventType();
        if (type == MouseEvent.MOUSE_PRESSED) {
            switch (event.getButton()) {
                case PRIMARY: {
                    this.hideContextMenu();
                    if (!this.isNavigationDisabled) {
                        this.floatingPane.setCursor(Cursor.CLOSED_HAND);
                        this.floatingPane.requestFocus();
                        this.isDragging = true;
                        this.xPanStart = x;
                        this.yPanStart = y;
                    }
                    event.consume();
                }
            }
        } else if (this.isDragging) {
            if (type != MouseEvent.MOUSE_DRAGGED) {
                if (this.floatingPane.getCursor() == Cursor.CLOSED_HAND) {
                    this.floatingPane.setCursor(Cursor.CROSSHAIR);
                }
                this.isDragging = false;
            }
            this.applyTranslation(x - this.xPanStart, y - this.yPanStart, type == MouseEvent.MOUSE_RELEASED);
            event.consume();
        }
    }

    private void restoreCursorAfterPaint() {
        this.floatingPane.setCursor(this.isDragging ? Cursor.CLOSED_HAND : Cursor.CROSSHAIR);
    }

    private void applyTranslation(double tx, double ty, boolean isFinal) {
        if (tx != 0.0 || ty != 0.0) {
            this.transform.appendTranslation(tx, ty);
            if (!isFinal) {
                this.requestRepaint();
                return;
            }
        }
        if (isFinal && !this.transform.isIdentity()) {
            this.repaint();
        }
    }

    private void onScroll(ScrollEvent event) {
        if (event.getTouchCount() != 0) {
            return;
        }
        if (this.isNavigationDisabled) {
            event.consume();
            return;
        }
        double delta = event.getDeltaY();
        double zoom = Math.abs(delta) / 40.0 * 0.1;
        if (event.isControlDown()) {
            zoom /= 10.0;
        }
        zoom += 1.0;
        if (delta < 0.0) {
            zoom = 1.0 / zoom;
        }
        this.applyZoomOrRotate((GestureEvent)event, zoom, 0.0);
    }

    private void applyZoomOrRotate(GestureEvent event, double zoom, double angle) {
        if (!(this.isNavigationDisabled || zoom == 1.0 && angle == 0.0)) {
            double y;
            double x;
            if (event != null) {
                x = event.getX();
                y = event.getY();
            } else {
                Bounds bounds = this.floatingPane.getLayoutBounds();
                x = bounds.getCenterX();
                y = bounds.getCenterY();
                try {
                    Point2D p = this.transform.inverseTransform(x, y);
                    x = p.getX();
                    y = p.getY();
                }
                catch (NonInvertibleTransformException e) {
                    MapCanvas.unexpectedException("onKeyTyped", (Exception)((Object)e));
                }
            }
            if (zoom != 1.0) {
                this.transform.appendScale(zoom, zoom, x, y);
            }
            if (angle != 0.0) {
                this.transform.appendRotation(angle, x, y);
            }
            this.requestRepaint();
        }
        if (event != null) {
            event.consume();
        }
    }

    private void onKeyTyped(KeyEvent event) {
        double angle;
        double zoom;
        double ty;
        double tx;
        block18: {
            block17: {
                if (this.isNavigationDisabled) {
                    event.consume();
                    return;
                }
                tx = 0.0;
                ty = 0.0;
                zoom = 1.0;
                angle = 0.0;
                if (!event.isAltDown()) break block17;
                switch (event.getCode()) {
                    case RIGHT: 
                    case KP_RIGHT: {
                        angle = 7.5;
                        break block18;
                    }
                    case LEFT: 
                    case KP_LEFT: {
                        angle = -7.5;
                        break block18;
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (event.getCode()) {
                case RIGHT: 
                case KP_RIGHT: {
                    tx = -40.0;
                    break;
                }
                case LEFT: 
                case KP_LEFT: {
                    tx = 40.0;
                    break;
                }
                case DOWN: 
                case KP_DOWN: {
                    ty = -40.0;
                    break;
                }
                case UP: 
                case KP_UP: {
                    ty = 40.0;
                    break;
                }
                case PAGE_UP: {
                    zoom = 0.9090909090909091;
                    break;
                }
                case PAGE_DOWN: {
                    zoom = 1.1;
                    break;
                }
                case HOME: {
                    this.reset();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (event.isControlDown()) {
            tx /= 10.0;
            ty /= 10.0;
            angle /= 10.0;
            zoom = (zoom - 1.0) / 10.0 + 1.0;
        }
        try {
            Point2D p = this.transform.inverseDeltaTransform(tx, ty);
            tx = p.getX();
            ty = p.getY();
        }
        catch (NonInvertibleTransformException e) {
            MapCanvas.unexpectedException("onKeyTyped", (Exception)((Object)e));
        }
        this.applyZoomOrRotate(null, zoom, angle);
        this.applyTranslation(tx, ty, false);
        event.consume();
    }

    public void reset() {
        this.invalidObjectiveToDisplay = true;
        this.requestRepaint();
    }

    final void setNavigationDisabled(boolean disabled) {
        this.isNavigationDisabled = disabled;
        if (disabled) {
            this.isDragging = false;
        }
        this.floatingPane.setCursor(disabled ? Cursor.DEFAULT : Cursor.CROSSHAIR);
    }

    private void hideContextMenu() {
        if (this.menuShown != null) {
            this.menuShown.hide();
            this.menuShown = null;
        }
    }

    private void setObjectiveCRS(CoordinateReferenceSystem crs, DirectPosition anchor, ObservableValue<? extends ReferenceSystem> property) {
        CoordinateReferenceSystem previous = this.getObjectiveCRS();
        if (crs != previous) {
            try {
                Envelope2D bounds;
                if (anchor == null && (bounds = this.getDisplayBounds()) != null) {
                    anchor = AbstractEnvelope.castOrCopy((Envelope)bounds).getMedian();
                }
                this.setObjectiveCRS(crs, anchor);
                this.requestRepaint();
            }
            catch (Exception e) {
                if (property instanceof WritableValue) {
                    ((WritableValue)property).setValue((Object)previous);
                }
                this.errorOccurred(e);
                Locale locale = this.getLocale();
                Resources i18n = Resources.forLocale(locale);
                ExceptionReporter.show((Node)this.fixedPane, null, i18n.getString((short)9, IdentifiedObjects.getDisplayName((IdentifiedObject)crs, (Locale)locale)), (Throwable)e);
            }
        }
    }

    protected void setObjectiveBounds(Envelope visibleArea) {
        ArgumentChecks.ensureDimensionMatches((String)"visibleArea", (int)2, (Envelope)visibleArea);
        this.objectiveBounds = ImmutableEnvelope.castOrCopy((Envelope)visibleArea);
        this.invalidObjectiveToDisplay = true;
    }

    private static AxisDirection[] toDisplayDirections(AxisDirection[] srcAxes) {
        Object[] dstAxes = Arrays.copyOf(srcAxes, 2);
        if (AxisDirections.absolute((AxisDirection)dstAxes[0]) == AxisDirection.NORTH && AxisDirections.absolute((AxisDirection)dstAxes[1]) == AxisDirection.EAST) {
            ArraysExt.swap((Object[])dstAxes, (int)0, (int)1);
        }
        if (AxisDirections.absolute((AxisDirection)dstAxes[0]) == AxisDirection.WEST) {
            dstAxes[0] = AxisDirection.EAST;
        }
        if (AxisDirections.absolute((AxisDirection)dstAxes[1]) == AxisDirection.NORTH) {
            dstAxes[1] = AxisDirection.SOUTH;
        }
        return dstAxes;
    }

    protected abstract Renderer createRenderer();

    final boolean contentsChanged() {
        return this.contentChangeCount != this.renderedContentStamp;
    }

    public final void requestRepaint() {
        ++this.contentChangeCount;
        if (this.renderingInProgress == null && !this.isRendering.get()) {
            Delayed delay = new Delayed();
            BackgroundThreads.execute((Runnable)((Object)delay));
            this.renderingInProgress = delay;
        }
    }

    final void repaint() {
        assert (Platform.isFxApplicationThread());
        if (this.renderingInProgress != null) {
            if (this.renderingInProgress instanceof Delayed) {
                this.renderingInProgress.cancel(true);
                this.renderingInProgress = null;
            } else {
                ++this.contentChangeCount;
                return;
            }
        }
        this.hasError = false;
        this.isRendering.set(true);
        this.renderingStartTime = System.nanoTime();
        try {
            if (this.sizeChanged) {
                this.sizeChanged = false;
                Pane view = this.floatingPane;
                Envelope2D bounds = new Envelope2D(null, view.getLayoutX(), view.getLayoutY(), view.getWidth(), view.getHeight());
                if (bounds.isEmpty()) {
                    return;
                }
                this.setDisplayBounds((Envelope)bounds);
            }
            if (this.invalidObjectiveToDisplay) {
                LinearTransform crsToDisplay;
                EngineeringCRS objectiveCRS;
                Envelope2D target = this.getDisplayBounds();
                if (target == null) {
                    return;
                }
                this.invalidObjectiveToDisplay = false;
                GridExtent extent = new GridExtent(null, new long[]{Math.round(target.getMinX()), Math.round(target.getMinY())}, new long[]{Math.round(target.getMaxX()), Math.round(target.getMaxY())}, false);
                if (this.objectiveBounds != null) {
                    MatrixSIS m;
                    objectiveCRS = this.objectiveBounds.getCoordinateReferenceSystem();
                    if (objectiveCRS != null) {
                        AxisDirection[] srcAxes = CoordinateSystems.getAxisDirections((CoordinateSystem)objectiveCRS.getCoordinateSystem());
                        m = Matrices.createTransform((Envelope)this.objectiveBounds, (AxisDirection[])srcAxes, (Envelope)target, (AxisDirection[])MapCanvas.toDisplayDirections(srcAxes));
                    } else {
                        m = Matrices.createTransform((Envelope)this.objectiveBounds, (Envelope)target);
                    }
                    Matrices.forceUniformScale((Matrix)m, (double)0.0, (double[])new double[]{target.getCenterX(), target.getCenterY()});
                    crsToDisplay = MathTransforms.linear((Matrix)m);
                    if (objectiveCRS == null) {
                        objectiveCRS = extent.toEnvelope((MathTransform)crsToDisplay.inverse()).getCoordinateReferenceSystem();
                    }
                } else {
                    objectiveCRS = this.getDisplayCRS();
                    crsToDisplay = MathTransforms.identity((int)2);
                }
                this.setGridGeometry(new GridGeometry(extent, PixelInCell.CELL_CORNER, (MathTransform)crsToDisplay.inverse(), (CoordinateReferenceSystem)objectiveCRS));
                this.transform.setToIdentity();
            }
        }
        catch (RenderException | TransformException ex) {
            this.restoreCursorAfterPaint();
            this.isRendering.set(false);
            this.errorOccurred(ex);
            return;
        }
        this.changeInProgress.setToTransform((Transform)this.transform);
        if (!this.transform.isIdentity()) {
            this.transformDisplayCoordinates(new AffineTransform(this.transform.getMxx(), this.transform.getMyx(), this.transform.getMxy(), this.transform.getMyy(), this.transform.getTx(), this.transform.getTy()));
        }
        this.renderedContentStamp = this.contentChangeCount;
        Renderer context = this.createRenderer();
        if (context != null && context.initialize(this.floatingPane)) {
            Task<?> worker = this.createWorker(context);
            assert (this.renderingInProgress == null);
            BackgroundThreads.execute(worker);
            this.renderingInProgress = worker;
            if (!this.isMouseChangeScheduled) {
                DelayedExecutor.schedule((DelayedRunnable)new CursorChange());
                this.isMouseChangeScheduled = true;
            }
        } else {
            if (!this.hasError) {
                this.clearError();
            }
            this.isRendering.set(false);
            this.restoreCursorAfterPaint();
        }
    }

    Task<?> createWorker(final Renderer renderer) {
        return new Task<Void>(){

            protected Void call() throws Exception {
                renderer.render();
                return null;
            }

            protected void succeeded() {
                boolean done = renderer.commit(MapCanvas.this);
                MapCanvas.this.renderingCompleted(this);
                if (!done || MapCanvas.this.contentsChanged()) {
                    MapCanvas.this.repaint();
                }
            }

            protected void failed() {
                MapCanvas.this.renderingCompleted(this);
            }

            protected void cancelled() {
                MapCanvas.this.renderingCompleted(this);
            }
        };
    }

    final void renderingCompleted(Task<?> task) {
        assert (Platform.isFxApplicationThread());
        if (!this.contentsChanged() || task.getState() != Worker.State.SUCCEEDED) {
            this.restoreCursorAfterPaint();
        }
        this.renderingInProgress = null;
        Point2D p = this.changeInProgress.transform(this.xPanStart, this.yPanStart);
        this.xPanStart = p.getX();
        this.yPanStart = p.getY();
        try {
            this.changeInProgress.invert();
            this.transform.prepend((Transform)this.changeInProgress);
        }
        catch (NonInvertibleTransformException e) {
            MapCanvas.unexpectedException("repaint", (Exception)((Object)e));
        }
        this.isRendering.set(false);
        Throwable ex = task.getException();
        if (ex != null) {
            this.errorOccurred(ex);
        } else if (!this.hasError) {
            this.clearError();
        }
        Runnable t = this.afterRendering;
        if (t != null) {
            try {
                this.afterRendering = null;
                t.run();
            }
            catch (Exception e) {
                MapCanvas.unexpectedException("runAfterRendering", e);
            }
        }
    }

    private void paintAfterDelay() {
        if (this.renderingInProgress instanceof Delayed) {
            this.renderingInProgress = null;
            this.repaint();
        }
    }

    private void setWaitCursor(long startTime) {
        this.isMouseChangeScheduled = false;
        if (this.renderingInProgress != null) {
            if (startTime == this.renderingStartTime) {
                this.floatingPane.setCursor(Cursor.WAIT);
            }
            DelayedExecutor.schedule((DelayedRunnable)new CursorChange());
            this.isMouseChangeScheduled = true;
        }
    }

    public final ReadOnlyBooleanProperty renderingProperty() {
        return this.isRendering.getReadOnlyProperty();
    }

    public final ReadOnlyObjectProperty<Throwable> errorProperty() {
        return this.error.getReadOnlyProperty();
    }

    protected final void clearError() {
        this.hasError = false;
        this.error.set(null);
    }

    protected void errorOccurred(Throwable ex) {
        Throwable current;
        if (this.hasError && (current = (Throwable)this.error.get()) != null) {
            current.addSuppressed(ex);
            return;
        }
        this.hasError = true;
        this.error.set((Object)Objects.requireNonNull(ex));
    }

    private static void unexpectedException(String method, Exception e) {
        Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.gui"), MapCanvas.class, (String)method, (Throwable)e);
    }

    protected boolean runAfterRendering(Runnable task) {
        ArgumentChecks.ensureNonNull((String)"task", (Object)task);
        assert (Platform.isFxApplicationThread());
        if (this.renderingInProgress == null || this.renderingInProgress instanceof Delayed) {
            task.run();
            return true;
        }
        Runnable before = this.afterRendering;
        this.afterRendering = before == null ? task : () -> {
            try {
                before.run();
            }
            catch (Exception e) {
                MapCanvas.unexpectedException("runAfterRendering", e);
            }
            task.run();
        };
        return false;
    }

    protected void clear() {
        assert (Platform.isFxApplicationThread());
        this.transform.setToIdentity();
        this.changeInProgress.setToIdentity();
        this.invalidObjectiveToDisplay = true;
        this.objectiveBounds = null;
        this.clearError();
        this.isDragging = false;
        this.isNavigationDisabled = false;
        this.isRendering.set(false);
        this.requestRepaint();
    }

    private final class Delayed
    extends Task<Void> {
        private Delayed() {
        }

        protected Void call() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        protected void succeeded() {
            MapCanvas.this.paintAfterDelay();
        }

        protected void failed() {
            MapCanvas.this.paintAfterDelay();
        }
    }

    protected static abstract class Renderer {
        private int width;
        private int height;

        protected Renderer() {
        }

        private boolean initialize(Pane view) {
            this.width = Numerics.clamp((long)Math.round(view.getWidth()));
            this.height = Numerics.clamp((long)Math.round(view.getHeight()));
            return this.width > 0 && this.height > 0;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        protected abstract void render() throws Exception;

        protected abstract boolean commit(MapCanvas var1);
    }

    private final class CursorChange
    extends DelayedRunnable {
        private final long startTime;

        CursorChange() {
            super(MapCanvas.this.renderingStartTime + 900000000L);
            this.startTime = MapCanvas.this.renderingStartTime;
        }

        public void run() {
            Platform.runLater(() -> MapCanvas.this.setWaitCursor(this.startTime));
        }
    }

    final class MenuHandler
    extends DirectPosition2D
    implements EventHandler<MouseEvent>,
    ChangeListener<ReferenceSystem>,
    PropertyChangeListener {
        private final ContextMenu menu;
        ObjectProperty<ReferenceSystem> selectedCrsProperty;
        ToggleGroup positionables;
        private boolean isPositionableProjection;

        MenuHandler(ContextMenu menu) {
            super((CoordinateReferenceSystem)MapCanvas.this.getDisplayCRS());
            this.menu = menu;
            MapCanvas.this.fixedPane.setOnMousePressed((EventHandler)this);
            MapCanvas.this.fixedPane.setOnMouseReleased((EventHandler)this);
        }

        public void handle(MouseEvent event) {
            if (event.isPopupTrigger()) {
                MapCanvas.this.hideContextMenu();
                this.x = event.getX();
                this.y = event.getY();
                this.menu.show((Node)((Pane)event.getSource()), event.getScreenX(), event.getScreenY());
                MapCanvas.this.menuShown = this.menu;
                event.consume();
            }
        }

        public void changed(ObservableValue<? extends ReferenceSystem> property, ReferenceSystem oldValue, ReferenceSystem newValue) {
            if (newValue instanceof CoordinateReferenceSystem) {
                MapCanvas.this.setObjectiveCRS((CoordinateReferenceSystem)newValue, (DirectPosition)this, property);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void createProjectedCRS(PositionableProjection projection) {
            try {
                DirectPosition2D center = new DirectPosition2D();
                center = (DirectPosition2D)MapCanvas.this.objectiveToDisplay.inverseTransform((java.awt.geom.Point2D)((Object)this), (java.awt.geom.Point2D)center);
                center.setCoordinateReferenceSystem(MapCanvas.this.getObjectiveCRS());
                ProjectedCRS crs = projection.createProjectedCRS((DirectPosition)center);
                try {
                    this.isPositionableProjection = true;
                    MapCanvas.this.setObjectiveCRS((CoordinateReferenceSystem)crs, (DirectPosition)this, null);
                }
                finally {
                    this.isPositionableProjection = false;
                }
            }
            catch (Exception e) {
                MapCanvas.this.errorOccurred(e);
                Resources i18n = Resources.forLocale(MapCanvas.this.getLocale());
                ExceptionReporter.show((Node)MapCanvas.this.fixedPane, null, i18n.getString((short)9, (Object)projection), (Throwable)e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("objectiveCRS".equals(event.getPropertyName())) {
                Object value = event.getNewValue();
                if (value instanceof CoordinateReferenceSystem) {
                    this.selectedCrsProperty.set((Object)((CoordinateReferenceSystem)value));
                }
                if (!this.isPositionableProjection) {
                    this.positionables.selectToggle(null);
                }
            }
        }
    }
}

