/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.stage.Stage;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.dataset.DataWindow;
import org.apache.sis.gui.dataset.SelectedData;
import org.apache.sis.internal.gui.Resources;

abstract class WindowManager
extends Widget {
    private final List<MenuItem> newWindowMenus = new ArrayList<MenuItem>(3);
    private ObservableList<MenuItem> showWindowMenus;
    public final ReadOnlyBooleanProperty hasWindowsProperty = new WindowsProperty();

    WindowManager() {
    }

    abstract Resources localized();

    @Override
    public final Locale getLocale() {
        return this.localized().getLocale();
    }

    public final MenuItem createNewWindowMenu() {
        MenuItem menu = this.localized().menu((short)26, (EventHandler<ActionEvent>)((EventHandler)e -> this.newDataWindow()));
        menu.setDisable(true);
        this.newWindowMenus.add(menu);
        return menu;
    }

    public void setWindowsItems(ObservableList<MenuItem> items) {
        this.showWindowMenus = items;
    }

    final void setNewWindowDisabled(boolean disabled) {
        for (MenuItem m : this.newWindowMenus) {
            m.setDisable(disabled);
        }
    }

    abstract SelectedData getSelectedData();

    private void newDataWindow() {
        SelectedData selection = this.getSelectedData();
        if (selection != null) {
            DataWindow window = new DataWindow((Stage)this.getView().getScene().getWindow(), selection);
            window.setTitle(selection.title + " \u2014 Apache SIS");
            window.show();
            if (this.showWindowMenus != null) {
                int insertAt = this.showWindowMenus.size();
                do {
                    if (--insertAt >= 0) continue;
                    insertAt = 0;
                    this.showWindowMenus.add(0, (Object)new SeparatorMenuItem());
                    ((WindowsProperty)this.hasWindowsProperty).set(true);
                    break;
                } while (!(this.showWindowMenus.get(insertAt) instanceof SeparatorMenuItem));
                MenuItem menu = new MenuItem(selection.title);
                menu.setOnAction(e -> window.toFront());
                this.showWindowMenus.add(insertAt, (Object)menu);
                window.setOnHidden(e -> this.removeDataWindow(menu));
            }
        }
    }

    private void removeDataWindow(MenuItem menu) {
        ObservableList<MenuItem> items = this.showWindowMenus;
        if (items != null) {
            int i = items.size();
            while (--i >= 0) {
                if (items.get(i) != menu) continue;
                items.remove(i);
                if (i != 0) break;
                if (!items.isEmpty()) {
                    if (!(items.get(0) instanceof SeparatorMenuItem)) break;
                    items.remove(0);
                }
                ((WindowsProperty)this.hasWindowsProperty).set(false);
                break;
            }
        }
    }

    private final class WindowsProperty
    extends ReadOnlyBooleanPropertyBase {
        private boolean hasWindows;

        private WindowsProperty() {
        }

        final void set(boolean value) {
            this.hasWindows = value;
            this.fireValueChangedEvent();
        }

        public boolean get() {
            return this.hasWindows;
        }

        public Object getBean() {
            return WindowManager.this;
        }

        public String getName() {
            return "hasWindows";
        }
    }
}

