/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Labeled;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.apache.sis.gui.dataset.SelectedData;
import org.apache.sis.internal.gui.ToolbarButton;

final class DataWindow
extends Stage {
    private final ToolBar tools;

    DataWindow(Stage home, SelectedData data) {
        Region content = data.createView();
        Button mainWindow = new Button("\u2302\ufe0f");
        mainWindow.setTooltip(new Tooltip(data.localized.getString((short)25)));
        mainWindow.setOnAction(e -> {
            home.show();
            home.toFront();
        });
        Button fullScreen = new Button("\u21f1\ufe0f");
        fullScreen.setTooltip(new Tooltip(data.localized.getString((short)22)));
        fullScreen.setOnAction(e -> this.setFullScreen(true));
        this.fullScreenProperty().addListener((source, oldValue, newValue) -> this.onFullScreen((boolean)newValue));
        this.tools = new ToolBar(new Node[]{mainWindow, fullScreen});
        this.tools.getItems().addAll((Object[])ToolbarButton.remove((Node)content));
        Font font = Font.font((double)20.0);
        for (Node node : this.tools.getItems()) {
            if (!(node instanceof Labeled)) continue;
            ((Labeled)node).setFont(font);
        }
        BorderPane pane = new BorderPane();
        pane.setTop((Node)this.tools);
        pane.setCenter((Node)content);
        this.setScene(new Scene((Parent)pane));
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        this.setWidth(0.8 * bounds.getWidth());
        this.setHeight(0.8 * bounds.getHeight());
    }

    private void onFullScreen(boolean entering) {
        BorderPane pane = (BorderPane)this.getScene().getRoot();
        pane.setTop((Node)(entering ? null : this.tools));
    }
}

