/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.apache.sis.gui.coverage.CoverageExplorer;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.util.resources.IndexedResourceBundle;

abstract class ViewAndControls {
    private static final Insets CAPTION_MARGIN = new Insets(12.0, 0.0, 6.0, 0.0);
    private static final Insets NEXT_CAPTION_MARGIN = new Insets(30.0, 0.0, 6.0, 0.0);
    static final Insets CONTENT_MARGIN = new Insets(0.0, 0.0, 0.0, Styles.FORM_INSETS.getLeft());
    Toggle selector;
    private Accordion controls;
    protected final CoverageExplorer owner;

    ViewAndControls(CoverageExplorer owner) {
        this.owner = owner;
    }

    static Label label(IndexedResourceBundle vocabulary, short key, Control control) {
        if (control == null) {
            return null;
        }
        control.setMaxWidth(Double.POSITIVE_INFINITY);
        Label label = new Label(vocabulary.getLabel(key));
        label.setLabelFor((Node)control);
        return label;
    }

    static Label labelOfGroup(IndexedResourceBundle vocabulary, short key, Region group, boolean isFirst) {
        Label label = new Label(vocabulary.getString(key));
        label.setPadding(isFirst ? CAPTION_MARGIN : NEXT_CAPTION_MARGIN);
        label.setLabelFor((Node)group);
        label.setFont(ViewAndControls.fontOfGroup());
        return label;
    }

    private static Font fontOfGroup() {
        return Font.font(null, (FontWeight)FontWeight.BOLD, (double)-1.0);
    }

    abstract Region view();

    abstract TitledPane[] controlPanes();

    final Accordion controls() {
        if (this.controls == null) {
            TitledPane[] panes = this.controlPanes();
            this.controls = new Accordion(panes);
            this.controls.setExpandedPane(panes[0]);
            SplitPane.setResizableWithParent((Node)this.controls, (Boolean)Boolean.FALSE);
        }
        return this.controls;
    }

    abstract void load(ImageRequest var1);
}

