/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.Background;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.apache.sis.gui.Widget;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.internal.gui.ImmutableObjectProperty;
import org.apache.sis.internal.gui.PropertyValueFormatter;
import org.apache.sis.internal.gui.PropertyView;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Vocabulary;

public class ImagePropertyExplorer
extends Widget {
    public final ObjectProperty<RenderedImage> image;
    private Rectangle visibleImageBounds;
    private final Map<RenderedImage, Boolean> imageUseBoundsCS;
    public final BooleanProperty updateOnChange;
    private boolean listening;
    private final TreeItem<RenderedImage> sourcesRoot;
    private final ReadOnlyObjectProperty<TreeItem<RenderedImage>> selectedImage;
    private final ObservableList<LayoutRow> layoutRows;
    private final ObjectProperty<Predicate<? super LayoutRow>> layoutFilter;
    private final ObservableList<PropertyRow> propertyRows;
    private final ReadOnlyObjectProperty<PropertyRow> selectedProperty;
    private final Tab detailsTab;
    private final PropertyView propertyDetails;
    private final TabPane view;

    public ImagePropertyExplorer() {
        this(null, null);
    }

    ImagePropertyExplorer(Locale locale, ObjectProperty<Background> background) {
        Vocabulary vocabulary = Vocabulary.getResources((Locale)locale);
        Resources resources = Resources.forLocale(locale);
        this.image = new ImageProperty();
        this.imageUseBoundsCS = new IdentityHashMap<RenderedImage, Boolean>(4);
        this.updateOnChange = new SimpleBooleanProperty((Object)this, "updateOnChange", true);
        this.listening = true;
        this.sourcesRoot = new TreeItem();
        TreeView sources = new TreeView(this.sourcesRoot);
        this.selectedImage = sources.getSelectionModel().selectedItemProperty();
        sources.setCellFactory(SourceCell::new);
        this.selectedImage.addListener((p, o, n) -> {
            RenderedImage selected = null;
            if (n != null) {
                selected = (RenderedImage)n.getValue();
            }
            this.imageSelected(selected != null ? selected : (RenderedImage)this.image.get());
        });
        this.layoutRows = FXCollections.observableArrayList((Object[])LayoutRow.values(vocabulary, resources));
        FilteredList filtered = new FilteredList(this.layoutRows);
        TableView layout = new TableView((ObservableList)filtered);
        this.layoutFilter = filtered.predicateProperty();
        NumberFormat integerFormat = NumberFormat.getIntegerInstance();
        layout.setSelectionModel(null);
        TableColumn label = new TableColumn(resources.getString((short)40));
        TableColumn xCol = new TableColumn(resources.getString((short)35, "X"));
        TableColumn yCol = new TableColumn(resources.getString((short)35, "Y"));
        Callback cellFactory = column -> new LayoutCell(integerFormat);
        xCol.setCellFactory(cellFactory);
        yCol.setCellFactory(cellFactory);
        xCol.setCellValueFactory(cell -> ((LayoutRow)((Object)((Object)cell.getValue()))).xp);
        yCol.setCellValueFactory(cell -> ((LayoutRow)((Object)((Object)cell.getValue()))).yp);
        label.setCellValueFactory(cell -> (ObservableValue)cell.getValue());
        layout.getColumns().setAll((Object[])new TableColumn[]{label, xCol, yCol});
        layout.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        layout.getColumns().forEach(c -> {
            c.setReorderable(false);
            c.setSortable(false);
        });
        TableView properties = new TableView();
        this.propertyRows = properties.getItems();
        this.selectedProperty = properties.getSelectionModel().selectedItemProperty();
        TableColumn label2 = new TableColumn(vocabulary.getString((short)238));
        TableColumn value = new TableColumn(vocabulary.getString((short)213));
        label2.setCellValueFactory(cell -> (ObservableValue)cell.getValue());
        value.setCellValueFactory(cell -> ((PropertyRow)((Object)((Object)cell.getValue()))).value);
        value.setCellFactory(column -> new PropertyCell(locale));
        properties.getColumns().setAll((Object[])new TableColumn[]{label2, value});
        properties.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        properties.getColumns().forEach(c -> c.setReorderable(false));
        this.detailsTab = new Tab(vocabulary.getString((short)62));
        this.selectedProperty.addListener((p, o, n) -> this.clearPropertyValues(false));
        this.propertyDetails = new PropertyView(locale, (ObjectProperty<Node>)this.detailsTab.contentProperty(), background);
        this.detailsTab.selectedProperty().addListener((p, o, n) -> {
            if (n.booleanValue()) {
                this.updatePropertyDetails(this.getVisibleImageBounds(this.getSelectedImage()));
            }
        });
        this.view = new TabPane(new Tab[]{new Tab(vocabulary.getString((short)182), (Node)sources), new Tab(vocabulary.getString((short)235), (Node)layout), new Tab(vocabulary.getString((short)237), (Node)properties), this.detailsTab});
        this.view.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.updateOnChange.addListener((p, o, n) -> {
            if (n.booleanValue()) {
                this.startListening();
            }
        });
    }

    private void startListening() {
        this.listening = true;
        if (this.sourcesRoot.getValue() == null) {
            this.setTreeRoot((RenderedImage)this.image.get());
            this.refreshTables();
        }
    }

    final void setImage(RenderedImage newValue, Rectangle visibleBounds) {
        this.visibleImageBounds = visibleBounds;
        ((ImageProperty)this.image).assign(newValue);
        if (this.listening) {
            boolean immediate = this.updateOnChange.get();
            this.setTreeRoot(immediate ? newValue : null);
            if (immediate) {
                this.refreshTables();
            } else {
                this.clearPropertyValues(true);
                this.listening = false;
            }
        }
    }

    private RenderedImage getSelectedImage() {
        RenderedImage selected;
        TreeItem item = (TreeItem)this.selectedImage.get();
        if (item != null && (selected = (RenderedImage)item.getValue()) != null) {
            return selected;
        }
        return (RenderedImage)this.image.get();
    }

    private void refreshTables() {
        this.imageSelected(this.getSelectedImage());
    }

    private void imageSelected(RenderedImage selected) {
        Rectangle bounds = this.getVisibleImageBounds(selected);
        int n = this.layoutRows.size();
        for (int i = 0; i < n; ++i) {
            ((LayoutRow)((Object)this.layoutRows.get(i))).update(selected, bounds, i);
        }
        this.layoutFilter.set(bounds != null ? null : LayoutRow.EXCLUDE_VISIBILITY);
        this.updatePropertyList(selected);
        if (this.detailsTab.isSelected()) {
            this.updatePropertyDetails(bounds);
        }
    }

    final Rectangle getVisibleImageBounds(RenderedImage selected) {
        return Boolean.TRUE.equals(this.imageUseBoundsCS.get(selected)) ? this.visibleImageBounds : null;
    }

    private void setTreeRoot(RenderedImage newValue) {
        this.imageUseBoundsCS.clear();
        ImagePropertyExplorer.setTreeNode(this.sourcesRoot, newValue, this.imageUseBoundsCS, this.visibleImageBounds != null);
        this.imageUseBoundsCS.values().removeIf(b -> b == false);
    }

    private static void setTreeNode(TreeItem<RenderedImage> root, RenderedImage image, Map<RenderedImage, Boolean> imageUseBoundsCS, Boolean boundsApplicable) {
        root.setValue((Object)image);
        if (imageUseBoundsCS.putIfAbsent(image, boundsApplicable) == null) {
            Vector<RenderedImage> sources;
            ObservableList children = root.getChildren();
            if (image != null && (sources = image.getSources()) != null) {
                int i;
                if (image instanceof ResampledImage) {
                    boundsApplicable = Boolean.FALSE;
                }
                int numSrc = sources.size();
                int numDst = children.size();
                int n = Math.min(numSrc, numDst);
                for (i = 0; i < n; ++i) {
                    ImagePropertyExplorer.setTreeNode((TreeItem<RenderedImage>)((TreeItem)children.get(i)), (RenderedImage)sources.get(i), imageUseBoundsCS, boundsApplicable);
                }
                while (i < numSrc) {
                    TreeItem child = new TreeItem();
                    ImagePropertyExplorer.setTreeNode((TreeItem<RenderedImage>)child, (RenderedImage)sources.get(i), imageUseBoundsCS, boundsApplicable);
                    children.add((Object)child);
                    ++i;
                }
                if (i < numDst) {
                    children.remove(i, numDst);
                }
                return;
            }
            children.clear();
        }
    }

    private void updatePropertyList(RenderedImage selected) {
        String[] properties;
        if (selected != null && (properties = selected.getPropertyNames()) != null) {
            int insertAt = 0;
            block0: for (String property : properties) {
                if (property == null) continue;
                for (int i = insertAt; i < this.propertyRows.size(); ++i) {
                    if (!((PropertyRow)((Object)this.propertyRows.get(i))).update(selected, property)) continue;
                    this.propertyRows.remove(insertAt, i);
                    insertAt = i + 1;
                    continue block0;
                }
                this.propertyRows.add(insertAt++, (Object)new PropertyRow(selected, property));
            }
            this.propertyRows.remove(insertAt, this.propertyRows.size());
            return;
        }
        this.propertyRows.clear();
    }

    private void updatePropertyDetails(Rectangle bounds) {
        PropertyRow row = (PropertyRow)((Object)this.selectedProperty.get());
        this.propertyDetails.set(row != null ? row.value.get() : null, bounds);
    }

    private void clearPropertyValues(boolean full) {
        if (this.propertyDetails != null) {
            this.propertyDetails.clear();
            this.detailsTab.setContent(null);
        }
        if (full) {
            this.propertyRows.clear();
        }
    }

    @Override
    public Region getView() {
        return this.view;
    }

    @Override
    public final Locale getLocale() {
        return this.propertyDetails.getLocale();
    }

    private final class ImageProperty
    extends ObjectPropertyBase<RenderedImage> {
        private ImageProperty() {
        }

        public Object getBean() {
            return ImagePropertyExplorer.this;
        }

        public String getName() {
            return "image";
        }

        public void set(RenderedImage newValue) {
            ImagePropertyExplorer.this.setImage(newValue, null);
        }

        void assign(RenderedImage newValue) {
            super.set((Object)newValue);
        }
    }

    private static final class LayoutRow
    extends ImmutableObjectProperty<String> {
        static final int IMAGE_SIZE = 0;
        static final int DISPLAYED_SIZE = 1;
        static final int TILE_SIZE = 2;
        static final int NUM_TILES = 3;
        static final int MIN_PIXEL = 4;
        static final int MIN_VISIBLE = 5;
        static final int MIN_TILE = 6;
        final IntegerProperty xp;
        final IntegerProperty yp;
        private final boolean core;
        static Predicate<LayoutRow> EXCLUDE_VISIBILITY = r -> r.core;

        static LayoutRow[] values(Vocabulary vocabulary, Resources resources) {
            LayoutRow[] rows = new LayoutRow[]{new LayoutRow(true, vocabulary.getString((short)234)), new LayoutRow(false, resources.getString((short)41)), new LayoutRow(true, vocabulary.getString((short)194)), new LayoutRow(true, vocabulary.getString((short)236)), new LayoutRow(true, resources.getString((short)36)), new LayoutRow(false, resources.getString((short)38)), new LayoutRow(true, resources.getString((short)37))};
            return rows;
        }

        private LayoutRow(boolean core, String label) {
            super(label);
            this.core = core;
            this.xp = new SimpleIntegerProperty();
            this.yp = new SimpleIntegerProperty();
        }

        final void update(RenderedImage image, Rectangle visibleImageBounds, int i) {
            int x = 0;
            int y = 0;
            if (image != null) {
                switch (i) {
                    case 0: {
                        x = image.getWidth();
                        y = image.getHeight();
                        break;
                    }
                    case 2: {
                        x = image.getTileWidth();
                        y = image.getTileHeight();
                        break;
                    }
                    case 3: {
                        x = image.getNumXTiles();
                        y = image.getNumYTiles();
                        break;
                    }
                    case 6: {
                        x = image.getMinTileX();
                        y = image.getMinTileY();
                        break;
                    }
                    case 4: {
                        x = image.getMinX();
                        y = image.getMinY();
                        break;
                    }
                    case 5: {
                        if (visibleImageBounds == null) break;
                        x = visibleImageBounds.x;
                        y = visibleImageBounds.y;
                        break;
                    }
                    case 1: {
                        if (visibleImageBounds == null) break;
                        x = visibleImageBounds.width;
                        y = visibleImageBounds.height;
                    }
                }
            }
            this.xp.set(x);
            this.yp.set(y);
        }
    }

    private static final class PropertyRow
    extends ImmutableObjectProperty<String> {
        final ObjectProperty<Object> value;

        PropertyRow(RenderedImage image, String property) {
            super(property);
            this.value = new SimpleObjectProperty(PropertyRow.getProperty(image, property));
        }

        final boolean update(RenderedImage image, String property) {
            if (property.equals(super.get())) {
                this.value.set(PropertyRow.getProperty(image, property));
                return true;
            }
            return false;
        }

        private static Object getProperty(RenderedImage image, String property) {
            try {
                return image.getProperty(property);
            }
            catch (RuntimeException e) {
                return e;
            }
        }

        @Override
        public String get() {
            String property = (String)super.get();
            return CharSequences.camelCaseToSentence((CharSequence)property.substring(property.lastIndexOf(46) + 1)).toString();
        }
    }

    private static final class PropertyCell
    extends TableCell<PropertyRow, Object> {
        private final PropertyValueFormatter format;
        private final StringBuilder buffer = new StringBuilder();

        PropertyCell(Locale locale) {
            this.format = new PropertyValueFormatter(this.buffer, locale);
        }

        protected void updateItem(Object value, boolean empty) {
            super.updateItem(value, empty);
            String text = null;
            if (!empty) {
                try {
                    this.buffer.setLength(0);
                    this.format.appendValue(value);
                    this.format.flush();
                    text = this.buffer.toString();
                }
                catch (IOException e) {
                    text = e.toString();
                }
            }
            this.setText(text);
        }
    }

    private static final class LayoutCell
    extends TableCell<LayoutRow, Number> {
        private final NumberFormat integerFormat;

        LayoutCell(NumberFormat integerFormat) {
            this.integerFormat = integerFormat;
            this.setAlignment(Pos.CENTER_RIGHT);
        }

        protected void updateItem(Number value, boolean empty) {
            super.updateItem((Object)value, empty);
            this.setText(value != null ? this.integerFormat.format(value) : null);
        }
    }

    private static final class SourceCell
    extends TreeCell<RenderedImage> {
        SourceCell(TreeView<RenderedImage> tree) {
        }

        protected void updateItem(RenderedImage image, boolean empty) {
            super.updateItem((Object)image, empty);
            String text = null;
            Color fill = Styles.NORMAL_TEXT;
            if (image != null) {
                String check;
                Class<?> type = image.getClass();
                while (type.getEnclosingClass() != null) {
                    type = type.getSuperclass();
                }
                text = type.getSimpleName();
                if (image instanceof PlanarImage && (check = ((PlanarImage)image).verify()) != null) {
                    text = Resources.format((short)39, text, check);
                    if (!check.equals("width") && !check.equals("height")) {
                        fill = Styles.ERROR_TEXT;
                    }
                }
            }
            this.setText(text);
            this.setTextFill((Paint)fill);
        }
    }
}

