/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.EnumMap;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Region;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.coverage.CoverageControls;
import org.apache.sis.gui.coverage.GridControls;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.coverage.ViewAndControls;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.gui.NonNullObjectProperty;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.ToolbarButton;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.ReferenceSystem;

@DefaultProperty(value="coverage")
public class CoverageExplorer
extends Widget {
    public final ObjectProperty<View> viewTypeProperty;
    public final ObjectProperty<GridCoverageResource> resourceProperty;
    public final ObjectProperty<GridCoverage> coverageProperty;
    private boolean isCoverageAdjusting;
    final RecentReferenceSystems referenceSystems;
    private final EnumMap<View, ViewAndControls> views;
    private SplitPane content;

    public CoverageExplorer() {
        this(View.TABLE);
    }

    public CoverageExplorer(View type) {
        ArgumentChecks.ensureNonNull((String)"type", (Object)((Object)type));
        this.views = new EnumMap(View.class);
        this.viewTypeProperty = new NonNullObjectProperty<View>(this, "viewType", type);
        this.resourceProperty = new SimpleObjectProperty((Object)this, "resource");
        this.coverageProperty = new SimpleObjectProperty((Object)this, "coverage");
        this.referenceSystems = new RecentReferenceSystems();
        this.referenceSystems.addUserPreferences();
        this.referenceSystems.addAlternatives("EPSG:4326", "EPSG:3395");
        this.viewTypeProperty.addListener((p, o, n) -> this.onViewTypeSet((View)((Object)n)));
        this.resourceProperty.addListener((p, o, n) -> this.onPropertySet((GridCoverageResource)n, null, this.coverageProperty));
        this.coverageProperty.addListener((p, o, n) -> this.onPropertySet(null, (GridCoverage)n, this.resourceProperty));
    }

    public CoverageExplorer(CoverageExplorer source) {
        this(source.getViewType());
        this.setCoverage(new ImageRequest(source.getResource(), source.getCoverage()));
    }

    public final CoverageCanvas getCanvas() {
        return ((CoverageControls)this.getViewAndControls((View)View.IMAGE, (boolean)false)).view;
    }

    private ViewAndControls getViewAndControls(View type, boolean load) {
        ViewAndControls c = this.views.get((Object)type);
        if (c == null) {
            switch (type) {
                case TABLE: {
                    c = new GridControls(this);
                    break;
                }
                case IMAGE: {
                    c = new CoverageControls(this);
                    break;
                }
                default: {
                    throw new AssertionError((Object)type);
                }
            }
            SplitPane.setResizableWithParent((Node)c.view(), (Boolean)Boolean.TRUE);
            this.views.put(type, c);
            load = true;
        }
        if (load) {
            GridCoverageResource resource = this.getResource();
            GridCoverage coverage = this.getCoverage();
            if (resource != null || coverage != null) {
                c.load(new ImageRequest(resource, coverage));
            }
        }
        return c;
    }

    @Override
    public final Region getView() {
        assert (Platform.isFxApplicationThread());
        if (this.content == null) {
            ToggleGroup group = new ToggleGroup();
            Control[] buttons = new Control[3];
            Resources localized = Resources.forLocale(this.getLocale());
            buttons[0] = new Separator();
            for (View type : View.values()) {
                buttons[1 + type.ordinal()] = new Selector(type).createButton(group, type.icon, localized, type.tooltip);
            }
            View type = this.getViewType();
            ViewAndControls c = this.getViewAndControls(type, false);
            group.selectToggle((Toggle)group.getToggles().get(type.ordinal()));
            this.content = new SplitPane(new Node[]{c.controls(), c.view()});
            ToolbarButton.insert((Node)this.content, buttons);
            this.content.setDividerPosition(0, 1.0);
        }
        return this.content;
    }

    public final Region getDataView(View type) {
        assert (Platform.isFxApplicationThread());
        ArgumentChecks.ensureNonNull((String)"type", (Object)((Object)type));
        return this.getViewAndControls(type, false).view();
    }

    public final TitledPane[] getControls(View type) {
        assert (Platform.isFxApplicationThread());
        ArgumentChecks.ensureNonNull((String)"type", (Object)((Object)type));
        return (TitledPane[])this.getViewAndControls(type, false).controlPanes().clone();
    }

    public final View getViewType() {
        return (View)((Object)this.viewTypeProperty.get());
    }

    public final void setViewType(View type) {
        this.viewTypeProperty.set((Object)type);
    }

    private void onViewTypeSet(View type) {
        ViewAndControls c = this.getViewAndControls(type, true);
        if (this.content != null) {
            this.content.getItems().setAll((Object[])new Node[]{c.controls(), c.view()});
            Toggle selector = c.selector;
            if (selector != null) {
                selector.setSelected(true);
            }
        }
    }

    public final GridCoverageResource getResource() {
        return (GridCoverageResource)this.resourceProperty.get();
    }

    public final void setResource(GridCoverageResource resource) {
        this.resourceProperty.set((Object)resource);
    }

    public final GridCoverage getCoverage() {
        return (GridCoverage)this.coverageProperty.get();
    }

    public final void setCoverage(GridCoverage coverage) {
        this.coverageProperty.set((Object)coverage);
    }

    public final void setCoverage(ImageRequest source) {
        assert (Platform.isFxApplicationThread());
        ViewAndControls current = this.getViewAndControls(this.getViewType(), false);
        for (ViewAndControls c : this.views.values()) {
            c.load(c == current ? source : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPropertySet(GridCoverageResource resource, GridCoverage coverage, ObjectProperty<?> toClear) {
        if (!this.isCoverageAdjusting) {
            this.isCoverageAdjusting = true;
            try {
                toClear.set(null);
            }
            finally {
                this.isCoverageAdjusting = false;
            }
            this.setCoverage(resource != null || coverage != null ? new ImageRequest(resource, coverage) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyDataChanged(GridCoverageResource resource, GridCoverage coverage) {
        if (coverage != null) {
            GridGeometry gg = coverage.getGridGeometry();
            this.referenceSystems.areaOfInterest.set((Object)(gg.isDefined(2) ? gg.getEnvelope() : null));
            if (gg.isDefined(1)) {
                this.referenceSystems.setPreferred(true, (ReferenceSystem)gg.getCoordinateReferenceSystem());
            }
        }
        this.isCoverageAdjusting = true;
        try {
            this.setResource(resource);
            this.setCoverage(coverage);
        }
        finally {
            this.isCoverageAdjusting = false;
        }
    }

    public static enum View {
        IMAGE("\ud83d\uddfa\ufe0f", 33),
        TABLE("\ud83d\udd22\ufe0f", 34);

        static final int COUNT = 2;
        final String icon;
        final short tooltip;

        private View(String icon, short tooltip) {
            this.icon = icon;
            this.tooltip = tooltip;
        }
    }

    private final class Selector
    extends ToolbarButton {
        private final View type;

        Selector(View type) {
            this.type = type;
        }

        @Override
        public void handle(ActionEvent event) {
            Toggle button = (Toggle)event.getSource();
            if (button.isSelected()) {
                CoverageExplorer.this.setViewType(this.type);
                CoverageExplorer.this.views.get((Object)((Object)this.type)).selector = button;
            } else {
                button.setSelected(true);
            }
        }
    }
}

