/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.coverage.CoverageExplorer;
import org.apache.sis.gui.coverage.CoverageStyling;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.coverage.InterpolationConverter;
import org.apache.sis.gui.coverage.IsolineRenderer;
import org.apache.sis.gui.coverage.PropertyPaneCreator;
import org.apache.sis.gui.coverage.Stretching;
import org.apache.sis.gui.coverage.ViewAndControls;
import org.apache.sis.gui.map.MapMenu;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.gui.control.ValueColorMapper;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Vocabulary;

final class CoverageControls
extends ViewAndControls {
    final CoverageCanvas view;
    private final TableView<Category> categoryTable;
    private final IsolineRenderer isolines;
    private final TitledPane[] controls;
    private final BorderPane imageAndStatus;

    CoverageControls(CoverageExplorer owner) {
        super(owner);
        Locale locale = owner.getLocale();
        Resources resources = Resources.forLocale(locale);
        Vocabulary vocabulary = Vocabulary.getResources((Locale)locale);
        this.view = new CoverageCanvas(locale);
        this.view.setBackground(Color.BLACK);
        this.view.statusBar = new StatusBar(owner.referenceSystems, this.view);
        this.imageAndStatus = new BorderPane((Node)this.view.getView());
        this.imageAndStatus.setBottom((Node)this.view.statusBar.getView());
        MapMenu menu = new MapMenu(this.view);
        menu.addReferenceSystems(owner.referenceSystems);
        menu.addCopyOptions(this.view.statusBar);
        Label crsControl = new Label();
        crsControl.setPadding(CONTENT_MARGIN);
        crsControl.setTooltip(new Tooltip(resources.getString((short)49)));
        menu.selectedReferenceSystem().ifPresent(text -> crsControl.textProperty().bind((ObservableValue)text));
        GridPane valuesControl = Styles.createControlGrid(0, CoverageControls.label((IndexedResourceBundle)vocabulary, (short)231, InterpolationConverter.button(this.view)), CoverageControls.label((IndexedResourceBundle)vocabulary, (short)229, Stretching.createButton((ChangeListener<Stretching>)((ChangeListener)(p, o, n) -> this.view.setStyling((Stretching)((Object)n))))));
        CoverageStyling styling = new CoverageStyling(this.view);
        this.categoryTable = styling.createCategoryTable(resources, vocabulary);
        VBox.setVgrow(this.categoryTable, (Priority)Priority.ALWAYS);
        VBox displayPane = new VBox(new Node[]{CoverageControls.labelOfGroup((IndexedResourceBundle)vocabulary, (short)168, (Region)crsControl, true), crsControl, CoverageControls.labelOfGroup((IndexedResourceBundle)vocabulary, (short)216, (Region)valuesControl, false), valuesControl, CoverageControls.labelOfGroup((IndexedResourceBundle)vocabulary, (short)248, this.categoryTable, false), this.categoryTable});
        ValueColorMapper mapper = new ValueColorMapper(resources, vocabulary);
        this.isolines = new IsolineRenderer(this.view);
        this.isolines.setIsolineTables(Collections.singletonList(mapper.getSteps()));
        Region view = mapper.getView();
        VBox.setVgrow((Node)view, (Priority)Priority.ALWAYS);
        VBox isolinesPane = new VBox(new Node[]{view});
        this.controls = new TitledPane[]{new TitledPane(vocabulary.getString((short)67), (Node)displayPane), new TitledPane(vocabulary.getString((short)252), (Node)isolinesPane), new TitledPane(vocabulary.getString((short)237), null)};
        TitledPane delayed = this.controls[2];
        this.view.resourceProperty.addListener((p, o, n) -> this.onPropertySet((GridCoverageResource)n, null));
        this.view.coverageProperty.addListener((p, o, n) -> this.onPropertySet(this.view.getResourceIfAdjusting(), (GridCoverage)n));
        delayed.expandedProperty().addListener((ChangeListener)new PropertyPaneCreator(this.view, delayed));
    }

    private void onPropertySet(GridCoverageResource resource, GridCoverage coverage) {
        ObservableList items = this.categoryTable.getItems();
        if (coverage == null) {
            items.clear();
        } else {
            boolean visibleBand = false;
            items.setAll((Collection)((SampleDimension)coverage.getSampleDimensions().get(0)).getCategories());
        }
        this.owner.notifyDataChanged(resource, coverage);
    }

    @Override
    final void load(ImageRequest request) {
        GridCoverage coverage;
        GridCoverageResource resource;
        if (request != null) {
            resource = request.resource;
            coverage = request.getCoverage().orElse(null);
        } else {
            resource = null;
            coverage = null;
        }
        this.view.setCoverage(resource, coverage);
    }

    @Override
    final Region view() {
        return this.imageAndStatus;
    }

    @Override
    final TitledPane[] controlPanes() {
        return this.controls;
    }
}

