/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.landsat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.landsat.Band;
import org.apache.sis.storage.landsat.BandGroup;
import org.apache.sis.storage.landsat.BandName;
import org.apache.sis.storage.landsat.LandsatStoreProvider;
import org.apache.sis.storage.landsat.MetadataReader;
import org.opengis.metadata.Metadata;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public class LandsatStore
extends DataStore
implements Aggregate {
    private Reader source;
    final Path directory;
    private final URI location;
    private Metadata metadata;
    private GenericName identifier;
    private BandGroup[] components;

    public LandsatStore(LandsatStoreProvider landsatStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super(landsatStoreProvider, storageConnector);
        Path path = storageConnector.getStorageAs(Path.class);
        this.location = storageConnector.getStorageAs(URI.class);
        this.source = storageConnector.getStorageAs(Reader.class);
        storageConnector.closeAllExcept(this.source);
        if (path != null) {
            if (this.source != null) {
                path = path.getParent();
            } else {
                try {
                    Path path2 = LandsatStoreProvider.getMetadataFile(path);
                    if (path2 != null) {
                        Charset charset = (Charset)storageConnector.getOption(OptionKey.ENCODING);
                        this.source = charset != null ? Files.newBufferedReader(path2, charset) : Files.newBufferedReader(path2);
                    }
                }
                catch (IOException iOException) {
                    throw new DataStoreException(iOException);
                }
            }
        }
        this.directory = path;
        if (this.source == null) {
            throw new UnsupportedStorageException(super.getLocale(), "Landsat", storageConnector.getStorage(), (OpenOption[])storageConnector.getOption(OptionKey.OPEN_OPTIONS));
        }
        if (this.getClass() == LandsatStore.class) {
            this.listeners.useWarningEventsOnly();
        }
    }

    @Override
    public final String getDisplayName() {
        return this.directory != null ? this.directory.getFileName().toString() : super.getDisplayName();
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters(this.provider, this.location));
    }

    @Override
    public synchronized Optional<GenericName> getIdentifier() throws DataStoreException {
        if (this.identifier == null) {
            this.identifier = super.getIdentifier().orElse(null);
        }
        return Optional.ofNullable(this.identifier);
    }

    private void loadMetadata() throws DataStoreException {
        Band[] bandArray;
        if (this.source == null) {
            throw new DataStoreClosedException(this.getLocale(), "Landsat", StandardOpenOption.READ);
        }
        String string = this.getDisplayName();
        NameFactory nameFactory = (NameFactory)DefaultFactories.forBuildin(NameFactory.class);
        NameSpace nameSpace = string != null ? nameFactory.createNameSpace((GenericName)nameFactory.createLocalName(null, (CharSequence)string), null) : null;
        int n = 0;
        try (BufferedReader bufferedReader = this.source instanceof BufferedReader ? (BufferedReader)this.source : new LineNumberReader(this.source);){
            this.source = null;
            MetadataReader metadataReader = new MetadataReader(this, this.getDisplayName(), this.listeners);
            metadataReader.read(bufferedReader);
            this.metadata = metadataReader.getMetadata();
            bandArray = new Band[metadataReader.bands.size()];
            for (Map.Entry<BandName, Band> object : metadataReader.bands.entrySet()) {
                Band band = object.getValue();
                if (band.filename == null) continue;
                band.identifier = nameFactory.createLocalName(nameSpace, (CharSequence)object.getKey().name());
                bandArray[n++] = band;
            }
        }
        catch (IOException iOException) {
            throw new DataStoreException(iOException);
        }
        catch (FactoryException factoryException) {
            throw new DataStoreReferencingException(factoryException);
        }
        this.components = BandGroup.group(this.listeners, bandArray, n);
        for (BufferedReader bufferedReader : this.components) {
            ((BandGroup)((Object)bufferedReader)).identifier = nameFactory.createLocalName(nameSpace, (CharSequence)((BandGroup)((Object)bufferedReader)).group.name());
        }
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.loadMetadata();
        }
        return this.metadata;
    }

    public synchronized List<Aggregate> components() throws DataStoreException {
        if (this.components == null) {
            this.loadMetadata();
        }
        return UnmodifiableArrayList.wrap((Object[])this.components);
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        if (storeListener == null || clazz == null || clazz.isAssignableFrom(WarningEvent.class)) {
            super.addListener(clazz, storeListener);
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.metadata = null;
        DataStoreException dataStoreException = null;
        for (Band band : BandGroup.bands(this.components)) {
            try {
                band.closeDataStore();
            }
            catch (DataStoreException dataStoreException2) {
                if (dataStoreException == null) {
                    dataStoreException = dataStoreException2;
                    continue;
                }
                dataStoreException.addSuppressed(dataStoreException2);
            }
        }
        this.components = null;
        if (dataStoreException != null) {
            throw dataStoreException;
        }
    }
}

