/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gazetteer;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Resources
extends IndexedResourceBundle {
    public Resources(URL uRL) {
        super(uRL);
    }

    @Override
    protected KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Resources forLocale(Locale locale) throws MissingResourceException {
        return Resources.getBundle(Resources.class, locale);
    }

    public static Resources forProperties(Map<?, ?> map) throws MissingResourceException {
        return Resources.forLocale(Resources.getLocale(map));
    }

    public static String format(short s) throws MissingResourceException {
        return Resources.forLocale(null).getString(s);
    }

    public static String format(short s, Object object) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object);
    }

    public static String format(short s, Object object, Object object2) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object, object2);
    }

    public static String format(short s, Object object, Object object2, Object object3, Object object4) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object, object2, object3, object4);
    }

    public static InternationalString formatInternational(short s) {
        return new International(s);
    }

    public static InternationalString formatInternational(short s, Object object) {
        return new International(s, object);
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short ChildAlreadyExists_1 = 8;
        public static final short GridCoordinates = 12;
        public static final short GridZoneDesignator = 13;
        public static final short IllegalGridCoordinate_1 = 1;
        public static final short IllegalLatitudeBand_1 = 2;
        public static final short IllegalSquareIdentification_1 = 3;
        public static final short IllegalUPSZone_1 = 4;
        public static final short IllegalUTMZone_1 = 5;
        public static final short InconsistentWithGZD_2 = 6;
        public static final short LocationTypeCycle_1 = 11;
        public static final short LocationTypeNotFound_1 = 10;
        public static final short MGRS = 15;
        public static final short OddGridCoordinateLength_1 = 7;
        public static final short ParentAlreadyExists_1 = 9;
        public static final short SquareIdentifier100 = 14;

        private Keys() {
        }
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = -955665828906534712L;

        International(short s) {
            super(s);
        }

        International(short s, Object object) {
            super(s, object);
        }

        @Override
        protected KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        @Override
        protected IndexedResourceBundle getBundle(Locale locale) {
            return Resources.forLocale(locale);
        }
    }
}

