/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.internal.storage.gpx.StoreProvider;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;

enum OutputFormat {
    TEXT(null),
    WKT(null),
    XML(null),
    GPX(StoreProvider.class);

    private final Class<? extends DataStoreProvider> providerClass;

    private OutputFormat(Class<? extends DataStoreProvider> clazz) {
        this.providerClass = clazz;
    }

    final DataStoreProvider provider() throws InvalidOptionException {
        if (this.providerClass != null) {
            for (DataStoreProvider dataStoreProvider : DataStores.providers()) {
                if (!this.providerClass.isInstance(dataStoreProvider)) continue;
                return dataStoreProvider;
            }
        }
        return null;
    }
}

