/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.geotiff.Compression;
import org.apache.sis.internal.geotiff.Resources;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.geotiff.ImageFileDirectory;
import org.apache.sis.storage.geotiff.XMLMetadata;
import org.apache.sis.util.CharSequences;

final class ImageMetadataBuilder
extends MetadataBuilder {
    private double resolution = Double.NaN;
    private Unit<Length> resolutionUnit = Units.INCH;
    private short cellWidth = (short)-1;
    private short cellHeight = (short)-1;
    private XMLMetadata complement;

    ImageMetadataBuilder() {
    }

    Integer setThreshholding(int n) {
        switch (n) {
            default: {
                return n;
            }
            case 2: {
                if ((this.cellWidth & this.cellHeight) >= 0) break;
            }
            case 1: 
            case 3: {
                this.cellWidth = this.cellHeight = (short)(-n);
            }
        }
        return null;
    }

    void setCellSize(short s, boolean bl) {
        if (bl) {
            this.cellWidth = s;
        } else {
            this.cellHeight = s;
        }
    }

    void setResolution(double d) {
        if (Double.isNaN(this.resolution) || d > this.resolution) {
            this.resolution = d;
        }
    }

    Integer setResolutionUnit(int n) {
        switch (n) {
            case 1: {
                this.resolutionUnit = null;
                break;
            }
            case 2: {
                this.resolutionUnit = Units.INCH;
                break;
            }
            case 3: {
                this.resolutionUnit = Units.CENTIMETRE;
                break;
            }
            default: {
                return n;
            }
        }
        return null;
    }

    void addXML(XMLMetadata xMLMetadata) {
        if (this.complement == null) {
            this.complement = xMLMetadata;
        } else {
            xMLMetadata.appendTo(this.complement);
        }
    }

    void finish(ImageFileDirectory imageFileDirectory, StoreListeners storeListeners) throws DataStoreException {
        Compression compression;
        imageFileDirectory.getIdentifier().ifPresent(genericName -> this.addTitle(genericName.toString()));
        GeoTiffStore geoTiffStore = imageFileDirectory.reader.store;
        if (geoTiffStore.hidden) {
            geoTiffStore.setFormatInfo(this);
        }
        if ((compression = imageFileDirectory.getCompression()) != null) {
            this.addCompression(CharSequences.upperCaseToSentence((CharSequence)compression.name()));
        }
        if (!Double.isNaN(this.resolution) && this.resolutionUnit != null) {
            this.addResolution(this.resolutionUnit.getConverterTo(Units.METRE).convert(this.resolution));
        }
        int n = this.cellWidth;
        int n2 = this.cellHeight;
        switch (Math.min(n, n2)) {
            case -1: {
                break;
            }
            case -3: {
                this.addProcessDescription((CharSequence)Resources.formatInternational((short)15));
                break;
            }
            default: {
                this.addProcessDescription((CharSequence)Resources.formatInternational((short)5, n >= 0 ? n : 63, n2 >= 0 ? n2 : 63));
            }
        }
        while (this.complement != null) {
            try {
                this.complement = this.complement.appendTo(this);
            }
            catch (Exception exception) {
                storeListeners.warning(imageFileDirectory.reader.errors().getString((short)15, (Object)this.complement.tag()), exception);
            }
        }
    }
}

