/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.util.Map;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.geotiff.CRSBuilder;
import org.apache.sis.storage.geotiff.GeoKeys;
import org.apache.sis.util.CharSequences;

class GeoKeysLoader {
    private static final int ENTRY_LENGTH = 4;
    static final char SEPARATOR = '|';
    public Vector keyDirectory;
    public Vector numericParameters;
    public String asciiParameters;
    short majorRevision;
    short minorRevision;
    CRSBuilder logger;

    GeoKeysLoader() {
    }

    final void setAsciiParameters(String[] stringArray) {
        switch (stringArray.length) {
            case 0: {
                break;
            }
            case 1: {
                this.asciiParameters = stringArray[0];
                break;
            }
            default: {
                this.asciiParameters = String.join((CharSequence)"\u0000", stringArray).concat("\u0000");
            }
        }
    }

    final boolean load(Map<Short, Object> map) {
        int n;
        int n2;
        int n3 = this.keyDirectory.size();
        if (n3 >= 4) {
            n2 = this.keyDirectory.intValue(0);
            if (n2 != 1) {
                this.warning((short)20, n2);
                return false;
            }
            this.majorRevision = this.keyDirectory.shortValue(1);
            this.minorRevision = this.keyDirectory.shortValue(2);
            n = this.keyDirectory.intValue(3);
        } else {
            n = 0;
        }
        n2 = (n + 1) * 4;
        if (n3 < n2) {
            this.warning((short)10, "GeoKeyDirectory", n2, n3);
            return false;
        }
        int n4 = this.numericParameters != null ? this.numericParameters.size() : 0;
        int n5 = this.asciiParameters != null ? this.asciiParameters.length() : 0;
        block18: for (int i = 1; i <= n; ++i) {
            Object object;
            int n6 = i * 4;
            short s = this.keyDirectory.shortValue(n6);
            int n7 = this.keyDirectory.intValue(n6 + 1);
            int n8 = this.keyDirectory.intValue(n6 + 2);
            int n9 = this.keyDirectory.intValue(n6 + 3);
            if (n9 < 0 || n8 < 0) {
                this.missingValue(s);
                continue;
            }
            switch (n7) {
                case 0: {
                    switch (n8) {
                        case 0: {
                            continue block18;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            this.warning((short)16, GeoKeys.name(s), n8);
                        }
                    }
                    object = n9;
                    break;
                }
                case 34735: {
                    if (n9 + n8 > this.keyDirectory.size()) {
                        this.missingValue(s);
                        continue block18;
                    }
                    switch (n8) {
                        case 0: {
                            continue block18;
                        }
                        case 1: {
                            object = this.keyDirectory.get(n9);
                            break;
                        }
                        default: {
                            int[] nArray = new int[n8];
                            for (int j = 0; j < n8; ++j) {
                                nArray[j] = this.keyDirectory.intValue(n9 + j);
                            }
                            object = nArray;
                            break;
                        }
                    }
                    break;
                }
                case 34736: {
                    if (n9 + n8 > n4) {
                        this.missingValue(s);
                        continue block18;
                    }
                    switch (n8) {
                        case 0: {
                            continue block18;
                        }
                        case 1: {
                            object = this.numericParameters.get(n9);
                            break;
                        }
                        default: {
                            double[] dArray = new double[n8];
                            for (int j = 0; j < n8; ++j) {
                                dArray[j] = this.numericParameters.doubleValue(n9 + j);
                            }
                            object = dArray;
                            break;
                        }
                    }
                    break;
                }
                case 34737: {
                    int n10 = n9 + n8;
                    if (n10 > n5) {
                        this.missingValue(s);
                        continue block18;
                    }
                    for (n10 = CharSequences.skipTrailingWhitespaces((CharSequence)this.asciiParameters, (int)n9, (int)n10); n10 > n9 && this.asciiParameters.charAt(n10 - 1) == '|'; --n10) {
                    }
                    String string = this.asciiParameters.substring(n9, n10).trim();
                    if (string.isEmpty()) continue block18;
                    object = string;
                    break;
                }
                default: {
                    this.warning((short)21, GeoKeys.name(s));
                    continue block18;
                }
            }
            map.put(s, object);
        }
        return true;
    }

    private void warning(short s, Object ... objectArray) {
        if (this.logger != null) {
            this.logger.warning(s, objectArray);
        }
    }

    private void missingValue(short s) {
        if (this.logger != null) {
            this.logger.missingValue(s);
        }
    }
}

