/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.wkt.StoreFormat;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultAddress;
import org.apache.sis.metadata.iso.citation.DefaultContact;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.referencing.CRS;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

final class MetadataReader
extends MetadataBuilder {
    private static final boolean EXPERIMENTAL = true;
    private static final String[] SERVICES = new String[]{"wms_service", "wcs_service"};
    private static final char SEPARATOR = ',';
    private static final char QUOTE = '\"';
    private final Decoder decoder;
    private final String[] searchPath;
    private transient ResponsibleParty pointOfContact;
    private VerticalCRS verticalCRS;
    private boolean hasGridCoverages;

    MetadataReader(Decoder decoder) {
        this.decoder = decoder;
        decoder.setSearchPath(decoder.convention().getSearchPath());
        this.searchPath = decoder.getSearchPath();
    }

    private void warning(Exception exception) {
        this.decoder.listeners.warning(exception);
    }

    private void warning(short s, Object object, Object object2, Exception exception) {
        StoreListeners storeListeners = this.decoder.listeners;
        storeListeners.warning(Errors.getResources(storeListeners.getLocale()).getString(s, object, object2), exception);
    }

    static List<String> split(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = CharSequences.skipTrailingWhitespaces(string, 0, string.length());
        while ((n = CharSequences.skipLeadingWhitespaces(string, n, n2)) < n2) {
            int n3;
            int n4;
            block6: {
                if (string.charAt(n) == '\"') {
                    n4 = ++n;
                    while ((n3 = string.indexOf(34, n4)) >= 0) {
                        n4 = CharSequences.skipLeadingWhitespaces(string, n3 + 1, n2);
                        if (n4 < n2 && string.charAt(n4) != ',') continue;
                        break block6;
                    }
                    break;
                }
                n4 = string.indexOf(44, n);
                if (n4 < 0) break;
                n3 = CharSequences.skipTrailingWhitespaces(string, n, n4);
            }
            if (n != n3) {
                arrayList.add(string.substring(n, n3));
            }
            n = n4 + 1;
        }
        if (n < n2) {
            arrayList.add(string.substring(n, n2));
        }
        return arrayList;
    }

    private String stringValue(String string) {
        return Strings.trimOrNull(this.decoder.stringValue(string));
    }

    private double numericValue(String string) {
        Number number = this.decoder.numericValue(string);
        return number != null ? number.doubleValue() : Double.NaN;
    }

    private <T extends Enum<T>> T forEnumName(Class<T> clazz, String string) {
        Enum enum_ = Types.forEnumName(clazz, (String)string);
        if (enum_ == null && string != null) {
            this.warning((short)146, clazz, string, null);
        }
        return (T)enum_;
    }

    private <T extends CodeList<T>> T forCodeName(Class<T> clazz, String string) {
        CodeList codeList = Types.forCodeName(clazz, (String)string, (boolean)false);
        if (codeList == null && string != null) {
            this.warning((short)146, clazz, string, null);
        }
        return (T)codeList;
    }

    private static <T> Set<T> addIfNonNull(Set<T> set, T t) {
        if (t != null) {
            if (set == null) {
                set = new LinkedHashSet<T>(4);
            }
            set.add(t);
        }
        return set;
    }

    private static boolean canShare(CharSequence charSequence, String string) {
        return string == null || charSequence != null && charSequence.toString().equals(string);
    }

    private static boolean canShare(Collection<String> collection, String string) {
        return string == null || collection.contains(string);
    }

    private static boolean canShare(OnlineResource onlineResource, String string) {
        return string == null || onlineResource != null && MetadataReader.canShare(onlineResource.getLinkage().toString(), string);
    }

    private static boolean canShare(Address address, String string) {
        return string == null || address != null && MetadataReader.canShare(address.getElectronicMailAddresses(), string);
    }

    private URI createURI(String string) {
        if (string != null) {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.warning(uRISyntaxException);
            }
        }
        return null;
    }

    private OnlineResource createOnlineResource(String string) {
        URI uRI = this.createURI(string);
        if (uRI == null) {
            return null;
        }
        DefaultOnlineResource defaultOnlineResource = new DefaultOnlineResource(uRI);
        String string2 = uRI.getScheme();
        defaultOnlineResource.setProtocol(string2);
        if ("http".equalsIgnoreCase(string2) || "https".equalsIgnoreCase(string2)) {
            defaultOnlineResource.setApplicationProfile("web browser");
        }
        defaultOnlineResource.setFunction(OnLineFunction.INFORMATION);
        return defaultOnlineResource;
    }

    private static Address createAddress(String string) {
        if (string != null) {
            DefaultAddress defaultAddress = new DefaultAddress();
            defaultAddress.setElectronicMailAddresses(Collections.singleton(string));
            return defaultAddress;
        }
        return null;
    }

    private static Contact createContact(Address address, OnlineResource onlineResource) {
        if (address != null || onlineResource != null) {
            DefaultContact defaultContact = new DefaultContact();
            if (address != null) {
                defaultContact.setAddresses(Collections.singleton(address));
            }
            if (onlineResource != null) {
                defaultContact.setOnlineResources(Collections.singleton(onlineResource));
            }
            return defaultContact;
        }
        return null;
    }

    private ResponsibleParty createResponsibleParty(AttributeNames.Responsible responsible, boolean bl) {
        Role role;
        String string = this.stringValue(responsible.NAME);
        String string2 = this.stringValue(responsible.INSTITUTION);
        String string3 = this.stringValue(responsible.EMAIL);
        String string4 = this.stringValue(responsible.URL);
        if (string2 == null && bl) {
            string2 = this.stringValue("institution");
        }
        if (string == null && string2 == null && string3 == null && string4 == null) {
            return null;
        }
        if (string2 == null) {
            if (this.isOrganisation(responsible)) {
                string2 = string;
                string = null;
            }
        } else if (string2.equalsIgnoreCase(string)) {
            string = null;
        }
        if ((role = this.forCodeName(Role.class, this.stringValue(responsible.ROLE))) == null) {
            role = bl ? Role.POINT_OF_CONTACT : responsible.DEFAULT_ROLE;
        }
        ResponsibleParty responsibleParty = this.pointOfContact;
        Contact contact = null;
        Address address = null;
        OnlineResource onlineResource = null;
        if (responsibleParty != null) {
            contact = responsibleParty.getContactInfo();
            if (contact != null) {
                address = contact.getAddress();
                onlineResource = contact.getOnlineResource();
            }
            if (!MetadataReader.canShare(onlineResource, string4)) {
                onlineResource = null;
                contact = null;
                responsibleParty = null;
            }
            if (!MetadataReader.canShare(address, string3)) {
                address = null;
                contact = null;
                responsibleParty = null;
            }
            if (!(responsibleParty == null || MetadataReader.canShare((CharSequence)responsibleParty.getOrganisationName(), string2) && MetadataReader.canShare(responsibleParty.getIndividualName(), string))) {
                responsibleParty = null;
            }
        }
        if (responsibleParty == null) {
            if (contact == null) {
                if (address == null) {
                    address = MetadataReader.createAddress(string3);
                }
                if (onlineResource == null) {
                    onlineResource = this.createOnlineResource(string4);
                }
                contact = MetadataReader.createContact(address, onlineResource);
            }
            if (string != null || string2 != null || contact != null) {
                DefaultIndividual defaultIndividual = null;
                if (string != null) {
                    defaultIndividual = new DefaultIndividual((CharSequence)string, null, null);
                }
                if (string2 != null) {
                    defaultIndividual = new DefaultOrganisation((CharSequence)string2, null, defaultIndividual, null);
                }
                if (defaultIndividual == null) {
                    Object object = defaultIndividual = this.isOrganisation(responsible) ? new DefaultOrganisation() : new DefaultIndividual();
                }
                if (contact != null) {
                    defaultIndividual.setContactInfo(Collections.singleton(contact));
                }
                responsibleParty = new DefaultResponsibleParty(role);
                ((DefaultResponsibleParty)responsibleParty).setParties(Collections.singleton(defaultIndividual));
            }
        }
        return responsibleParty;
    }

    private boolean isOrganisation(AttributeNames.Responsible responsible) {
        String string = this.stringValue(responsible.TYPE);
        return "institution".equalsIgnoreCase(string) || "group".equalsIgnoreCase(string);
    }

    /*
     * WARNING - void declaration
     */
    private Set<InternationalString> addCitation() {
        void var2_4;
        String string = this.stringValue("title");
        if (string == null && (string = this.stringValue("full_name")) == null && (string = this.stringValue("name")) == null) {
            string = this.decoder.getTitle();
        }
        this.addTitle(string);
        this.addEdition(this.stringValue("product_version"));
        this.addOtherCitationDetails(this.stringValue("references"));
        this.addCitationDate(this.decoder.dateValue("metadata_creation"), DateType.CREATION, MetadataBuilder.Scope.ALL);
        this.addCitationDate(this.decoder.dateValue("date_metadata_modified"), DateType.REVISION, MetadataBuilder.Scope.ALL);
        this.addCitationDate(this.decoder.dateValue("date_created"), DateType.CREATION, MetadataBuilder.Scope.RESOURCE);
        this.addCitationDate(this.decoder.dateValue("date_modified"), DateType.REVISION, MetadataBuilder.Scope.RESOURCE);
        this.addCitationDate(this.decoder.dateValue("date_issued"), DateType.PUBLICATION, MetadataBuilder.Scope.RESOURCE);
        for (String string2 : this.searchPath) {
            this.decoder.setSearchPath(string2);
            ResponsibleParty responsibleParty = this.createResponsibleParty(AttributeNames.CREATOR, true);
            if (responsibleParty == this.pointOfContact) continue;
            this.addPointOfContact(responsibleParty, MetadataBuilder.Scope.RESOURCE);
            if (this.pointOfContact != null) continue;
            this.pointOfContact = responsibleParty;
        }
        this.addCitedResponsibleParty(this.pointOfContact, Role.ORIGINATOR);
        Object var2_3 = null;
        for (String string3 : this.searchPath) {
            ResponsibleParty responsibleParty;
            this.decoder.setSearchPath(string3);
            ResponsibleParty responsibleParty2 = this.createResponsibleParty(AttributeNames.CONTRIBUTOR, false);
            if (responsibleParty2 != this.pointOfContact) {
                this.addCitedResponsibleParty(responsibleParty2, null);
            }
            if (!((responsibleParty = this.createResponsibleParty(AttributeNames.PUBLISHER, false)) instanceof DefaultResponsibility)) continue;
            this.addDistributor(responsibleParty);
            for (AbstractParty abstractParty : ((DefaultResponsibility)responsibleParty).getParties()) {
                Set<InternationalString> set = MetadataReader.addIfNonNull(var2_4, abstractParty.getName());
            }
        }
        this.decoder.setSearchPath(this.searchPath);
        return var2_4;
    }

    private void addIdentificationInfo(Set<InternationalString> set) throws IOException, DataStoreException {
        String[] stringArray;
        String string;
        boolean bl = false;
        Set<String> set2 = null;
        Set<String> set3 = null;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String metadataStoreException : this.searchPath) {
            this.decoder.setSearchPath(metadataStoreException);
            linkedHashSet.addAll(MetadataReader.split(this.stringValue(AttributeNames.KEYWORDS.TEXT)));
            set3 = MetadataReader.addIfNonNull(set3, this.stringValue(AttributeNames.STANDARD_NAME.TEXT));
            set2 = MetadataReader.addIfNonNull(set2, this.stringValue("project"));
            for (String string2 : MetadataReader.split(this.stringValue("acces_constraint"))) {
                this.addAccessConstraint(this.forCodeName(Restriction.class, string2));
            }
            this.addTopicCategory(this.forCodeName(TopicCategory.class, this.stringValue("topic_category")));
            this.addSpatialRepresentation(this.forCodeName(SpatialRepresentationType.class, this.stringValue("cdm_data_type")));
            if (bl) continue;
            bl = this.addExtent();
        }
        this.decoder.setSearchPath(this.searchPath);
        this.addAbstract(this.stringValue("summary"));
        this.addPurpose(this.stringValue("purpose"));
        this.addSupplementalInformation(this.stringValue("comment"));
        this.addCredits(this.stringValue("acknowledgement"));
        this.addCredits(this.stringValue("acknowledgment"));
        this.addUseLimitation(this.stringValue("license"));
        this.addKeywords(set3, KeywordType.THEME, this.stringValue(AttributeNames.STANDARD_NAME.VOCABULARY));
        this.addKeywords(linkedHashSet, KeywordType.THEME, this.stringValue(AttributeNames.KEYWORDS.VOCABULARY));
        this.addKeywords(set2, KeywordType.valueOf((String)"PROJECT"), null);
        this.addKeywords(set, KeywordType.valueOf((String)"DATA_CENTRE"), null);
        String string3 = this.stringValue("geospatial_bounds");
        if (string3 != null) {
            this.addBoundingPolygon(new StoreFormat(null, null, this.decoder.geomlib, this.decoder.listeners).parseGeometry(string3, this.stringValue("geospatial_bounds_crs"), this.stringValue("geospatial_bounds_vertical_crs")));
        }
        if ("NetCDF".equalsIgnoreCase(string = (stringArray = this.decoder.getFormatDescription())[0])) {
            try {
                this.setPredefinedFormat("NetCDF");
                string = null;
            }
            catch (MetadataStoreException metadataStoreException) {
                this.warning((Exception)((Object)metadataStoreException));
            }
        }
        if (stringArray.length >= 2) {
            this.addFormatName(stringArray[1]);
            if (stringArray.length >= 3) {
                this.setFormatEdition(stringArray[2]);
            }
        }
        this.addFormatName(string);
    }

    private void addSpatialRepresentationInfo(Grid grid) throws IOException, DataStoreException {
        Axis[] axisArray = grid.getAxes(this.decoder);
        block10: for (int i = 0; i < axisArray.length; ++i) {
            AttributeNames.Dimension dimension;
            Axis axis = axisArray[i];
            int n = i;
            axis.getMainSize().ifPresent(l -> this.setAxisSize(n, l));
            switch (axis.abbreviation) {
                case '\u03b8': 
                case '\u03bb': {
                    dimension = AttributeNames.LONGITUDE;
                    break;
                }
                case '\u03a9': 
                case '\u03c6': {
                    dimension = AttributeNames.LATITUDE;
                    break;
                }
                case 'D': 
                case 'H': 
                case 'h': {
                    dimension = AttributeNames.VERTICAL;
                    break;
                }
                case 'T': 
                case 't': {
                    dimension = AttributeNames.TIME;
                    break;
                }
                default: {
                    continue block10;
                }
            }
            DimensionNameType dimensionNameType = dimension.DEFAULT_NAME_TYPE;
            this.setAxisName(i, dimensionNameType);
            String string = this.stringValue(dimension.RESOLUTION);
            if (string == null) continue;
            try {
                double d;
                int n2 = string.indexOf(32);
                Unit<?> unit = null;
                if (n2 < 0) {
                    d = this.numericValue(dimension.RESOLUTION);
                } else {
                    d = Double.parseDouble(string.substring(0, n2).trim());
                    String string2 = string.substring(n2 + 1).trim();
                    if (!string2.isEmpty()) {
                        try {
                            unit = Units.valueOf(string2);
                        }
                        catch (ParserException parserException) {
                            this.warning((short)3, dimensionNameType, unit, (Exception)((Object)parserException));
                        }
                    }
                }
                this.setAxisResolution(i, d, unit);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.warning(numberFormatException);
            }
        }
        this.setCellGeometry(CellGeometry.AREA);
    }

    private boolean addExtent() {
        this.addExtent(this.stringValue("geographic_identifier"));
        double[] dArray = new double[4];
        boolean bl = this.fillExtent(AttributeNames.LONGITUDE, Units.DEGREE, AxisDirection.EAST, dArray, 0);
        if (bl |= this.fillExtent(AttributeNames.LATITUDE, Units.DEGREE, AxisDirection.NORTH, dArray, 2)) {
            this.addExtent(dArray, 0);
            bl = true;
        }
        if (this.fillExtent(AttributeNames.VERTICAL, Units.METRE, null, dArray, 0)) {
            this.addVerticalExtent(dArray[0], dArray[1], this.verticalCRS);
            bl = true;
        }
        Date date = this.decoder.dateValue(AttributeNames.TIME.MINIMUM);
        Date date2 = this.decoder.dateValue(AttributeNames.TIME.MAXIMUM);
        if (date == null && date2 == null) {
            String string;
            Number number = this.decoder.numericValue(AttributeNames.TIME.MINIMUM);
            Number number2 = this.decoder.numericValue(AttributeNames.TIME.MAXIMUM);
            if ((number != null || number2 != null) && (string = this.stringValue(AttributeNames.TIME.UNITS)) != null) {
                Date[] dateArray = this.decoder.numberToDate(string, number, number2);
                date = dateArray[0];
                date2 = dateArray[1];
            }
        }
        if (date != null || date2 != null) {
            this.addTemporalExtent(date, date2);
            bl = true;
        }
        return bl;
    }

    private boolean fillExtent(AttributeNames.Dimension dimension, Unit<?> unit, AxisDirection axisDirection, double[] dArray, int n) {
        String string;
        boolean bl;
        double d = this.numericValue(dimension.MINIMUM);
        double d2 = this.numericValue(dimension.MAXIMUM);
        boolean bl2 = bl = !Double.isNaN(d) || !Double.isNaN(d2);
        if (bl && (string = this.stringValue(dimension.UNITS)) != null) {
            try {
                UnitConverter unitConverter = Units.valueOf(string).getConverterToAny(unit);
                d = unitConverter.convert(d);
                d2 = unitConverter.convert(d2);
            }
            catch (IncommensurableException | ParserException throwable) {
                this.warning((Exception)throwable);
            }
            boolean bl3 = false;
            if (axisDirection != null) {
                bl3 = AxisDirections.opposite((AxisDirection)axisDirection).equals((Object)Axis.direction(string));
            } else if (dimension.POSITIVE != null) {
                bl3 = "down".equals(this.stringValue(dimension.POSITIVE));
            }
            if (bl3) {
                double d3 = d;
                d = -d2;
                d2 = -d3;
            }
        }
        dArray[n] = d;
        dArray[n + 1] = d2;
        return bl;
    }

    private void addAcquisitionInfo() {
        AttributeNames.Term[] termArray = new AttributeNames.Term[]{AttributeNames.PROGRAM, AttributeNames.PLATFORM, AttributeNames.INSTRUMENT};
        for (int i = 0; i < termArray.length; ++i) {
            AttributeNames.Term term = termArray[i];
            String string = this.stringValue(term.VOCABULARY);
            for (String string2 : MetadataReader.split(this.stringValue(term.TEXT))) {
                switch (i) {
                    case 0: {
                        this.addAcquisitionOperation(string, string2);
                        break;
                    }
                    case 1: {
                        this.addPlatform(string, string2);
                        break;
                    }
                    case 2: {
                        this.addInstrument(string, string2);
                    }
                }
            }
        }
    }

    private void addContentInfo() {
        CharSequence[] charSequenceArray;
        LinkedHashSet<Dimension> linkedHashSet = new LinkedHashSet<Dimension>();
        LinkedHashMap linkedHashMap = new LinkedHashMap(4);
        for (Variable variable : this.decoder.getVariables()) {
            if (VariableRole.isCoverage(variable)) {
                Object object = variable.getGridDimensions();
                charSequenceArray = new String[object.size()];
                for (int i = 0; i < charSequenceArray.length; ++i) {
                    charSequenceArray[i] = object.get(i).getName();
                }
                CollectionsExt.addToMultiValuesMap(linkedHashMap, Arrays.asList(charSequenceArray), variable);
                this.hasGridCoverages = true;
                continue;
            }
            if (variable.getRole() != VariableRole.FEATURE_PROPERTY) continue;
            linkedHashSet.add(variable.getGridDimensions().get(0));
        }
        if (!linkedHashSet.isEmpty()) {
            this.addSpatialRepresentation(SpatialRepresentationType.TEXT_TABLE);
        }
        if (!linkedHashMap.isEmpty()) {
            this.addSpatialRepresentation(SpatialRepresentationType.GRID);
        }
        for (Dimension dimension : linkedHashSet) {
            String string = dimension.getName();
            if (string == null) continue;
            this.addFeatureType((GenericName)this.decoder.nameFactory.createLocalName(this.decoder.namespace, (CharSequence)string), dimension.length());
        }
        String string = this.stringValue("processing_level");
        for (List list : linkedHashMap.values()) {
            this.newCoverage(false);
            this.setProcessingLevelCode(null, string);
            for (Object object : list) {
                this.addSampleDimension((Variable)object);
                charSequenceArray = ((Node)object).getAttributeAsStrings("flag_names", ' ');
                CharSequence[] charSequenceArray2 = ((Node)object).getAttributeAsStrings("flag_meanings", ' ');
                Vector vector = ((Node)object).getAttributeAsVector("flag_masks");
                Vector vector2 = ((Node)object).getAttributeAsVector("flag_values");
                int n = charSequenceArray != null ? charSequenceArray.length : 0;
                int n2 = charSequenceArray2 != null ? charSequenceArray2.length : 0;
                int n3 = vector != null ? vector.size() : 0;
                int n4 = vector2 != null ? vector2.size() : 0;
                int n5 = Math.max(n, Math.max(n2, Math.max(n3, n4)));
                for (int i = 0; i < n5; ++i) {
                    this.addSampleValueDescription((Variable)object, i < n ? charSequenceArray[i] : null, i < n2 ? charSequenceArray2[i] : null, i < n3 ? (Number)vector.get(i) : (Number)null, i < n4 ? (Number)vector2.get(i) : (Number)null);
                }
            }
        }
    }

    private void addSampleDimension(Variable variable) {
        CharSequence charSequence;
        Object object;
        this.newSampleDimension();
        String string = Strings.trimOrNull(variable.getName());
        if (string != null) {
            object = this.decoder.nameFactory;
            charSequence = new StringBuilder(20);
            variable.writeDataTypeName((StringBuilder)charSequence);
            this.setBandIdentifier((GenericName)object.createMemberName(null, (CharSequence)string, object.createTypeName(null, (CharSequence)((StringBuilder)charSequence).toString())));
        }
        if (!((String)(object = Strings.trimOrNull(variable.getStandardName()))).equals(string)) {
            this.addBandName(variable.getAttributeAsString("standard_name_vocabulary"), (String)object);
        }
        if ((charSequence = Strings.trimOrNull(variable.getDescription())) != null && !((String)charSequence).equals(string) && !((String)charSequence).equals(object)) {
            this.addBandDescription(charSequence);
        }
        this.setSampleUnits(variable.getUnit());
        this.setTransferFunction(variable.getAttributeAsNumber("scale_factor"), variable.getAttributeAsNumber("add_offset"));
        this.addContentType(this.forCodeName(CoverageContentType.class, this.stringValue("coverage_content_type")));
    }

    private void addSampleValueDescription(Variable variable, CharSequence charSequence, CharSequence charSequence2, Number number, Number number2) {
        this.addSampleValueDescription(charSequence, charSequence2);
    }

    private void addFileIdentifier() {
        String string;
        String string2 = this.stringValue(AttributeNames.IDENTIFIER.TEXT);
        if (string2 != null) {
            string = this.stringValue(AttributeNames.IDENTIFIER.VOCABULARY);
        } else {
            string2 = this.decoder.getId();
            if (string2 == null && (string2 = IOUtilities.filenameWithoutExtension(this.decoder.getFilename())) == null) {
                return;
            }
            string = null;
        }
        if (string == null) {
            this.addTitleOrIdentifier(string2, MetadataBuilder.Scope.RESOURCE);
        } else {
            this.addIdentifier(string, string2, MetadataBuilder.Scope.RESOURCE);
        }
    }

    public Metadata read() throws IOException, DataStoreException {
        for (CoordinateReferenceSystem coordinateReferenceSystem : this.decoder.getReferenceSystemInfo()) {
            this.addReferenceSystem((ReferenceSystem)coordinateReferenceSystem);
            if (this.verticalCRS != null) continue;
            this.verticalCRS = CRS.getVerticalComponent((CoordinateReferenceSystem)coordinateReferenceSystem, (boolean)false);
        }
        this.addResourceScope(ScopeCode.DATASET, null);
        this.addIdentificationInfo(this.addCitation());
        for (String object : SERVICES) {
            String string = this.stringValue(object);
            if (string == null) continue;
            this.addResourceScope(ScopeCode.SERVICE, string);
        }
        this.addAcquisitionInfo();
        this.addContentInfo();
        for (Grid grid : this.decoder.getGridCandidates()) {
            if (grid.getSourceDimensions() < 2 || grid.getTargetDimensions() < 2) continue;
            this.addSpatialRepresentationInfo(grid);
        }
        this.setISOStandards(this.hasGridCoverages);
        this.addFileIdentifier();
        for (String string : this.searchPath) {
            this.decoder.setSearchPath(string);
            this.addLineage(this.stringValue("history"));
            this.addSource(this.stringValue("source"), null, null);
        }
        this.decoder.setSearchPath(this.searchPath);
        DefaultMetadata defaultMetadata = this.build();
        this.addCompleteMetadata(this.createURI(this.stringValue("metadata_link")));
        defaultMetadata.transitionTo(ModifiableMetadata.State.FINAL);
        return defaultMetadata;
    }
}

