/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.CanNotProbeException;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalOpenParameterException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.sql.ResourceDefinition;
import org.apache.sis.storage.sql.SQLStore;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.UnconvertibleObjectException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

@StoreMetadata(formatName="SQL", capabilities={Capability.READ}, resourceTypes={Aggregate.class, FeatureSet.class})
public class SQLStoreProvider
extends DataStoreProvider {
    static final String NAME = "SQL";
    static final String TABLES = "tables";
    static final String QUERIES = "queries";
    public static final ParameterDescriptor<DataSource> SOURCE_PARAM;
    public static final ParameterDescriptor<GenericName[]> TABLES_PARAM;
    public static final ParameterDescriptor<Map> QUERIES_PARAM;
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR;

    public static GenericName createTableName(String string, String string2, String string3) {
        return ResourceDefinition.table(string, string2, string3).getName();
    }

    public String getShortName() {
        return NAME;
    }

    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        block10: {
            DataSource dataSource = (DataSource)storageConnector.getStorageAs(DataSource.class);
            if (dataSource != null) {
                ProbeResult probeResult;
                block9: {
                    Connection connection = dataSource.getConnection();
                    try {
                        probeResult = ProbeResult.SUPPORTED;
                        if (connection == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException sQLException) {
                            String string = sQLException.getSQLState();
                            if ("08001".equals(string) && "3D000".equals(string)) break block10;
                            throw new CanNotProbeException((DataStoreProvider)this, storageConnector, (Throwable)sQLException);
                        }
                    }
                    connection.close();
                }
                return probeResult;
            }
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        return new SQLStore(this, storageConnector, ResourceDefinition.table("%"));
    }

    public DataStore open(ParameterValueGroup parameterValueGroup) throws DataStoreException {
        ArgumentChecks.ensureNonNull("parameters", parameterValueGroup);
        try {
            Parameters parameters = Parameters.castOrWrap((ParameterValueGroup)parameterValueGroup);
            StorageConnector storageConnector = new StorageConnector(parameters.getValue(SOURCE_PARAM));
            GenericName[] genericNameArray = (GenericName[])parameters.getValue(TABLES_PARAM);
            Map map = (Map)parameters.getValue(QUERIES_PARAM);
            return new SQLStore(this, storageConnector, ResourceDefinition.wrap(genericNameArray, map));
        }
        catch (UnconvertibleObjectException | ParameterNotFoundException throwable) {
            throw new IllegalOpenParameterException(throwable.getMessage(), throwable);
        }
    }

    static {
        ParameterBuilder parameterBuilder = new ParameterBuilder();
        SOURCE_PARAM = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)"location")).setRequired(true).setDescription((CharSequence)Resources.formatInternational((short)1))).create(DataSource.class, null);
        TABLES_PARAM = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)TABLES)).setRequired(false).setDescription((CharSequence)Resources.formatInternational((short)2))).create(GenericName[].class, null);
        QUERIES_PARAM = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)QUERIES)).setDescription((CharSequence)Resources.formatInternational((short)14))).create(Map.class, null);
        OPEN_DESCRIPTOR = ((ParameterBuilder)parameterBuilder.addName((CharSequence)NAME)).createGroup(new GeneralParameterDescriptor[]{SOURCE_PARAM, TABLES_PARAM, QUERIES_PARAM});
    }
}

