/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.sis.internal.sql.feature.Database;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.sql.feature.SchemaModifier;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.sql.ResourceDefinition;
import org.apache.sis.storage.sql.SQLStoreProvider;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public class SQLStore
extends DataStore
implements Aggregate {
    private static final String[] NAME_GETTERS = new String[]{"getDescription", "getDataSourceName", "getDatabaseName", "getUrl", "getURL"};
    private final DataSource source;
    private final GeometryLibrary geomLibrary;
    private Database<?> model;
    private final GenericName[] tableNames;
    private final ResourceDefinition[] queries;
    private Metadata metadata;
    private final SchemaModifier customizer;

    public SQLStore(SQLStoreProvider sQLStoreProvider, StorageConnector storageConnector, ResourceDefinition ... resourceDefinitionArray) throws DataStoreException {
        super((DataStoreProvider)sQLStoreProvider, storageConnector);
        ArgumentChecks.ensureNonEmpty("resources", resourceDefinitionArray);
        this.source = (DataSource)storageConnector.getStorageAs(DataSource.class);
        this.geomLibrary = (GeometryLibrary)((Object)storageConnector.getOption(OptionKey.GEOMETRY_LIBRARY));
        this.customizer = (SchemaModifier)storageConnector.getOption(SchemaModifier.OPTION);
        GenericName[] genericNameArray = new GenericName[resourceDefinitionArray.length];
        ResourceDefinition[] resourceDefinitionArray2 = new ResourceDefinition[resourceDefinitionArray.length];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < resourceDefinitionArray.length; ++i) {
            ResourceDefinition resourceDefinition = resourceDefinitionArray[i];
            ArgumentChecks.ensureNonNullElement("resources", i, resourceDefinition);
            GenericName genericName = resourceDefinition.getName();
            int n3 = genericName.depth();
            if (n3 < 1 || n3 > 3) {
                throw new IllegalNameException(Resources.format((short)3, genericName));
            }
            if (resourceDefinition.query == null) {
                genericNameArray[n++] = genericName;
                continue;
            }
            resourceDefinitionArray2[n2++] = resourceDefinition;
        }
        this.tableNames = ArraysExt.resize(genericNameArray, n);
        this.queries = ArraysExt.resize(resourceDefinitionArray2, n2);
        if (((Object)((Object)this)).getClass() == SQLStore.class) {
            this.listeners.useWarningEventsOnly();
        }
    }

    public Optional<ParameterValueGroup> getOpenParameters() {
        if (this.provider == null) {
            return Optional.empty();
        }
        ParameterValueGroup parameterValueGroup = this.provider.getOpenParameters().createValue();
        parameterValueGroup.parameter("location").setValue((Object)this.source);
        if (this.tableNames != null) {
            parameterValueGroup.parameter("tables").setValue((Object)this.tableNames);
        }
        if (this.queries != null) {
            LinkedHashMap<GenericName, String> linkedHashMap = new LinkedHashMap<GenericName, String>();
            for (ResourceDefinition resourceDefinition : this.queries) {
                linkedHashMap.put(resourceDefinition.getName(), resourceDefinition.query);
            }
            parameterValueGroup.parameter("queries").setValue(linkedHashMap);
        }
        return Optional.of(parameterValueGroup);
    }

    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.empty();
    }

    private synchronized Database<?> model() throws DataStoreException {
        if (this.model == null) {
            try (Connection connection = this.source.getConnection();){
                this.model = Database.create(this, this.source, connection, this.geomLibrary, this.tableNames, this.queries, this.customizer, this.listeners);
            }
            catch (DataStoreException dataStoreException) {
                throw dataStoreException;
            }
            catch (Exception exception) {
                throw new DataStoreException((Throwable)Exceptions.unwrap(exception));
            }
        }
        return this.model;
    }

    private Database<?> model(Connection connection) throws Exception {
        if (this.model == null) {
            this.model = Database.create(this, this.source, connection, this.geomLibrary, this.tableNames, this.queries, this.customizer, this.listeners);
        }
        return this.model;
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            MetadataBuilder metadataBuilder = new MetadataBuilder();
            metadataBuilder.addSpatialRepresentation(SpatialRepresentationType.TEXT_TABLE);
            try (String[] stringArray = this.source.getConnection();){
                Database<?> database = this.model((Connection)stringArray);
                if (database.hasGeometry()) {
                    metadataBuilder.addSpatialRepresentation(SpatialRepresentationType.VECTOR);
                }
                if (database.hasRaster()) {
                    metadataBuilder.addSpatialRepresentation(SpatialRepresentationType.GRID);
                }
                database.listTables(stringArray.getMetaData(), metadataBuilder);
            }
            catch (DataStoreException dataStoreException) {
                throw dataStoreException;
            }
            catch (Exception exception) {
                throw new DataStoreException((Throwable)Exceptions.unwrap(exception));
            }
            for (String string : NAME_GETTERS) {
                try {
                    String string2;
                    Method method = this.source.getClass().getMethod(string, new Class[0]);
                    if (method.getReturnType() != String.class || (string2 = Strings.trimOrNull((String)method.invoke((Object)this.source, new Object[0]))) == null) continue;
                    metadataBuilder.addTitle((CharSequence)string2);
                    break;
                }
                catch (NoSuchMethodException | SecurityException exception) {
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new DataStoreException((Throwable)Exceptions.unwrap(reflectiveOperationException));
                }
            }
            this.metadata = metadataBuilder.buildAndFreeze();
        }
        return this.metadata;
    }

    public Collection<FeatureSet> components() throws DataStoreException {
        return this.model().tables();
    }

    public FeatureSet findResource(String string) throws DataStoreException {
        return this.model().findTable(this, string);
    }

    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        if (storeListener == null || clazz == null || clazz.isAssignableFrom(WarningEvent.class)) {
            super.addListener(clazz, storeListener);
        }
    }

    public synchronized void close() throws DataStoreException {
        this.model = null;
    }
}

