/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.postgis;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.sql.feature.BinaryEncoding;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.Database;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.sql.feature.SelectionClauseWriter;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.sql.feature.ValueGetter;
import org.apache.sis.internal.sql.postgis.ExtendedClauseWriter;
import org.apache.sis.internal.sql.postgis.ExtendedInfo;
import org.apache.sis.internal.sql.postgis.ExtentEstimator;
import org.apache.sis.internal.sql.postgis.ObjectGetter;
import org.apache.sis.internal.sql.postgis.RasterGetter;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.Version;
import org.opengis.geometry.Envelope;

public final class Postgres<G>
extends Database<G> {
    private final Version postgisVersion;

    public Postgres(DataSource dataSource, Connection connection, DatabaseMetaData databaseMetaData, Geometries<G> geometries, StoreListeners storeListeners) throws SQLException {
        super(dataSource, databaseMetaData, geometries, storeListeners);
        Version version = null;
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT public.PostGIS_version();");){
            while (resultSet.next() && (version = Postgres.parseVersion(resultSet.getString(1))) == null) {
            }
        }
        catch (SQLException sQLException) {
            this.log(Resources.forLocale(null).getLogRecord(Level.CONFIG, (short)12, "PostGIS"));
        }
        this.postgisVersion = version;
    }

    static Version parseVersion(String string) {
        if (string != null) {
            int n = string.indexOf(32);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (!string.isEmpty()) {
                return new Version(string);
            }
        }
        return null;
    }

    @Override
    public ValueGetter<?> getMapping(Column column) {
        if ("geography".equalsIgnoreCase(column.typeName)) {
            return this.forGeometry(column);
        }
        if ("raster".equalsIgnoreCase(column.typeName)) {
            return new RasterGetter(column.getDefaultCRS().orElse(null), this.getBinaryEncoding(column));
        }
        return super.getMapping(column);
    }

    @Override
    protected int getArrayComponentType(Column column) {
        String string = column.typeName;
        if (string.equalsIgnoreCase("_text")) {
            return 12;
        }
        if (string.length() >= 2 && string.charAt(0) == '_') {
            try {
                return JDBCType.valueOf(string.substring(1).toUpperCase(Locale.US)).getVendorTypeNumber();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return super.getArrayComponentType(column);
    }

    @Override
    protected ValueGetter<Object> getDefaultMapping() {
        return ObjectGetter.INSTANCE;
    }

    @Override
    protected BinaryEncoding getBinaryEncoding(Column column) {
        if (column.type == 2004) {
            return super.getBinaryEncoding(column);
        }
        return BinaryEncoding.HEXADECIMAL;
    }

    @Override
    protected InfoStatements createInfoStatements(Connection connection) {
        return new ExtendedInfo(this, connection);
    }

    @Override
    protected void addIgnoredTables(Map<String, Boolean> map) {
        map.put("geography_columns", Boolean.TRUE);
        map.put("raster_columns", Boolean.TRUE);
        map.put("raster_overviews", Boolean.FALSE);
    }

    @Override
    protected SelectionClauseWriter getFilterToSQL() {
        return ExtendedClauseWriter.INSTANCE;
    }

    @Override
    protected Envelope getEstimatedExtent(TableReference tableReference, Column[] columnArray, boolean bl) throws SQLException {
        ExtentEstimator extentEstimator = new ExtentEstimator(this, tableReference, columnArray);
        try (Connection connection = this.source.getConnection();){
            GeneralEnvelope generalEnvelope;
            block12: {
                Statement statement = connection.createStatement();
                try {
                    generalEnvelope = extentEstimator.estimate(statement, bl);
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return generalEnvelope;
        }
    }
}

