/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AssociationRoleBuilder;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.PrimaryKey;
import org.apache.sis.internal.sql.feature.Relation;
import org.apache.sis.internal.sql.feature.SchemaModifier;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.sql.feature.ValueGetter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;
import org.opengis.util.GenericName;

abstract class FeatureAnalyzer {
    final Analyzer analyzer;
    final TableReference id;
    private Class<?> primaryKeyClass;
    private boolean primaryKeyNullable;
    final Set<String> primaryKey;
    private final Map<String, List<Relation>> foreignerKeys;
    final FeatureTypeBuilder feature;
    private int countLowerCaseStarts;
    boolean hasGeometry;
    boolean hasRaster;

    protected FeatureAnalyzer(Analyzer analyzer, TableReference tableReference) {
        this.analyzer = analyzer;
        this.id = tableReference;
        this.primaryKey = new LinkedHashSet<String>();
        this.foreignerKeys = new HashMap<String, List<Relation>>();
        this.feature = new FeatureTypeBuilder(analyzer.nameFactory, analyzer.database.geomLibrary.library, analyzer.database.listeners.getLocale());
    }

    abstract Relation[] getForeignerKeys(Relation.Direction var1) throws SQLException, DataStoreException;

    final void addForeignerKeys(Relation relation) {
        for (String string : relation.getOwnerColumns()) {
            CollectionsExt.addToMultiValuesMap(this.foreignerKeys, string, relation);
            relation = null;
        }
    }

    abstract Column[] createAttributes() throws Exception;

    final boolean createAttribute(Column column) throws Exception {
        boolean bl;
        boolean bl2 = this.primaryKey.contains(column.name);
        List<Relation> list = this.foreignerKeys.get(column.name);
        this.updateCaseHeuristic(column.label);
        AttributeTypeBuilder<?> attributeTypeBuilder = null;
        boolean bl3 = bl = bl2 || list == null;
        if (bl) {
            ValueGetter<?> valueGetter = this.analyzer.setValueGetter(column);
            attributeTypeBuilder = column.createAttribute(this.feature);
            if (bl2) {
                attributeTypeBuilder.addRole(AttributeRole.IDENTIFIER_COMPONENT);
                this.primaryKeyNullable |= column.isNullable;
                this.primaryKeyClass = Classes.findCommonClass(this.primaryKeyClass, valueGetter.valueType);
            }
            if (!this.hasGeometry && Geometries.isKnownType(valueGetter.valueType)) {
                this.hasGeometry = true;
                attributeTypeBuilder.addRole(AttributeRole.DEFAULT_GEOMETRY);
            }
            if (!this.hasRaster) {
                this.hasRaster = GridCoverage.class.isAssignableFrom(valueGetter.valueType);
            }
        }
        if (list != null) {
            int n = 0;
            for (Relation relation : list) {
                AssociationRoleBuilder associationRoleBuilder;
                if (relation == null || relation.excluded) continue;
                GenericName genericName = relation.getName(this.analyzer);
                Table table = this.analyzer.table(relation, genericName, this.id);
                relation.setPropertyName(column.propertyName, n++);
                if (table != null) {
                    relation.setSearchTable(this.analyzer, table, table.primaryKey, Relation.Direction.IMPORT);
                    associationRoleBuilder = this.feature.addAssociation(table.featureType);
                } else {
                    associationRoleBuilder = this.feature.addAssociation(genericName);
                }
                associationRoleBuilder.setName((CharSequence)relation.propertyName);
                if (column.isNullable) {
                    associationRoleBuilder.setMinimumOccurs(0);
                }
                if (attributeTypeBuilder == null) continue;
                attributeTypeBuilder.setName(this.analyzer.nameFactory.createGenericName(null, new CharSequence[]{"pk", column.propertyName}));
                column.propertyName = attributeTypeBuilder.getName().toString();
                attributeTypeBuilder = null;
            }
        }
        return bl;
    }

    final PrimaryKey createAssociations(Relation[] relationArray) throws Exception {
        if (this.primaryKey.size() > 1) {
            if (!this.primaryKeyNullable) {
                this.primaryKeyClass = Numbers.wrapperToPrimitive(this.primaryKeyClass);
            }
            this.primaryKeyClass = Classes.changeArrayDimension(this.primaryKeyClass, 1);
        }
        PrimaryKey primaryKey = PrimaryKey.create(this.primaryKeyClass, this.primaryKey);
        int n = 0;
        for (Relation relation : relationArray) {
            AssociationRoleBuilder associationRoleBuilder;
            String string;
            if (relation == null || relation.excluded) continue;
            GenericName genericName = relation.getName(this.analyzer);
            String string2 = string = this.toHeuristicLabel(genericName.tip().toString());
            while (this.feature.isNameUsed(string)) {
                string = string2 + '-' + ++n;
            }
            relation.propertyName = string;
            Table table = this.analyzer.table(relation, genericName, this.id);
            if (table != null) {
                relation.setSearchTable(this.analyzer, table, primaryKey, Relation.Direction.EXPORT);
                associationRoleBuilder = this.feature.addAssociation(table.featureType);
            } else {
                associationRoleBuilder = this.feature.addAssociation(genericName);
            }
            associationRoleBuilder.setName((CharSequence)string).setMinimumOccurs(0).setMaximumOccurs(Integer.MAX_VALUE);
        }
        return primaryKey;
    }

    private void updateCaseHeuristic(String string) {
        if (!string.isEmpty()) {
            int n = string.codePointAt(0);
            if (Character.isLowerCase(n)) {
                ++this.countLowerCaseStarts;
            } else if (Character.isUpperCase(n) && !CharSequences.isUpperCase(string)) {
                --this.countLowerCaseStarts;
            }
        }
    }

    private String toHeuristicLabel(String string) {
        if (this.countLowerCaseStarts > 0) {
            CharSequence charSequence = CharSequences.camelCaseToWords(string, true);
            int n = Character.codePointAt(charSequence, 0);
            string = new StringBuilder(charSequence.length()).appendCodePoint(Character.toLowerCase(n)).append(charSequence, Character.charCount(n), charSequence.length()).toString();
        }
        return string;
    }

    final DataStoreContentException duplicatedColumn(Column column) {
        return new DataStoreContentException(this.analyzer.resources().getString((short)5, column.name));
    }

    String getRemarks() throws SQLException {
        return this.id.freeText;
    }

    final DefaultFeatureType buildFeatureType() throws DataStoreException, SQLException {
        String string = this.id.freeText;
        if (string != null) {
            this.feature.setDefinition(string);
        }
        this.feature.setName(this.id.getName(this.analyzer));
        SchemaModifier schemaModifier = this.analyzer.customizer;
        return schemaModifier != null ? schemaModifier.editFeatureType(this.id, this.feature) : this.feature.build();
    }
}

