/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.storage.geotiff.GeoKeys;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Utilities;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;

final class CRSBuilder
extends ReferencingFactoryContainer {
    private static final int ENTRY_LENGTH = 4;
    private static final char SEPARATOR = '|';
    static final int PRIMEM = 0;
    static final int ELLIPSOID = 1;
    static final int DATUM = 2;
    static final int GCRS = 3;
    private static final String[] NAME_KEYS = new String[]{"PrimeM", "PrimeMeridian", "Spheroid", "Ellipsoid", "Datum", "GeodeticDatum"};
    private static final int MIN_KEY_LENGTH = 5;
    private final Reader reader;
    private short majorRevision;
    private short minorRevision;
    private final Map<Short, Object> geoKeys;
    private Identifier lastName;
    public String description;
    public CellGeometry cellGeometry;
    boolean alreadyReported;
    private static final short[][] PARAMETER_ALIASES = new short[][]{{3080, 3084, 3088}, {3081, 3085, 3089}, {3082, 3086, 3090}, {3083, 3087, 3091}, {3092, 3093}};

    CRSBuilder(Reader reader) {
        this.reader = reader;
        this.geoKeys = new HashMap<Short, Object>(32);
    }

    private void warning(short s, Object ... objectArray) {
        LogRecord logRecord = this.reader.resources().getLogRecord(Level.WARNING, s, objectArray);
        this.reader.store.warning(logRecord);
    }

    private Map<String, ?> properties(Object object) {
        if (object == null) {
            object = NilReferencingObject.UNNAMED;
        } else if (this.lastName != null && this.lastName.getCode().equals(object)) {
            object = this.lastName;
        }
        return Collections.singletonMap("name", object);
    }

    private Object getSingleton(short s) {
        Object object = this.geoKeys.remove(s);
        if (object != null && object.getClass().isArray()) {
            this.warning((short)16, GeoKeys.name(s), Array.getLength(object));
            object = Array.get(object, 0);
        }
        return object;
    }

    private String getAsString(short s) {
        Object object = this.geoKeys.remove(s);
        if (object != null) {
            if (object.getClass().isArray()) {
                int n = Array.getLength(object);
                StringJoiner stringJoiner = new StringJoiner(", ");
                for (int i = 0; i < n; ++i) {
                    stringJoiner.add(String.valueOf(Array.get(object, i)));
                }
                object = stringJoiner;
            }
            return object.toString();
        }
        return null;
    }

    private int getAsInteger(short s) {
        Object object = this.getSingleton(s);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.invalidValue(s, object);
            this.alreadyReported = true;
            throw numberFormatException;
        }
    }

    private double getAsDouble(short s) {
        Object object = this.getSingleton(s);
        if (object == null) {
            return Double.NaN;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.invalidValue(s, object);
            this.alreadyReported = true;
            throw numberFormatException;
        }
    }

    private String getMandatoryString(short s) {
        String string = this.getAsString(s);
        if (string != null) {
            return string;
        }
        this.alreadyReported = true;
        throw new NoSuchElementException(this.missingValue(s));
    }

    private double getMandatoryDouble(short s) {
        double d = this.getAsDouble(s);
        if (Double.isFinite(d)) {
            return d;
        }
        this.alreadyReported = true;
        throw new NoSuchElementException(this.missingValue(s));
    }

    private String missingValue(short s) {
        String string = GeoKeys.name(s);
        this.warning((short)12, string);
        return string;
    }

    private void invalidValue(short s, Object object) {
        this.warning((short)9, GeoKeys.name(s), object);
    }

    private void verify(IdentifiedObject identifiedObject, double d, short s, Unit<?> unit) {
        double d2 = this.getAsDouble(s);
        if (Math.abs(d - d2) > d * 1.0E-13) {
            String string = "";
            if (unit != null && !(string = unit.toString()).isEmpty() && Character.isLetterOrDigit(string.codePointAt(0))) {
                string = ' ' + string;
            }
            this.warning((short)14, IdentifiedObjects.getIdentifierOrName((IdentifiedObject)identifiedObject), String.valueOf(d), GeoKeys.name(s), String.valueOf(d2), string);
        }
    }

    private void verifyIdentifier(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2, short s) {
        Identifier identifier;
        int n = this.getAsInteger(s);
        if (n > 0 && n < Short.MAX_VALUE && (identifier = IdentifiedObjects.getIdentifier((IdentifiedObject)identifiedObject2, Citations.EPSG)) != null) {
            int n2;
            try {
                n2 = Integer.parseInt(identifier.getCode());
            }
            catch (NumberFormatException numberFormatException) {
                this.reader.store.warning(null, numberFormatException);
                return;
            }
            if (n != n2) {
                this.warning((short)14, IdentifiedObjects.getIdentifierOrName((IdentifiedObject)identifiedObject), "EPSG:" + n2, GeoKeys.name(s), "EPSG:" + n, "");
            }
        }
    }

    public CoordinateReferenceSystem build(Vector vector, Vector vector2, String string) throws FactoryException {
        VerticalCRS stringJoiner;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = vector.size();
        if (n5 >= 4) {
            n4 = vector.intValue(0);
            if (n4 != 1) {
                this.warning((short)20, n4);
                return null;
            }
            this.majorRevision = vector.shortValue(1);
            this.minorRevision = vector.shortValue(2);
            n3 = vector.intValue(3);
        } else {
            n3 = 0;
        }
        n4 = (n3 + 1) * 4;
        if (n5 < n4) {
            this.warning((short)10, "GeoKeyDirectory", n4, n5);
            return null;
        }
        int n6 = vector2 != null ? vector2.size() : 0;
        int n7 = string != null ? string.length() : 0;
        block29: for (n2 = 1; n2 <= n3; ++n2) {
            Object i;
            int n8 = n2 * 4;
            short s = vector.shortValue(n8);
            int verticalCRS = vector.intValue(n8 + 1);
            int shortArray = vector.intValue(n8 + 2);
            n = vector.intValue(n8 + 3);
            if (n < 0 || shortArray < 0) {
                this.missingValue(s);
                continue;
            }
            switch (verticalCRS) {
                case 0: {
                    switch (shortArray) {
                        case 0: {
                            continue block29;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            this.warning((short)16, GeoKeys.name(s), shortArray);
                        }
                    }
                    i = n;
                    break;
                }
                case 34735: {
                    if (n + shortArray > vector.size()) {
                        this.missingValue(s);
                        continue block29;
                    }
                    switch (shortArray) {
                        case 0: {
                            continue block29;
                        }
                        case 1: {
                            i = vector.get(n);
                            break;
                        }
                        default: {
                            int[] dArray = new int[shortArray];
                            for (int i2 = 0; i2 < shortArray; ++i2) {
                                dArray[i2] = vector.intValue(n + i2);
                            }
                            i = dArray;
                            break;
                        }
                    }
                    break;
                }
                case 34736: {
                    if (n + shortArray > n6) {
                        this.missingValue(s);
                        continue block29;
                    }
                    switch (shortArray) {
                        case 0: {
                            continue block29;
                        }
                        case 1: {
                            i = vector2.get(n);
                            break;
                        }
                        default: {
                            double[] n11 = new double[shortArray];
                            for (int string2 = 0; string2 < shortArray; ++string2) {
                                n11[string2] = vector2.doubleValue(n + string2);
                            }
                            i = n11;
                            break;
                        }
                    }
                    break;
                }
                case 34737: {
                    int s2 = n + shortArray;
                    if (s2 > n7) {
                        this.missingValue(s);
                        continue block29;
                    }
                    for (s2 = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)n, (int)s2); s2 > n && string.charAt(s2 - 1) == '|'; --s2) {
                    }
                    String string2 = string.substring(n, s2).trim();
                    if (string2.isEmpty()) continue block29;
                    i = string2;
                    break;
                }
                default: {
                    this.warning((short)21, GeoKeys.name(s));
                    continue block29;
                }
            }
            this.geoKeys.put(s, i);
        }
        this.description = this.getAsString((short)1026);
        n2 = this.getAsInteger((short)1025);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                this.cellGeometry = CellGeometry.AREA;
                break;
            }
            case 2: {
                this.cellGeometry = CellGeometry.POINT;
                break;
            }
            default: {
                this.invalidValue((short)1025, n2);
            }
        }
        ProjectedCRS projectedCRS = null;
        int n8 = this.getAsInteger((short)1024);
        switch (n8) {
            case 0: {
                break;
            }
            case 1: {
                projectedCRS = this.createProjectedCRS();
                break;
            }
            case 3: {
                projectedCRS = this.createGeocentricCRS();
                break;
            }
            case 2: {
                projectedCRS = this.createGeographicCRS();
                break;
            }
            default: {
                this.warning((short)19, n8);
            }
        }
        if (n8 != 3 && (stringJoiner = this.createVerticalCRS()) != null) {
            if (projectedCRS == null) {
                this.missingValue((short)2048);
            } else {
                projectedCRS = this.getCRSFactory().createCompoundCRS(Collections.singletonMap("name", projectedCRS.getName()), new CoordinateReferenceSystem[]{projectedCRS, stringJoiner});
            }
        }
        if (!this.geoKeys.isEmpty()) {
            StringJoiner stringJoiner2 = new StringJoiner(", ");
            Short[] shortArray = this.remainingKeys();
            n = shortArray.length;
            for (int i = 0; i < n; ++i) {
                short s = shortArray[i];
                stringJoiner2.add(GeoKeys.name(s));
            }
            this.warning((short)6, stringJoiner2.toString());
        }
        return projectedCRS;
    }

    private Short[] remainingKeys() {
        Object[] objectArray = this.geoKeys.keySet().toArray(new Short[this.geoKeys.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private CartesianCS replaceLinearUnit(CartesianCS cartesianCS, Unit<Length> unit) throws FactoryException {
        Integer n = CoordinateSystems.getEpsgCode(unit, (AxisDirection[])CoordinateSystems.getAxisDirections((CoordinateSystem)cartesianCS));
        if (n != null) {
            try {
                return this.getCSAuthorityFactory().createCartesianCS(n.toString());
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                this.reader.store.warning(null, (Exception)((Object)noSuchAuthorityCodeException));
            }
        }
        return (CartesianCS)CoordinateSystems.replaceLinearUnit((CoordinateSystem)cartesianCS, unit);
    }

    private EllipsoidalCS replaceAngularUnit(EllipsoidalCS ellipsoidalCS, Unit<Angle> unit) throws FactoryException {
        Integer n = CoordinateSystems.getEpsgCode(unit, (AxisDirection[])CoordinateSystems.getAxisDirections((CoordinateSystem)ellipsoidalCS));
        if (n != null) {
            try {
                return this.getCSAuthorityFactory().createEllipsoidalCS(n.toString());
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                this.reader.store.warning(null, (Exception)((Object)noSuchAuthorityCodeException));
            }
        }
        return (EllipsoidalCS)CoordinateSystems.replaceAngularUnit((CoordinateSystem)ellipsoidalCS, unit);
    }

    private <Q extends Quantity<Q>> Unit<Q> createUnit(short s, short s2, Class<Q> clazz, Unit<Q> unit) throws FactoryException {
        double d;
        double d2;
        int n = this.getAsInteger(s);
        switch (n) {
            case 0: {
                return unit;
            }
            case 32767: {
                if (s2 == 0) {
                    return unit;
                }
                return unit.getSystemUnit().multiply(this.getMandatoryDouble(s2));
            }
            case 65535: {
                double d3;
                if (s2 != 0 && Double.isFinite(d3 = this.getAsDouble(s2))) {
                    return unit.getSystemUnit().multiply(d3);
                }
                return unit;
            }
        }
        Unit unit2 = this.getCSAuthorityFactory().createUnit(String.valueOf(n)).asType(clazz);
        if (s2 != 0 && !Double.isNaN(d2 = this.getAsDouble(s2)) && Math.abs((d = unit2.getConverterTo(unit.getSystemUnit()).convert(1.0)) - d2) > d * 1.0E-13) {
            this.warning((short)14, "EPSG:" + n, d, GeoKeys.name(s2), d2, "");
        }
        return unit2;
    }

    private PrimeMeridian createPrimeMeridian(String[] stringArray, Unit<Angle> unit) throws FactoryException {
        int n = this.getAsInteger((short)2051);
        switch (n) {
            case 0: 
            case 32767: {
                double d = this.getAsDouble((short)2061);
                if (Double.isNaN(d)) {
                    if (n == 0) break;
                    this.missingValue((short)2061);
                    break;
                }
                if (d == 0.0) break;
                return this.getDatumFactory().createPrimeMeridian(this.properties(stringArray[0]), d, unit);
            }
            default: {
                PrimeMeridian primeMeridian = this.getDatumAuthorityFactory().createPrimeMeridian(String.valueOf(n));
                this.verify(primeMeridian, unit);
                return primeMeridian;
            }
        }
        return CommonCRS.WGS84.primeMeridian();
    }

    private void verify(PrimeMeridian primeMeridian, Unit<Angle> unit) {
        this.verify((IdentifiedObject)primeMeridian, ReferencingUtilities.getGreenwichLongitude((PrimeMeridian)primeMeridian, unit), (short)2061, unit);
    }

    private Ellipsoid createEllipsoid(String[] stringArray, Unit<Length> unit) throws FactoryException {
        int n = this.getAsInteger((short)2056);
        switch (n) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)2050));
            }
            case 32767: {
                Ellipsoid ellipsoid;
                Map<String, ?> map = this.properties(CRSBuilder.getOrDefault(stringArray, 1));
                double d = this.getMandatoryDouble((short)2057);
                double d2 = this.getAsDouble((short)2059);
                if (!Double.isNaN(d2)) {
                    ellipsoid = this.getDatumFactory().createFlattenedSphere(map, d, d2, unit);
                } else {
                    double d3 = this.getMandatoryDouble((short)2058);
                    ellipsoid = this.getDatumFactory().createEllipsoid(map, d, d3, unit);
                }
                this.lastName = ellipsoid.getName();
                return ellipsoid;
            }
        }
        Ellipsoid ellipsoid = this.getDatumAuthorityFactory().createEllipsoid(String.valueOf(n));
        this.verify(ellipsoid, unit);
        return ellipsoid;
    }

    private void verify(Ellipsoid ellipsoid, Unit<Length> unit) {
        UnitConverter unitConverter = ellipsoid.getAxisUnit().getConverterTo(unit);
        this.verify((IdentifiedObject)ellipsoid, unitConverter.convert(ellipsoid.getSemiMajorAxis()), (short)2057, unit);
        this.verify((IdentifiedObject)ellipsoid, unitConverter.convert(ellipsoid.getSemiMinorAxis()), (short)2058, unit);
        this.verify((IdentifiedObject)ellipsoid, ellipsoid.getInverseFlattening(), (short)2059, null);
    }

    private GeodeticDatum createGeodeticDatum(String[] stringArray, Unit<Angle> unit, Unit<Length> unit2) throws FactoryException {
        int n = this.getAsInteger((short)2050);
        switch (n) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)2050));
            }
            case 32767: {
                String string = CRSBuilder.getOrDefault(stringArray, 2);
                Ellipsoid ellipsoid = this.createEllipsoid(stringArray, unit2);
                PrimeMeridian primeMeridian = this.createPrimeMeridian(stringArray, unit);
                GeodeticDatum geodeticDatum = this.getDatumFactory().createGeodeticDatum(this.properties(string), ellipsoid, primeMeridian);
                string = Strings.toUpperCase((String)string, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true);
                this.lastName = geodeticDatum.getName();
                try {
                    GeodeticDatum geodeticDatum2 = CommonCRS.valueOf((String)string).datum();
                    if (Utilities.equalsIgnoreMetadata((Object)geodeticDatum2.getEllipsoid(), (Object)ellipsoid) && Utilities.equalsIgnoreMetadata((Object)geodeticDatum2.getPrimeMeridian(), (Object)primeMeridian)) {
                        return geodeticDatum2;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return geodeticDatum;
            }
        }
        GeodeticDatum geodeticDatum = this.getDatumAuthorityFactory().createGeodeticDatum(String.valueOf(n));
        this.verify(geodeticDatum, unit, unit2);
        return geodeticDatum;
    }

    private void verify(GeodeticDatum geodeticDatum, Unit<Angle> unit, Unit<Length> unit2) {
        PrimeMeridian primeMeridian = geodeticDatum.getPrimeMeridian();
        this.verifyIdentifier((IdentifiedObject)geodeticDatum, (IdentifiedObject)primeMeridian, (short)2051);
        this.verify(primeMeridian, unit);
        Ellipsoid ellipsoid = geodeticDatum.getEllipsoid();
        this.verifyIdentifier((IdentifiedObject)geodeticDatum, (IdentifiedObject)ellipsoid, (short)2056);
        this.verify(ellipsoid, unit2);
    }

    static String[] splitName(String string) {
        String[] stringArray = new String[4];
        String[] stringArray2 = (String[])CharSequences.split((CharSequence)string, (char)'|');
        switch (stringArray2.length) {
            case 0: {
                break;
            }
            case 1: {
                stringArray[3] = string;
                break;
            }
            default: {
                for (String string2 : stringArray2) {
                    int n = string2.indexOf(61);
                    int n2 = 3;
                    if (n >= 0) {
                        int n3 = CharSequences.skipTrailingWhitespaces((CharSequence)string2, (int)0, (int)n);
                        if (n3 >= 5) {
                            for (int i = 0; i < NAME_KEYS.length; ++i) {
                                if (!string2.regionMatches(true, 0, NAME_KEYS[i], 0, n3)) continue;
                                n2 = i / 2;
                                break;
                            }
                        }
                        string2 = string2.substring(CharSequences.skipLeadingWhitespaces((CharSequence)string2, (int)(n + 1), (int)string2.length()));
                    }
                    if (string2.isEmpty()) continue;
                    if (stringArray[n2] != null) {
                        string2 = stringArray[n2] + ' ' + string2;
                    }
                    stringArray[n2] = string2;
                }
            }
        }
        return stringArray;
    }

    private static String getOrDefault(String[] stringArray, int n) {
        String string = stringArray[n];
        if (string == null) {
            n = 0;
            while (++n < stringArray.length && (string = stringArray[n]) == null) {
                ++n;
            }
        }
        return string;
    }

    private GeographicCRS createGeographicCRS() throws FactoryException {
        return this.createGeographicCRS(true, this.createUnit((short)2054, (short)2055, Angle.class, Units.DEGREE));
    }

    private GeographicCRS createGeographicCRS(boolean bl, Unit<Angle> unit) throws FactoryException {
        int n = this.getAsInteger((short)2048);
        switch (n) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)2048));
            }
            case 32767: {
                String[] stringArray = CRSBuilder.splitName(this.getAsString((short)2049));
                Unit<Length> unit2 = this.createUnit((short)2052, (short)2053, Length.class, Units.METRE);
                GeodeticDatum geodeticDatum = this.createGeodeticDatum(stringArray, unit, unit2);
                EllipsoidalCS ellipsoidalCS = CommonCRS.defaultGeographic().getCoordinateSystem();
                if (!Units.DEGREE.equals(unit)) {
                    ellipsoidalCS = this.replaceAngularUnit(ellipsoidalCS, unit);
                }
                GeographicCRS geographicCRS = this.getCRSFactory().createGeographicCRS(this.properties(CRSBuilder.getOrDefault(stringArray, 3)), geodeticDatum, ellipsoidalCS);
                this.lastName = geographicCRS.getName();
                return geographicCRS;
            }
        }
        GeographicCRS geographicCRS = this.getCRSAuthorityFactory().createGeographicCRS(String.valueOf(n));
        if (bl) {
            geographicCRS = DefaultGeographicCRS.castOrCopy((GeographicCRS)geographicCRS).forConvention(AxesConvention.RIGHT_HANDED);
        }
        this.verify(geographicCRS, unit);
        return geographicCRS;
    }

    private void verify(GeographicCRS geographicCRS, Unit<Angle> unit) throws FactoryException {
        Unit<Length> unit2 = this.createUnit((short)2052, (short)2053, Length.class, Units.METRE);
        GeodeticDatum geodeticDatum = geographicCRS.getDatum();
        this.verifyIdentifier((IdentifiedObject)geographicCRS, (IdentifiedObject)geodeticDatum, (short)2050);
        this.verify(geodeticDatum, unit, unit2);
        this.geoKeys.remove((short)2049);
    }

    private GeocentricCRS createGeocentricCRS() throws FactoryException {
        int n = this.getAsInteger((short)2048);
        switch (n) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)2048));
            }
            case 32767: {
                String[] stringArray = CRSBuilder.splitName(this.getAsString((short)2049));
                Unit<Length> unit = this.createUnit((short)2052, (short)2053, Length.class, Units.METRE);
                Unit<Angle> unit2 = this.createUnit((short)2054, (short)2055, Angle.class, Units.DEGREE);
                GeodeticDatum geodeticDatum = this.createGeodeticDatum(stringArray, unit2, unit);
                CartesianCS cartesianCS = (CartesianCS)CommonCRS.WGS84.geocentric().getCoordinateSystem();
                if (!Units.METRE.equals(unit)) {
                    cartesianCS = this.replaceLinearUnit(cartesianCS, unit);
                }
                GeocentricCRS geocentricCRS = this.getCRSFactory().createGeocentricCRS(this.properties(CRSBuilder.getOrDefault(stringArray, 3)), geodeticDatum, cartesianCS);
                this.lastName = geocentricCRS.getName();
                return geocentricCRS;
            }
        }
        GeocentricCRS geocentricCRS = this.getCRSAuthorityFactory().createGeocentricCRS(String.valueOf(n));
        this.verify(geocentricCRS);
        return geocentricCRS;
    }

    private void verify(GeocentricCRS geocentricCRS) throws FactoryException {
        Unit<Length> unit = this.createUnit((short)2052, (short)2053, Length.class, Units.METRE);
        Unit<Angle> unit2 = this.createUnit((short)2054, (short)2055, Angle.class, Units.DEGREE);
        GeodeticDatum geodeticDatum = geocentricCRS.getDatum();
        this.verifyIdentifier((IdentifiedObject)geocentricCRS, (IdentifiedObject)geodeticDatum, (short)2050);
        this.verify(geodeticDatum, unit2, unit);
    }

    private static void aliases(Map<Integer, String> map) {
        block0: for (short[] sArray : PARAMETER_ALIASES) {
            for (int i = 0; i < sArray.length; ++i) {
                String string = map.get(Short.toUnsignedInt(sArray[i]));
                if (string == null) continue;
                for (int j = 0; j < sArray.length; ++j) {
                    if (j == i) continue;
                    map.putIfAbsent(Short.toUnsignedInt(sArray[j]), string);
                }
                continue block0;
            }
        }
    }

    private ProjectedCRS createProjectedCRS() throws FactoryException {
        int n = this.getAsInteger((short)3072);
        switch (n) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)3072));
            }
            case 32767: {
                String string = this.getAsString((short)3073);
                if (string == null) {
                    string = this.getAsString((short)1026);
                }
                Unit<Length> unit = this.createUnit((short)3076, (short)3077, Length.class, Units.METRE);
                Unit<Angle> unit2 = this.createUnit((short)2054, (short)2055, Angle.class, Units.DEGREE);
                GeographicCRS geographicCRS = this.createGeographicCRS(false, unit2);
                Conversion conversion = this.createConversion(string, unit2, unit);
                CartesianCS cartesianCS = this.getStandardProjectedCS();
                if (!Units.METRE.equals(unit)) {
                    cartesianCS = this.replaceLinearUnit(cartesianCS, unit);
                }
                ProjectedCRS projectedCRS = this.getCRSFactory().createProjectedCRS(this.properties(string), geographicCRS, conversion, cartesianCS);
                this.lastName = projectedCRS.getName();
                return projectedCRS;
            }
        }
        ProjectedCRS projectedCRS = this.getCRSAuthorityFactory().createProjectedCRS(String.valueOf(n));
        this.verify(projectedCRS);
        return projectedCRS;
    }

    private void verify(ProjectedCRS projectedCRS) throws FactoryException {
        Unit<Length> unit = this.createUnit((short)3076, (short)3077, Length.class, Units.METRE);
        Unit<Angle> unit2 = this.createUnit((short)2054, (short)2055, Angle.class, Units.DEGREE);
        GeographicCRS geographicCRS = projectedCRS.getBaseCRS();
        this.verifyIdentifier((IdentifiedObject)projectedCRS, (IdentifiedObject)geographicCRS, (short)2048);
        this.verify(geographicCRS, unit2);
        Projection projection = projectedCRS.getConversionFromBase();
        this.verifyIdentifier((IdentifiedObject)projectedCRS, (IdentifiedObject)projection, (short)3074);
        this.verify((Conversion)projection, unit2, unit);
    }

    private Conversion createConversion(String string, Unit<Angle> unit, Unit<Length> unit2) throws FactoryException {
        int n = this.getAsInteger((short)3074);
        switch (n) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)3074));
            }
            case 32767: {
                Object object;
                Object object2;
                Unit<Length> unit3;
                Short s;
                Unit<Angle> unit4 = this.createUnit((short)2060, (short)0, Angle.class, Units.DEGREE);
                String string2 = this.getMandatoryString((short)3075);
                OperationMethod operationMethod = this.getCoordinateOperationFactory().getOperationMethod("GeoTIFF:" + string2);
                ParameterValueGroup parameterValueGroup = operationMethod.getParameters().createValue();
                Map map = ReferencingUtilities.identifierToName((ParameterDescriptorGroup)parameterValueGroup.getDescriptor(), Citations.GEOTIFF);
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                HashMap<Short, Unit<Length>> hashMap2 = new HashMap<Short, Unit<Length>>();
                Iterator<Map.Entry<Short, Object>> iterator = this.geoKeys.entrySet().iterator();
                block10: while (iterator.hasNext()) {
                    Map.Entry<Short, Object> entry = iterator.next();
                    s = entry.getKey();
                    switch (GeoKeys.unitOf(s)) {
                        case 0: {
                            unit3 = Units.UNITY;
                            break;
                        }
                        case 1: {
                            unit3 = unit2;
                            break;
                        }
                        case 2: {
                            unit3 = unit;
                            break;
                        }
                        case 3: {
                            unit3 = unit4;
                            break;
                        }
                        default: {
                            continue block10;
                        }
                    }
                    object2 = (Number)entry.getValue();
                    iterator.remove();
                    object = (String)map.get(Short.toUnsignedInt(s));
                    if (object != null) {
                        hashMap.put(object, object2);
                        parameterValueGroup.parameter((String)object).setValue(((Number)object2).doubleValue(), unit3);
                        continue;
                    }
                    hashMap.put(s, object2);
                    hashMap2.put(s, unit3);
                }
                if (!hashMap2.isEmpty()) {
                    CRSBuilder.aliases(map);
                    for (Map.Entry entry : hashMap2.entrySet()) {
                        s = (Short)entry.getKey();
                        object2 = (String)map.get(Short.toUnsignedInt(s));
                        if (object2 == null) {
                            object2 = GeoKeys.name(s);
                            throw new ParameterNotFoundException(this.reader.errors().getString((short)140, object2), (String)object2);
                        }
                        object = (Number)hashMap.get(s);
                        Number number = (Number)hashMap.putIfAbsent(object2, object);
                        if (number == null) {
                            parameterValueGroup.parameter((String)object2).setValue(((Number)object).doubleValue(), (Unit)entry.getValue());
                            continue;
                        }
                        if (number.equals(object)) continue;
                        this.warning((short)24, object2, number, GeoKeys.name(s), object);
                    }
                }
                unit3 = this.getCoordinateOperationFactory().createDefiningConversion(this.properties(string), operationMethod, parameterValueGroup);
                this.lastName = unit3.getName();
                return unit3;
            }
        }
        Conversion conversion = (Conversion)this.getCoordinateOperationAuthorityFactory().createCoordinateOperation(String.valueOf(n));
        this.verify(conversion, unit, unit2);
        return conversion;
    }

    private void verify(Conversion conversion, Unit<Angle> unit, Unit<Length> unit2) throws FactoryException {
        Unit<Angle> unit3 = this.createUnit((short)2060, (short)0, Angle.class, Units.DEGREE);
        String string = this.getAsString((short)3075);
        if (string != null) {
            ParameterValueGroup parameterValueGroup;
            OperationMethod operationMethod = conversion.getMethod();
            if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)operationMethod, (String)string)) {
                parameterValueGroup = IdentifiedObjects.getIdentifier((IdentifiedObject)operationMethod, Citations.GEOTIFF);
                if (parameterValueGroup == null) {
                    parameterValueGroup = IdentifiedObjects.getIdentifier((IdentifiedObject)operationMethod, null);
                }
                this.warning((short)14, IdentifiedObjects.getIdentifierOrName((IdentifiedObject)conversion), parameterValueGroup.getCode(), GeoKeys.name((short)3075), string, "");
            }
            parameterValueGroup = conversion.getParameterValues();
            Short[] shortArray = this.remainingKeys();
            int n = shortArray.length;
            block8: for (int i = 0; i < n; ++i) {
                Unit<Length> unit4;
                short s = shortArray[i];
                switch (GeoKeys.unitOf(s)) {
                    case 0: {
                        unit4 = Units.UNITY;
                        break;
                    }
                    case 1: {
                        unit4 = unit2;
                        break;
                    }
                    case 2: {
                        unit4 = unit;
                        break;
                    }
                    case 3: {
                        unit4 = unit3;
                        break;
                    }
                    default: {
                        continue block8;
                    }
                }
                try {
                    this.verify((IdentifiedObject)conversion, parameterValueGroup.parameter("GeoTIFF:" + s).doubleValue(unit4), s, unit4);
                    continue;
                }
                catch (ParameterNotFoundException parameterNotFoundException) {
                    this.warning((short)17, string, GeoKeys.name(s));
                }
            }
        }
    }

    private VerticalDatum createVerticalDatum() throws FactoryException {
        int n = this.getAsInteger((short)4098);
        switch (n) {
            case 0: 
            case 32767: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)4098));
            }
        }
        return this.getDatumAuthorityFactory().createVerticalDatum(String.valueOf(n));
    }

    private VerticalCRS createVerticalCRS() throws FactoryException {
        int n = this.getAsInteger((short)4096);
        switch (n) {
            case 0: {
                return null;
            }
            case 32767: {
                String string = this.getAsString((short)4097);
                VerticalDatum verticalDatum = this.createVerticalDatum();
                Unit<Length> unit = this.createUnit((short)4099, (short)0, Length.class, Units.METRE);
                VerticalCS verticalCS = CommonCRS.Vertical.MEAN_SEA_LEVEL.crs().getCoordinateSystem();
                if (!Units.METRE.equals(unit)) {
                    verticalCS = (VerticalCS)CoordinateSystems.replaceLinearUnit((CoordinateSystem)verticalCS, unit);
                }
                return this.getCRSFactory().createVerticalCRS(this.properties(string), verticalDatum, verticalCS);
            }
        }
        return this.getCRSAuthorityFactory().createVerticalCRS(String.valueOf(n));
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("GeoTIFF keys ").append(this.majorRevision).append('.').append(this.minorRevision).append(" in ").append(this.reader.input.filename).append(System.lineSeparator());
        TableAppender tableAppender = new TableAppender((Appendable)stringBuilder, " ");
        for (Map.Entry<Short, Object> entry : this.geoKeys.entrySet()) {
            short s = entry.getKey();
            tableAppender.append((CharSequence)String.valueOf(s)).nextColumn();
            tableAppender.append((CharSequence)GeoKeys.name(s)).nextColumn();
            tableAppender.append((CharSequence)" = ").append((CharSequence)String.valueOf(entry.getValue())).nextLine();
        }
        try {
            tableAppender.flush();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return stringBuilder.toString();
    }
}

