/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.inflater.CompressionChannel;
import org.apache.sis.internal.storage.inflater.PixelChannel;
import org.apache.sis.util.ArraysExt;

abstract class PredictorChannel
extends PixelChannel {
    private final CompressionChannel input;
    private byte[] deferred;
    private int deferredCount;

    protected PredictorChannel(CompressionChannel compressionChannel) {
        this.input = compressionChannel;
        this.deferred = ArraysExt.EMPTY_BYTE;
    }

    @Override
    public void setInput(long l, long l2) throws IOException {
        this.input.setInput(l, l2);
    }

    protected abstract int uncompress(ByteBuffer var1, int var2);

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        if (this.deferredCount != 0) {
            n = Math.min(this.deferredCount, byteBuffer.remaining());
            byteBuffer.put(this.deferred, 0, n);
            this.deferredCount -= n;
        }
        this.input.read(byteBuffer);
        n = this.uncompress(byteBuffer, n2);
        this.deferredCount = byteBuffer.position() - n;
        if (this.deferredCount != 0) {
            if (this.deferredCount > this.deferred.length) {
                this.deferred = new byte[this.deferredCount];
            }
            JDK9.get((ByteBuffer)byteBuffer, (int)n, (byte[])this.deferred, (int)0, (int)this.deferredCount);
            byteBuffer.position(n);
        }
        return n - n2;
    }

    @Override
    public final boolean isOpen() {
        return this.input.isOpen();
    }

    @Override
    public final void close() {
        this.input.close();
    }
}

