/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.sis.internal.storage.inflater.CompressionChannel;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.util.ArraysExt;

final class LZW
extends CompressionChannel {
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int FIRST_ADAPTATIVE_CODE = 258;
    private static final int OFFSET_TO_MAXIMUM = 259;
    private static final int MIN_CODE_SIZE = 9;
    private static final int MAX_CODE_SIZE = 12;
    private final byte[][] sequencesForCodes = new byte[3838][];
    private byte[] previousSequence;
    private int nextAvailableEntry;
    private int codeSize;
    private byte[] pending;
    private boolean done;

    public LZW(ChannelDataInput channelDataInput) {
        super(channelDataInput);
    }

    @Override
    public void setInput(long l, long l2) throws IOException {
        super.setInput(l, l2);
        this.previousSequence = ArraysExt.EMPTY_BYTE;
        this.codeSize = 9;
        this.nextAvailableEntry = 0;
        this.pending = null;
        this.done = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        if (this.pending != null) {
            int n3 = byteBuffer.remaining();
            if (this.pending.length > n3) {
                byteBuffer.put(this.pending, 0, n3);
                this.pending = Arrays.copyOfRange(this.pending, n3, this.pending.length);
                return n3;
            }
            byteBuffer.put(this.pending);
            this.pending = null;
            if (this.done) {
                return n3;
            }
        } else {
            this.done |= this.finished();
        }
        if (this.done) {
            return -1;
        }
        byte[] byArray = this.previousSequence;
        this.previousSequence = null;
        int n4 = (1 << this.codeSize) - 259;
        while ((n = (int)this.input.readBits(this.codeSize)) != 257) {
            if (n == 256) {
                Arrays.fill((Object[])this.sequencesForCodes, null);
                this.nextAvailableEntry = 0;
                byArray = ArraysExt.EMPTY_BYTE;
                this.codeSize = 9;
                n4 = 253;
                while ((n = (int)this.input.readBits(9)) == 256) {
                }
                if (n == 257) break;
                if ((n & 0xFFFFFF00) != 0) {
                    throw this.unexpectedData();
                }
                byArray = new byte[]{(byte)n};
                if (byteBuffer.hasRemaining()) {
                    byteBuffer.put((byte)n);
                    continue;
                }
                this.pending = byArray;
                break;
            }
            int n5 = byArray.length;
            byte[] byArray2 = Arrays.copyOf(byArray, n5 + 1);
            if ((n & 0xFFFFFF00) == 0) {
                byArray2[n5] = (byte)n;
                byArray = new byte[]{(byte)n};
            } else {
                byte[] byArray3 = this.sequencesForCodes[n - 258];
                if (byArray3 != null) {
                    byArray2[n5] = byArray3[0];
                    byArray = byArray3;
                } else {
                    if (n5 == 0) {
                        throw this.unexpectedData();
                    }
                    byArray2[n5] = byArray[0];
                    byArray = byArray2;
                }
            }
            this.sequencesForCodes[this.nextAvailableEntry] = byArray2;
            if (++this.nextAvailableEntry == n4) {
                n4 = (1 << ++this.codeSize) - 259;
                if (this.codeSize > 12) {
                    throw new IOException();
                }
            }
            if (byArray.length <= byteBuffer.remaining()) {
                byteBuffer.put(byArray);
                continue;
            }
            this.pending = byArray;
            break;
        }
        this.previousSequence = byArray;
        this.done = n == 257 && this.pending != null;
        return byteBuffer.position() - n2;
    }

    private IOException unexpectedData() {
        return new IOException(this.resources().getString((short)31, this.input.filename, "LZW"));
    }
}

