/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import org.apache.sis.gui.Widget;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.gui.control.ColorColumnHandler;
import org.apache.sis.internal.gui.control.ColorRamp;
import org.apache.sis.internal.gui.control.FormatApplicator;
import org.apache.sis.internal.gui.control.FormatTableCell;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.resources.Vocabulary;

public final class ValueColorMapper
extends Widget {
    private final FormatApplicator<Number> textConverter = FormatApplicator.createNumberFormat();
    private final TableView<Step> table;
    private Dialog<Range> rangeEditor;

    public ValueColorMapper(Resources resources, Vocabulary vocabulary) {
        this.table = this.createIsolineTable(vocabulary);
        MenuItem menuItem = new MenuItem(resources.getString((short)56));
        MenuItem menuItem2 = new MenuItem(resources.getString((short)55));
        menuItem.setOnAction(actionEvent -> this.insertRangeOfValues());
        menuItem2.setOnAction(actionEvent -> {
            ObservableList<Step> observableList = this.getSteps();
            observableList.remove(0, observableList.size() - 1);
        });
        this.table.setContextMenu(new ContextMenu(new MenuItem[]{menuItem, menuItem2}));
    }

    @Override
    public Region getView() {
        return this.table;
    }

    public ObservableList<Step> getSteps() {
        return this.table.getItems();
    }

    private static void commitEdit(TableColumn.CellEditEvent<Step, Number> cellEditEvent) {
        int n;
        Step step = (Step)cellEditEvent.getRowValue();
        Number number = (Number)cellEditEvent.getNewValue();
        double d = number != null ? number.doubleValue() : Double.NaN;
        step.value.set(d);
        step.visible.set(true);
        TableView tableView = cellEditEvent.getTableView();
        ObservableList observableList = tableView.getItems();
        int n2 = n = cellEditEvent.getTablePosition().getRow();
        while (--n2 >= 0 && ((Step)observableList.get((int)n2)).value.get() >= d) {
        }
        int n3 = observableList.size() - 1;
        while (!(++n2 >= n3 || n2 != n && ((Step)observableList.get((int)n2)).value.get() > d)) {
        }
        if (n2 != n) {
            if (n2 >= n) {
                --n2;
            }
            observableList.add(n2, (Object)((Step)observableList.remove(n)));
            tableView.getSelectionModel().select(n2);
        }
        if (n >= n3) {
            observableList.add((Object)new Step());
        }
        if (step.color.get() == null) {
            Color color = Color.BLACK;
            int n4 = observableList.size() - 2;
            if (n4 >= 2) {
                int n5 = n2 - 1;
                int n6 = n2 + 1;
                if (n5 < 0) {
                    n5 = 1;
                    n6 = 2;
                } else if (n6 > n4) {
                    n6 = n4 - 1;
                    n5 = n4 - 2;
                }
                Step step2 = (Step)observableList.get(n5);
                Step step3 = (Step)observableList.get(n6);
                double d2 = step2.value.get();
                double d3 = (d - d2) / (step3.value.get() - d2);
                Color color2 = ((ColorRamp)step2.color.get()).color();
                Color color3 = ((ColorRamp)step3.color.get()).color();
                color = new Color(ValueColorMapper.interpolate(d3, color2.getRed(), color3.getRed()), ValueColorMapper.interpolate(d3, color2.getGreen(), color3.getGreen()), ValueColorMapper.interpolate(d3, color2.getBlue(), color3.getBlue()), ValueColorMapper.interpolate(d3, color2.getOpacity(), color3.getOpacity()));
            }
            step.color.set((Object)new ColorRamp(color));
        }
    }

    private static double interpolate(double d, double d2, double d3) {
        return Math.max(0.0, Math.min(1.0, (d3 - d2) * d + d2));
    }

    private TableView<Step> createIsolineTable(Vocabulary vocabulary) {
        TableColumn tableColumn2 = new TableColumn("\ud83d\udd89");
        tableColumn2.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)tableColumn2));
        tableColumn2.setCellValueFactory(cellDataFeatures -> ((Step)cellDataFeatures.getValue()).visible);
        tableColumn2.setSortable(false);
        tableColumn2.setResizable(false);
        tableColumn2.setMinWidth(40.0);
        tableColumn2.setMaxWidth(40.0);
        TableColumn tableColumn3 = new TableColumn(vocabulary.getString((short)114));
        FormatTableCell.Trigger trigger = new FormatTableCell.Trigger(tableColumn3, this.textConverter.format);
        tableColumn3.setCellFactory(tableColumn -> new FormatTableCell(this.textConverter, trigger));
        tableColumn3.setCellValueFactory(cellDataFeatures -> ((Step)cellDataFeatures.getValue()).value);
        tableColumn3.setOnEditCommit(ValueColorMapper::commitEdit);
        tableColumn3.setSortable(false);
        tableColumn3.setId("level");
        TableView tableView = new TableView();
        tableView.getColumns().setAll((Object[])new TableColumn[]{tableColumn2, tableColumn3});
        ColumnHandler columnHandler = new ColumnHandler();
        columnHandler.addColumnTo(tableView, vocabulary.getString((short)251));
        tableView.getItems().add((Object)new Step());
        trigger.registerTo(tableView);
        tableView.setOnKeyPressed(ValueColorMapper::deleteRow);
        return tableView;
    }

    private static void deleteRow(KeyEvent keyEvent) {
        TableView tableView = (TableView)keyEvent.getSource();
        if (keyEvent.getCode() == KeyCode.DELETE) {
            int n = tableView.getSelectionModel().getSelectedIndex();
            ObservableList observableList = tableView.getItems();
            if (n >= 0 && n < observableList.size() - 1) {
                observableList.remove(n);
            }
        }
    }

    private void insertRangeOfValues() {
        if (this.rangeEditor == null) {
            this.rangeEditor = Range.createDialog(this.textConverter, this.table);
        }
        this.rangeEditor.showAndWait().ifPresent(range -> {
            ObservableList<Step> observableList = this.getSteps();
            int n = 0;
            BigDecimal bigDecimal = range.minimum;
            block0: while (bigDecimal.compareTo(range.maximum) <= 0) {
                double d = bigDecimal.doubleValue();
                bigDecimal = bigDecimal.add(range.interval);
                while (n < observableList.size()) {
                    double d2 = ((Step)observableList.get((int)n)).value.get();
                    if (d2 == d) continue block0;
                    if (!(d2 <= d)) break;
                    ++n;
                }
                observableList.add(n, (Object)new Step(d, range.color));
            }
        });
    }

    public static final class Step
    implements Comparable<Step> {
        public final DoubleProperty value = new SimpleDoubleProperty((Object)this, "value", Double.NaN);
        public final ObjectProperty<ColorRamp> color = new SimpleObjectProperty((Object)this, "color");
        public final BooleanProperty visible = new SimpleBooleanProperty((Object)this, "visible");

        Step() {
        }

        Step(double d, Color color) {
            this();
            this.value.set(d);
            this.color.set((Object)new ColorRamp(color));
            this.visible.set(true);
        }

        @Override
        public int compareTo(Step step) {
            return Double.compare(this.value.get(), step.value.get());
        }

        public boolean equals(Object object) {
            if (object instanceof Step) {
                Step step = (Step)object;
                return Numerics.equals(this.value.get(), step.value.get()) && Objects.equals(this.color.get(), step.color.get()) && this.visible.get() == step.visible.get();
            }
            return false;
        }

        public int hashCode() {
            return Double.hashCode(this.value.get()) + Objects.hashCode(this.color.get()) + Boolean.hashCode(this.visible.get());
        }

        public String toString() {
            return Double.toString(this.value.get()) + " = " + Objects.toString(this.color.get());
        }
    }

    private static final class ColumnHandler
    extends ColorColumnHandler<Step> {
        ColumnHandler() {
        }

        @Override
        protected int[] getARGB(Step step) {
            ColorRamp colorRamp = (ColorRamp)step.color.get();
            return colorRamp != null ? colorRamp.colors : null;
        }

        @Override
        protected ObservableValue<ColorRamp> getObservableValue(Step step) {
            return step.color;
        }

        @Override
        protected ColorRamp.Type applyColors(Step step, ColorRamp colorRamp) {
            step.color.set((Object)colorRamp);
            return ColorRamp.Type.SOLID;
        }
    }

    private static final class Range {
        final BigDecimal minimum;
        final BigDecimal maximum;
        final BigDecimal interval;
        final Color color;

        private Range(TextField textField, TextField textField2, TextField textField3, ColorPicker colorPicker) {
            this.minimum = Range.decimal(textField);
            this.maximum = Range.decimal(textField2);
            this.interval = Range.decimal(textField3);
            this.color = (Color)colorPicker.getValue();
        }

        private static BigDecimal decimal(TextField textField) {
            Object object = textField.getUserData();
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            return BigDecimal.valueOf(((Number)object).doubleValue());
        }

        static Dialog<Range> createDialog(FormatApplicator<Number> formatApplicator, Node node) {
            Vocabulary vocabulary = Vocabulary.getResources((Locale)null);
            TextField textField = new TextField();
            TextField textField2 = new TextField();
            TextField textField3 = new TextField();
            ColorPicker colorPicker = new ColorPicker(Color.BLACK);
            colorPicker.setMaxWidth(Double.MAX_VALUE);
            GridPane gridPane = Styles.createControlGrid(0, Range.createRow((Node)textField, vocabulary, (short)133), Range.createRow((Node)textField2, vocabulary, (short)127), Range.createRow((Node)textField3, vocabulary, (short)253), Range.createRow((Node)colorPicker, vocabulary, (short)251));
            Dialog dialog = new Dialog();
            dialog.initOwner(node.getScene().getWindow());
            dialog.setTitle(vocabulary.getString((short)252));
            dialog.setHeaderText(Resources.format((short)57));
            DialogPane dialogPane = dialog.getDialogPane();
            dialogPane.setContent((Node)gridPane);
            dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
            Node node2 = dialogPane.lookupButton(ButtonType.APPLY);
            node2.setDisable(true);
            textField.requestFocus();
            formatApplicator.setListenersOn(textField);
            formatApplicator.setListenersOn(textField2);
            formatApplicator.setListenersOn(textField3);
            formatApplicator.listener = observable -> {
                boolean bl = Range.valueOf(textField2) >= Range.valueOf(textField) && Range.valueOf(textField3) > 0.0;
                node2.setDisable(!bl);
            };
            dialog.setResultConverter(buttonType -> {
                if (buttonType == ButtonType.APPLY) {
                    return new Range(textField, textField2, textField3, colorPicker);
                }
                return null;
            });
            return dialog;
        }

        private static Label createRow(Node node, Vocabulary vocabulary, short s) {
            Label label = new Label(vocabulary.getLabel(s));
            label.setLabelFor(node);
            return label;
        }

        private static double valueOf(TextField textField) {
            Number number = (Number)textField.getUserData();
            return number != null ? number.doubleValue() : Double.NaN;
        }
    }
}

