/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import org.apache.sis.internal.gui.ImmutableObjectProperty;
import org.apache.sis.internal.gui.control.ColorCell;
import org.apache.sis.internal.gui.control.ColorRamp;

public abstract class ColorColumnHandler<S>
implements Callback<TableColumn.CellDataFeatures<S, ColorRamp>, ObservableValue<ColorRamp>> {
    protected ColorColumnHandler() {
    }

    protected abstract ColorRamp.Type applyColors(S var1, ColorRamp var2);

    protected abstract int[] getARGB(S var1);

    protected ObservableValue<ColorRamp> getObservableValue(S s) {
        int[] nArray = this.getARGB(s);
        if (nArray != null) {
            return new ImmutableObjectProperty<ColorRamp>(new ColorRamp(nArray));
        }
        return null;
    }

    public final ObservableValue<ColorRamp> call(TableColumn.CellDataFeatures<S, ColorRamp> cellDataFeatures) {
        Object object = cellDataFeatures.getValue();
        return object != null ? this.getObservableValue(object) : null;
    }

    protected final void addColumnTo(TableView<S> tableView, String string) {
        TableColumn tableColumn2 = new TableColumn(string);
        tableColumn2.setCellFactory(tableColumn -> new ColorCell(this));
        tableColumn2.setCellValueFactory((Callback)this);
        tableColumn2.setSortable(false);
        tableColumn2.setId("colors");
        tableView.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            TableColumn tableColumn2;
            TablePosition tablePosition;
            if (keyEvent.getCode() == KeyCode.ENTER && (tablePosition = tableView.getFocusModel().getFocusedCell()) != null && ((tableColumn2 = tablePosition.getTableColumn()) == null || tableColumn2 == tableColumn2)) {
                keyEvent.consume();
                TablePosition tablePosition2 = tableView.getEditingCell();
                int n = (tablePosition2 != null ? tablePosition2 : tablePosition).getRow();
                if (n >= 0) {
                    tableView.edit(n, tableColumn2);
                }
            }
        });
        tableView.getColumns().add((Object)tableColumn2);
        tableView.setEditable(true);
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
    }
}

