/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.control.ColorColumnHandler;
import org.apache.sis.internal.gui.control.ColorRamp;

final class ColorCell<S>
extends TableCell<S, ColorRamp>
implements EventHandler<ActionEvent> {
    private static final double WIDTH_ADJUST = -9.0;
    private static final double HEIGHT = 16.0;
    private final ColorColumnHandler<S> handler;
    private ColorRamp.Type type;
    private ColorPicker colorPicker;
    private ComboBox<ColorRamp> colorRampChooser;
    private Rectangle colorView;

    ColorCell(ColorColumnHandler<S> colorColumnHandler) {
        this.handler = colorColumnHandler;
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.setOnMouseClicked(ColorCell::mouseClicked);
    }

    private static void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY && ((ColorCell)((Object)mouseEvent.getSource())).requestEdit()) {
            mouseEvent.consume();
        }
    }

    private boolean controlNotFocused() {
        return !(this.colorPicker != null && this.colorPicker.isFocused() || this.colorRampChooser != null && this.colorRampChooser.isFocused());
    }

    private ComboBoxBase<?> showControlButton() {
        ComboBox<ColorRamp> comboBox;
        Node node = this.getGraphic();
        if (node instanceof ComboBoxBase) {
            return (ComboBoxBase)node;
        }
        assert (this.controlNotFocused());
        if (this.type == null) {
            comboBox = null;
        } else {
            boolean bl;
            switch (this.type) {
                default: {
                    throw new AssertionError((Object)this.type);
                }
                case SOLID: {
                    bl = this.colorPicker == null;
                    if (bl) {
                        this.colorPicker = new ColorPicker();
                        this.colorPicker.setMaxWidth(Double.MAX_VALUE);
                        this.updateColorPicker((ColorRamp)this.getItem());
                    }
                    comboBox = this.colorPicker;
                    break;
                }
                case GRADIENT: {
                    bl = this.colorRampChooser == null;
                    if (bl) {
                        this.colorRampChooser = new ComboBox();
                        this.colorRampChooser.setEditable(false);
                        this.colorRampChooser.setMaxWidth(Double.MAX_VALUE);
                        this.colorRampChooser.setCellFactory(listView -> new RampChoice());
                        this.colorRampChooser.getItems().setAll((Object[])new ColorRamp[]{ColorRamp.GRAYSCALE, ColorRamp.BELL});
                        this.updateColorRampChooser((ColorRamp)this.getItem());
                    }
                    comboBox = this.colorRampChooser;
                }
            }
            if (bl) {
                comboBox.setOnAction((EventHandler)this);
            }
        }
        this.setGraphic((Node)comboBox);
        return comboBox;
    }

    private Rectangle createRectangle(double d) {
        Rectangle rectangle = new Rectangle();
        rectangle.setHeight(16.0);
        rectangle.widthProperty().bind((ObservableValue)this.widthProperty().add(d));
        return rectangle;
    }

    private void updateColorPicker(ColorRamp colorRamp) {
        this.colorPicker.setValue((Object)(colorRamp != null ? colorRamp.color() : null));
    }

    private void updateColorRampChooser(ColorRamp colorRamp) {
        if (colorRamp != null) {
            ObservableList observableList = this.colorRampChooser.getItems();
            int n = observableList.indexOf((Object)colorRamp);
            if (n < 0) {
                n = observableList.size();
                observableList.add((Object)colorRamp);
            }
            this.colorRampChooser.getSelectionModel().select(n);
        } else {
            this.colorRampChooser.getSelectionModel().clearSelection();
        }
    }

    protected final void updateItem(ColorRamp colorRamp, boolean bl) {
        Object object;
        TableRow tableRow;
        super.updateItem((Object)colorRamp, bl);
        this.type = null;
        if (!bl && (tableRow = this.getTableRow()) != null && (object = tableRow.getItem()) != null) {
            this.type = this.handler.applyColors(object, colorRamp);
        }
        if (this.type != null) {
            switch (this.type) {
                default: {
                    throw new AssertionError((Object)this.type);
                }
                case SOLID: {
                    if (this.colorPicker == null) break;
                    this.updateColorPicker(colorRamp);
                    break;
                }
                case GRADIENT: {
                    if (this.colorRampChooser == null) break;
                    this.updateColorRampChooser(colorRamp);
                }
            }
        }
        if (!(this.getGraphic() instanceof Control)) {
            this.setColorItem(colorRamp);
        }
    }

    private void setColorItem(ColorRamp colorRamp) {
        Paint paint;
        assert (this.controlNotFocused());
        Rectangle rectangle = null;
        if (colorRamp != null && (paint = colorRamp.paint()) != null) {
            if (this.colorView == null) {
                this.colorView = this.createRectangle(-9.0);
            }
            rectangle = this.colorView;
            rectangle.setFill(paint);
        }
        this.setGraphic((Node)rectangle);
    }

    private void hideControlButton() {
        Node node = this.getGraphic();
        if (node instanceof Control) {
            if (node.isFocused()) {
                this.getTableView().requestFocus();
            }
            this.setColorItem((ColorRamp)this.getItem());
        }
    }

    private boolean requestEdit() {
        if (this.isEditing()) {
            ColorCell.popup(this.showControlButton());
            return false;
        }
        int n = this.getTableRow().getIndex();
        TableView tableView = this.getTableView();
        tableView.getSelectionModel().select(n);
        tableView.edit(n, this.getTableColumn());
        return true;
    }

    public final void startEdit() {
        ComboBoxBase<?> comboBoxBase = this.showControlButton();
        super.startEdit();
        ColorCell.popup(comboBoxBase);
    }

    private static void popup(ComboBoxBase<?> comboBoxBase) {
        if (comboBoxBase != null) {
            comboBoxBase.requestFocus();
            comboBoxBase.show();
        }
    }

    public final void cancelEdit() {
        super.cancelEdit();
        this.hideControlButton();
    }

    public final void handle(ActionEvent actionEvent) {
        if (this.isEditing()) {
            Object object = ((ComboBoxBase)actionEvent.getSource()).getValue();
            ColorRamp colorRamp = object instanceof Color ? new ColorRamp(GUIUtilities.toARGB((Color)object)) : (ColorRamp)object;
            this.commitEdit(colorRamp);
        }
        this.hideControlButton();
    }

    private final class RampChoice
    extends ListCell<ColorRamp> {
        RampChoice() {
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.setMaxWidth(Double.POSITIVE_INFINITY);
        }

        protected void updateItem(ColorRamp colorRamp, boolean bl) {
            super.updateItem((Object)colorRamp, bl);
            if (colorRamp == null) {
                this.setGraphic(null);
            } else {
                Rectangle rectangle = (Rectangle)this.getGraphic();
                if (rectangle == null) {
                    rectangle = ColorCell.this.createRectangle(-40.0);
                    this.setGraphic((Node)rectangle);
                }
                rectangle.setFill(colorRamp.paint());
            }
        }
    }
}

