/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.paint.Color;
import org.apache.sis.internal.gui.GUIUtilities;

public final class ColorName {
    private static final Map<Color, String> NAMES = new HashMap<Color, String>(175);

    private ColorName() {
    }

    public static String of(Color color) {
        String string = NAMES.get(color);
        if (string == null) {
            string = Integer.toHexString(GUIUtilities.toARGB(color));
        }
        return string;
    }

    public static String of(int n) {
        String string = NAMES.get(GUIUtilities.fromARGB(n));
        if (string == null) {
            string = Integer.toHexString(n);
        }
        return string;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        for (Field field : Color.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Color.class.equals(field.getType())) continue;
            try {
                String string = field.getName();
                stringBuilder.append(string.toLowerCase());
                stringBuilder.setCharAt(0, string.charAt(0));
                NAMES.put((Color)field.get(null), stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

