/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Task;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Menu;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.gui.referencing.CRSChooser;
import org.apache.sis.gui.referencing.MenuSync;
import org.apache.sis.gui.referencing.ObjectStringConverter;
import org.apache.sis.gui.referencing.Utils;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.NonNullObjectProperty;
import org.apache.sis.internal.gui.RecentChoices;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.util.FactoryException;

public class RecentReferenceSystems {
    private static final int NUM_CORE_ITEMS = 1;
    private static final int NUM_SHOWN_ITEMS = 9;
    private static final int NUM_OTHER_ITEMS = 1;
    private static final String SELECTED_ITEM_KEY = "SelectedItem";
    static final ReferenceSystem OTHER = null;
    private volatile CRSAuthorityFactory factory;
    public final ObjectProperty<Envelope> areaOfInterest;
    private ImmutableEnvelope geographicAOI;
    public final ObjectProperty<ComparisonMode> duplicationCriterion;
    private final List<WritableValue<ReferenceSystem>> controlValues;
    final Locale locale;
    private final List<Object> systemsOrCodes;
    private ObservableList<ReferenceSystem> referenceSystems;
    private ObservableList<ReferenceSystem> filteredSystems;
    private boolean isModified;
    private boolean isAdjusting;

    public RecentReferenceSystems() {
        this(null, null);
    }

    public RecentReferenceSystems(CRSAuthorityFactory cRSAuthorityFactory, Locale locale) {
        this.factory = cRSAuthorityFactory;
        this.locale = locale;
        this.systemsOrCodes = new ArrayList<Object>();
        this.areaOfInterest = new SimpleObjectProperty((Object)this, "areaOfInterest");
        this.duplicationCriterion = new NonNullObjectProperty<ComparisonMode>(this, "duplicationCriterion", ComparisonMode.ALLOW_VARIANT);
        this.controlValues = new ArrayList<WritableValue<ReferenceSystem>>();
        this.duplicationCriterion.addListener(observable -> this.listModified());
        this.areaOfInterest.addListener((observableValue, envelope, envelope2) -> {
            this.geographicAOI = Utils.toGeographic(RecentReferenceSystems.class, "areaOfInterest", envelope2);
            this.listModified();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferred(boolean bl, ReferenceSystem referenceSystem) {
        ArgumentChecks.ensureNonNull("system", referenceSystem);
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            this.systemsOrCodes.add(0, bl ? new Unverified(referenceSystem) : referenceSystem);
            this.listModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferred(String string) {
        ArgumentChecks.ensureNonEmpty("code", string);
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            this.systemsOrCodes.add(0, string);
            this.listModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addSelected(ReferenceSystem referenceSystem) {
        if (RecentReferenceSystems.isAccepted((IdentifiedObject)referenceSystem)) {
            List<Object> list = this.systemsOrCodes;
            synchronized (list) {
                this.systemsOrCodes.add(Math.min(this.systemsOrCodes.size(), 1), referenceSystem);
                this.listModified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlternatives(boolean bl, ReferenceSystem ... referenceSystemArray) {
        ArgumentChecks.ensureNonNull("systems", referenceSystemArray);
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            for (ReferenceSystem referenceSystem : referenceSystemArray) {
                if (referenceSystem == null) continue;
                this.systemsOrCodes.add(bl ? new Unverified(referenceSystem) : referenceSystem);
            }
            this.listModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlternatives(String ... stringArray) {
        ArgumentChecks.ensureNonNull("codes", stringArray);
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            for (String string : stringArray) {
                if ((string = Strings.trimOrNull(string)) == null) continue;
                this.systemsOrCodes.add(string);
            }
            this.listModified();
        }
    }

    public void addUserPreferences() {
        this.addAlternatives(RecentChoices.getReferenceSystems());
    }

    private static boolean isAccepted(IdentifiedObject identifiedObject) {
        return IdentifiedObjects.getIdentifier((IdentifiedObject)identifiedObject, null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReferenceSystem> filterReferenceSystems(ImmutableEnvelope immutableEnvelope, ComparisonMode comparisonMode) {
        ArrayList<ReferenceSystem> arrayList;
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            int n;
            Object object;
            Object object2;
            CRSAuthorityFactory cRSAuthorityFactory = this.factory;
            if (!this.isModified) {
                return null;
            }
            boolean bl = false;
            boolean bl2 = false;
            IdentifiedObjectFinder identifiedObjectFinder = null;
            int n2 = this.systemsOrCodes.size();
            while (--n2 >= 0) {
                try {
                    Object object3 = this.systemsOrCodes.get(n2);
                    if (object3 == OTHER) {
                        this.systemsOrCodes.remove(n2);
                        continue;
                    }
                    if (object3 instanceof String) {
                        if (!bl) {
                            if (cRSAuthorityFactory == null) {
                                cRSAuthorityFactory = Utils.getDefaultFactory();
                            }
                            this.systemsOrCodes.set(n2, cRSAuthorityFactory.createCoordinateReferenceSystem((String)object3));
                            continue;
                        }
                        this.systemsOrCodes.remove(n2);
                        continue;
                    }
                    if (!(object3 instanceof Unverified)) continue;
                    if (!bl2) {
                        bl2 = true;
                        identifiedObjectFinder = cRSAuthorityFactory instanceof GeodeticAuthorityFactory ? ((GeodeticAuthorityFactory)cRSAuthorityFactory).newIdentifiedObjectFinder() : IdentifiedObjects.newFinder(null);
                        identifiedObjectFinder.setIgnoringAxes(true);
                    }
                    object2 = ((Unverified)object3).system;
                    if (identifiedObjectFinder != null && (object = identifiedObjectFinder.findSingleton((IdentifiedObject)object2)) instanceof ReferenceSystem) {
                        object2 = (ReferenceSystem)object;
                    }
                    this.systemsOrCodes.set(n2, object2);
                }
                catch (FactoryException factoryException) {
                    this.errorOccurred(factoryException);
                    this.systemsOrCodes.remove(n2);
                    bl = cRSAuthorityFactory == null;
                }
            }
            for (n2 = 0; n2 < (n = this.systemsOrCodes.size()); ++n2) {
                if (n2 >= 20) {
                    this.systemsOrCodes.subList(n2, n).clear();
                    break;
                }
                object2 = this.systemsOrCodes.get(n2);
                while (--n > n2) {
                    if (!Utilities.deepEquals(object2, this.systemsOrCodes.get(n), comparisonMode) || !RecentReferenceSystems.isAccepted(object = this.systemsOrCodes.remove(n)) || RecentReferenceSystems.isAccepted((IdentifiedObject)object2)) continue;
                    object2 = object;
                    this.systemsOrCodes.set(n2, object2);
                }
            }
            n2 = this.systemsOrCodes.size();
            arrayList = new ArrayList<ReferenceSystem>(Math.min(9, n2) + 1);
            for (n = 0; n < n2; ++n) {
                object2 = (ReferenceSystem)this.systemsOrCodes.get(n);
                if (n >= 1 && !Utils.intersects(immutableEnvelope, object2.getDomainOfValidity()) || Utils.isIgnoreable((ReferenceSystem)object2)) continue;
                arrayList.add((ReferenceSystem)object2);
                if (arrayList.size() >= 9) break;
            }
            arrayList.add(OTHER);
            this.isModified = false;
            this.factory = cRSAuthorityFactory;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listModified() {
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            this.isModified = true;
            if (this.referenceSystems != null) {
                this.updateItems();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObservableList<ReferenceSystem> updateItems() {
        if (this.referenceSystems == null) {
            this.referenceSystems = FXCollections.observableArrayList();
        }
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            this.isModified = true;
            int n = Math.min(this.systemsOrCodes.size(), 1);
            List<ReferenceSystem> list2 = this.getSelectedItems();
            this.systemsOrCodes.addAll(n, list2);
            this.systemsOrCodes.addAll(n + list2.size(), (Collection<Object>)this.referenceSystems);
            final ImmutableEnvelope immutableEnvelope = this.geographicAOI;
            final ComparisonMode comparisonMode = (ComparisonMode)((Object)this.duplicationCriterion.get());
            BackgroundThreads.execute((Runnable)new Task<List<ReferenceSystem>>(){

                protected List<ReferenceSystem> call() {
                    return RecentReferenceSystems.this.filterReferenceSystems(immutableEnvelope, comparisonMode);
                }

                protected void failed() {
                    ExceptionReporter.show(null, this);
                }

                protected void succeeded() {
                    RecentReferenceSystems.this.setReferenceSystems((List)this.getValue(), comparisonMode);
                }
            });
        }
        return this.referenceSystems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReferenceSystems(List<ReferenceSystem> list, ComparisonMode comparisonMode) {
        if (list != null && !this.isAdjusting) {
            try {
                this.isAdjusting = true;
                ReferenceSystem[] referenceSystemArray = (ReferenceSystem[])this.controlValues.stream().map(WritableValue::getValue).toArray(ReferenceSystem[]::new);
                if (GUIUtilities.copyAsDiff(list, this.referenceSystems)) {
                    this.notifyChanges();
                }
                int n = this.referenceSystems.size();
                for (int i = 0; i < referenceSystemArray.length; ++i) {
                    ReferenceSystem referenceSystem = referenceSystemArray[i];
                    if (referenceSystem == null) continue;
                    for (int j = 0; j < n; ++j) {
                        ReferenceSystem referenceSystem2 = (ReferenceSystem)this.referenceSystems.get(j);
                        if (!Utilities.deepEquals(referenceSystem2, referenceSystem, comparisonMode)) continue;
                        referenceSystem = referenceSystem2;
                        break;
                    }
                    this.controlValues.get(i).setValue((Object)referenceSystem);
                }
            }
            finally {
                this.isAdjusting = false;
            }
        }
    }

    private void notifyChanges() {
        for (WritableValue<ReferenceSystem> writableValue : this.controlValues) {
            if (!(writableValue instanceof MenuSync)) continue;
            ((MenuSync)writableValue).notifyChanges(this.referenceSystems);
        }
    }

    public ObservableList<ReferenceSystem> getItems() {
        if (this.filteredSystems == null) {
            this.filteredSystems = new FilteredList(this.updateItems(), Objects::nonNull);
        }
        return this.filteredSystems;
    }

    /*
     * WARNING - void declaration
     */
    public List<ReferenceSystem> getSelectedItems() {
        ReferenceSystem referenceSystem2;
        int n = 0;
        ReferenceSystem[] referenceSystemArray = new ReferenceSystem[this.controlValues.size()];
        for (WritableValue<ReferenceSystem> writableValue : this.controlValues) {
            referenceSystem2 = (ReferenceSystem)writableValue.getValue();
            if (referenceSystem2 == null) continue;
            referenceSystemArray[n++] = referenceSystem2;
        }
        ArrayList arrayList = new ArrayList(n);
        if (n != 0) {
            void var4_7;
            int n2;
            block1: for (ReferenceSystem referenceSystem2 : this.referenceSystems) {
                if (referenceSystem2 == OTHER) continue;
                for (n2 = 0; n2 < n; ++n2) {
                    if (referenceSystemArray[n2] != referenceSystem2) continue;
                    arrayList.add(referenceSystem2);
                    if (--n == 0) {
                        return arrayList;
                    }
                    System.arraycopy(referenceSystemArray, n2 + 1, referenceSystemArray, n2, n - n2);
                    continue block1;
                }
            }
            boolean bl = false;
            while (var4_7 < n) {
                block7: {
                    referenceSystem2 = referenceSystemArray[var4_7];
                    n2 = arrayList.size();
                    while (--n2 >= 0) {
                        if (arrayList.get(n2) != referenceSystem2) continue;
                        break block7;
                    }
                    arrayList.add(referenceSystem2);
                }
                ++var4_7;
            }
        }
        return arrayList;
    }

    public ChoiceBox<ReferenceSystem> createChoiceBox(ChangeListener<ReferenceSystem> changeListener) {
        ArgumentChecks.ensureNonNull("action", changeListener);
        ChoiceBox choiceBox = new ChoiceBox(this.updateItems());
        choiceBox.setConverter(new ObjectStringConverter(choiceBox.getItems(), this.locale));
        choiceBox.valueProperty().addListener((ChangeListener)new Listener(changeListener));
        this.controlValues.add((WritableValue<ReferenceSystem>)choiceBox.valueProperty());
        return choiceBox;
    }

    public Menu createMenuItems(ChangeListener<ReferenceSystem> changeListener) {
        ArgumentChecks.ensureNonNull("action", changeListener);
        Menu menu = new Menu(Vocabulary.getResources(this.locale).getString((short)168));
        MenuSync menuSync = new MenuSync(this.updateItems(), menu, new Listener(changeListener));
        menu.getProperties().put((Object)SELECTED_ITEM_KEY, (Object)menuSync);
        this.controlValues.add((WritableValue<ReferenceSystem>)menuSync);
        return menu;
    }

    public static ObjectProperty<ReferenceSystem> getSelectedProperty(Menu menu) {
        Object object;
        if (menu != null && (object = menu.getProperties().get((Object)SELECTED_ITEM_KEY)) instanceof MenuSync) {
            return (MenuSync)((Object)object);
        }
        return null;
    }

    protected void errorOccurred(FactoryException factoryException) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.gui"), RecentReferenceSystems.class, "updateItems", factoryException);
    }

    private static final class Unverified {
        final ReferenceSystem system;

        Unverified(ReferenceSystem referenceSystem) {
            this.system = referenceSystem;
        }
    }

    final class Listener
    implements ChangeListener<ReferenceSystem> {
        private final ChangeListener<ReferenceSystem> action;

        private Listener(ChangeListener<ReferenceSystem> changeListener) {
            this.action = changeListener;
        }

        final RecentReferenceSystems owner() {
            return RecentReferenceSystems.this;
        }

        public void changed(ObservableValue<? extends ReferenceSystem> observableValue, ReferenceSystem referenceSystem, ReferenceSystem referenceSystem2) {
            int n;
            Object object;
            if (RecentReferenceSystems.this.isAdjusting) {
                this.action.changed(observableValue, (Object)referenceSystem, (Object)referenceSystem2);
                return;
            }
            ComparisonMode comparisonMode = (ComparisonMode)((Object)RecentReferenceSystems.this.duplicationCriterion.get());
            if (referenceSystem2 == OTHER) {
                object = new CRSChooser(RecentReferenceSystems.this.factory, (Envelope)RecentReferenceSystems.this.geographicAOI, RecentReferenceSystems.this.locale);
                referenceSystem2 = object.showDialog(GUIUtilities.getWindow(observableValue)).orElse(null);
                if (referenceSystem2 == null) {
                    referenceSystem2 = referenceSystem;
                } else {
                    ObservableList<ReferenceSystem> observableList = RecentReferenceSystems.this.referenceSystems;
                    n = observableList.size() - 1;
                    boolean bl = false;
                    for (int i = 0; i < n; ++i) {
                        if (!Utilities.deepEquals(referenceSystem2, observableList.get(i), comparisonMode)) continue;
                        if (i >= 1) {
                            observableList.set(i, (Object)referenceSystem2);
                        }
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        if (n >= 9) {
                            List<ReferenceSystem> list = RecentReferenceSystems.this.getSelectedItems();
                            int n2 = n;
                            while (--n2 >= 1) {
                                if (list.contains(observableList.get(n2))) continue;
                                observableList.remove(n2);
                                if (--n >= 9) continue;
                            }
                        }
                        observableList.add(Math.min(observableList.size(), 1), (Object)referenceSystem2);
                        RecentReferenceSystems.this.notifyChanges();
                    }
                }
                ((WritableValue)observableValue).setValue((Object)referenceSystem2);
            }
            if (referenceSystem != referenceSystem2) {
                object = RecentReferenceSystems.this.referenceSystems;
                int n3 = object.size() - 1;
                n = Math.min(n3, 2);
                while (--n >= 0) {
                    ReferenceSystem referenceSystem3 = (ReferenceSystem)object.get(n);
                    if (!Utilities.deepEquals(referenceSystem3, referenceSystem2, comparisonMode)) continue;
                    this.action.changed(observableValue, (Object)referenceSystem, (Object)referenceSystem3);
                    return;
                }
                n = n3;
                while (--n >= 1) {
                    if (!Utilities.deepEquals(object.get(n), referenceSystem2, comparisonMode)) continue;
                    referenceSystem2 = (ReferenceSystem)object.remove(n);
                    break;
                }
                object.add(Math.min(object.size(), 1), (Object)referenceSystem2);
                RecentReferenceSystems.this.notifyChanges();
                if (referenceSystem != referenceSystem2) {
                    this.action.changed(observableValue, (Object)referenceSystem, (Object)referenceSystem2);
                }
                RecentChoices.useReferenceSystem(IdentifiedObjects.toString((Identifier)IdentifiedObjects.getIdentifier((IdentifiedObject)referenceSystem2, null)));
            }
        }
    }
}

