/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.ArrayList;
import java.util.List;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.referencing.GeodeticObjectBuilder;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;

public abstract class PositionableProjection
extends CodeList<PositionableProjection> {
    private static final List<PositionableProjection> VALUES = new ArrayList<PositionableProjection>(1);
    public static final PositionableProjection ORTHOGRAPHIC = new PositionableProjection("ORTHOGRAPHIC", 52){

        @Override
        protected ProjectedCRS createProjectedCRS(GeographicCRS geographicCRS, double d, double d2) throws FactoryException {
            return this.newBuilder(d, d2).setConversionMethod("Orthographic").setParameter("Latitude of natural origin", d, Units.DEGREE).setParameter("Longitude of natural origin", d2, Units.DEGREE).createProjectedCRS(geographicCRS, null);
        }
    };
    public static final PositionableProjection AZIMUTHAL_EQUIDISTANT = new PositionableProjection("AZIMUTHAL_EQUIDISTANT", 42){

        @Override
        protected ProjectedCRS createProjectedCRS(GeographicCRS geographicCRS, double d, double d2) throws FactoryException {
            return this.newBuilder(d, d2).setConversionMethod("Azimuthal Equidistant (Spherical)").setParameter("Latitude of natural origin", d, Units.DEGREE).setParameter("Longitude of natural origin", d2, Units.DEGREE).createProjectedCRS(geographicCRS, null);
        }
    };
    public static final PositionableProjection UTM = new PositionableProjection("UTM", 45){

        @Override
        protected ProjectedCRS createProjectedCRS(GeographicCRS geographicCRS, double d, double d2) throws FactoryException {
            CommonCRS commonCRS;
            try {
                commonCRS = CommonCRS.forDatum((CoordinateReferenceSystem)geographicCRS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.gui"), PositionableProjection.class, "createProjectedCRS", illegalArgumentException);
                commonCRS = CommonCRS.WGS84;
            }
            return commonCRS.universal(d, d2);
        }
    };
    public static final PositionableProjection MERCATOR = new PositionableProjection("MERCATOR", 44){

        @Override
        protected ProjectedCRS createProjectedCRS(GeographicCRS geographicCRS, double d, double d2) throws FactoryException {
            return this.newBuilder(d, d2).setConversionMethod("Mercator (variant C)").setParameter("Latitude of false origin", d, Units.DEGREE).setParameter("Longitude of natural origin", d2, Units.DEGREE).createProjectedCRS(geographicCRS, null);
        }
    };
    private final short nameKey;

    protected PositionableProjection(String string) {
        super(string, VALUES);
        this.nameKey = 0;
    }

    private PositionableProjection(String string, short s) {
        super(string, VALUES);
        this.nameKey = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PositionableProjection[] values() {
        List<PositionableProjection> list = VALUES;
        synchronized (list) {
            return VALUES.toArray(new PositionableProjection[VALUES.size()]);
        }
    }

    public PositionableProjection[] family() {
        return PositionableProjection.values();
    }

    public String toString() {
        return this.nameKey != 0 ? Resources.format(this.nameKey) : this.name();
    }

    public ProjectedCRS createProjectedCRS(DirectPosition directPosition) throws FactoryException, TransformException {
        ArgumentChecks.ensureNonNull("center", directPosition);
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null) {
            throw new IllegalArgumentException(Errors.format((short)157));
        }
        GeographicCRS geographicCRS = ReferencingUtilities.toNormalizedGeographicCRS((CoordinateReferenceSystem)coordinateReferenceSystem, (boolean)true, (boolean)false);
        if (geographicCRS == null) {
            geographicCRS = CommonCRS.WGS84.geographic();
        }
        if (!Utilities.equalsIgnoreMetadata(geographicCRS, coordinateReferenceSystem)) {
            directPosition = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)geographicCRS, null).getMathTransform().transform(directPosition, null);
        }
        return this.createProjectedCRS(geographicCRS, Latitude.clamp(directPosition.getOrdinate(0)), Longitude.normalize(directPosition.getOrdinate(1)));
    }

    protected abstract ProjectedCRS createProjectedCRS(GeographicCRS var1, double var2, double var4) throws FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final GeodeticObjectBuilder newBuilder(double d, double d2) {
        StringBuffer stringBuffer;
        AngleFormat angleFormat = new AngleFormat("DD\u00b0MM\u2032SS\u2033");
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            stringBuffer.append((Object)this).append(" @ ");
            angleFormat.format(new Latitude(d), stringBuffer, null).append(' ');
            angleFormat.format(new Longitude(d2), stringBuffer, null);
            return (GeodeticObjectBuilder)new GeodeticObjectBuilder().addName((CharSequence)stringBuffer.toString());
        }
    }
}

