/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.Locale;
import javafx.util.StringConverter;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;

final class ObjectStringConverter<T extends IdentifiedObject>
extends StringConverter<T> {
    private final Iterable<? extends T> items;
    private final Locale locale;
    private String other;

    ObjectStringConverter(Iterable<? extends T> iterable, Locale locale) {
        this.items = iterable;
        this.locale = locale;
    }

    public String toString(T t) {
        if (t != RecentReferenceSystems.OTHER) {
            return IdentifiedObjects.getDisplayName(t, (Locale)this.locale);
        }
        if (this.other == null) {
            this.other = Vocabulary.getResources(this.locale).getString((short)157) + "\u2026";
        }
        return this.other;
    }

    public T fromString(String string) {
        if (string != null) {
            IdentifiedObject identifiedObject = null;
            for (IdentifiedObject identifiedObject2 : this.items) {
                String string2 = this.toString((T)identifiedObject2);
                if (string.equals(string2)) {
                    return (T)identifiedObject2;
                }
                if (identifiedObject != null || !string.equalsIgnoreCase(string2)) continue;
                identifiedObject = identifiedObject2;
            }
            if (identifiedObject != null) {
                return (T)identifiedObject;
            }
            for (IdentifiedObject identifiedObject2 : this.items) {
                if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)identifiedObject2, (String)string)) continue;
                return (T)identifiedObject2;
            }
        }
        return null;
    }
}

