/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.gui.metadata.MetadataTree;
import org.apache.sis.internal.gui.DataFormats;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.xml.LegacyNamespaces;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.xml.XML;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.IdentifiedObject;

public class StandardMetadataTree
extends MetadataTree {
    private final String copy;
    private final String copyAs;

    public StandardMetadataTree() {
        this(null);
    }

    public StandardMetadataTree(MetadataSummary metadataSummary) {
        super(metadataSummary, true);
        Resources resources = Resources.forLocale(this.getLocale());
        this.copy = resources.getString((short)11);
        this.copyAs = resources.getString((short)12);
        this.setRowFactory(Row::new);
        if (metadataSummary != null) {
            metadataSummary.metadataProperty.addListener((observableValue, metadata, metadata2) -> this.setContent((Metadata)metadata2));
        }
    }

    private static TreeTable toTree(Object object) {
        if (object instanceof AbstractMetadata) {
            return ((AbstractMetadata)object).asTreeTable();
        }
        return MetadataStandard.ISO_19115.asTreeTable(object, null, ValueExistencePolicy.COMPACT);
    }

    public void setContent(Metadata metadata) {
        this.setContent(metadata == null ? null : StandardMetadataTree.toTree(metadata));
    }

    private static final class Row
    extends TreeTableRow<TreeTable.Node>
    implements EventHandler<ActionEvent> {
        private final ContextMenu menu;
        private final MenuItem copyAsXML;
        private final MenuItem copyAsLegacy;
        private final MenuItem copyAsWKT;
        private final Menu copyAs;

        Row(TreeTableView<TreeTable.Node> treeTableView) {
            StandardMetadataTree standardMetadataTree = (StandardMetadataTree)treeTableView;
            MenuItem menuItem = new MenuItem(standardMetadataTree.copy);
            this.copyAsXML = new MenuItem();
            this.copyAsWKT = new MenuItem("WKT \u2014 Well Known Text");
            this.copyAsLegacy = new MenuItem("XML \u2014 Metadata (2007)");
            this.copyAs = new Menu(standardMetadataTree.copyAs, null, new MenuItem[]{this.copyAsWKT, this.copyAsXML, this.copyAsLegacy});
            this.menu = new ContextMenu(new MenuItem[]{menuItem, this.copyAs});
            this.copyAsLegacy.setOnAction((EventHandler)this);
            this.copyAsXML.setOnAction((EventHandler)this);
            menuItem.setOnAction((EventHandler)this);
        }

        protected void updateItem(TreeTable.Node node, boolean bl) {
            super.updateItem((Object)node, bl);
            if (!bl && this.copyAs != null) {
                Object object;
                boolean bl2 = true;
                TreeTable.Node node2 = (TreeTable.Node)this.getItem();
                if (node2 != null && (object = node2.getUserObject()) != null) {
                    if (MetadataStandard.ISO_19115.isMetadata(object.getClass())) {
                        this.copyAsXML.setText("XML \u2014 Metadata (2016)");
                        this.copyAsWKT.setDisable(true);
                        this.copyAsLegacy.setDisable(false);
                        bl2 = false;
                    } else if (object instanceof IdentifiedObject) {
                        this.copyAsXML.setText("XML \u2014 Geographic Markup Language");
                        this.copyAsWKT.setDisable(false);
                        this.copyAsLegacy.setDisable(true);
                        bl2 = false;
                    }
                }
                this.copyAs.setDisable(bl2);
            }
            this.setContextMenu(bl ? null : this.menu);
        }

        public void handle(ActionEvent actionEvent) {
            Object object;
            TreeTable.Node node = (TreeTable.Node)this.getItem();
            if (node != null && (object = node.getUserObject()) != null) {
                String string;
                Object object2 = actionEvent.getSource();
                ClipboardContent clipboardContent = new ClipboardContent();
                try {
                    if (object2 == this.copyAsWKT) {
                        WKTFormat wKTFormat = new WKTFormat(null, null);
                        string = wKTFormat.format(object);
                    } else if (object2 == this.copyAsXML) {
                        string = XML.marshal((Object)object);
                        clipboardContent.put((Object)DataFormats.XML, (Object)string);
                    } else if (object2 == this.copyAsLegacy) {
                        StringWriter stringWriter = new StringWriter();
                        XML.marshal((Object)object, (Result)new StreamResult(stringWriter), Collections.singletonMap("org.apache.sis.xml.version.metadata", LegacyNamespaces.VERSION_2007));
                        string = stringWriter.toString();
                        clipboardContent.put((Object)DataFormats.ISO_19139, (Object)string);
                    } else if (MetadataStandard.ISO_19115.isMetadata(object.getClass())) {
                        string = StandardMetadataTree.toTree(object).toString();
                    } else {
                        Object obj = node.getValue(((MetadataTree)this.getTreeTableView()).valueSourceColumn);
                        if (obj == null) {
                            return;
                        }
                        string = obj.toString();
                    }
                }
                catch (Exception exception) {
                    Resources resources = Resources.forLocale(((MetadataTree)this.getTreeTableView()).getLocale());
                    ExceptionReporter.show((Node)this, resources.getString((short)18), resources.getString((short)4), (Throwable)exception);
                    return;
                }
                clipboardContent.putString(string);
                Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
            }
        }
    }
}

