/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.text.FieldPosition;
import java.util.Locale;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.gui.metadata.Section;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.CodeList;

final class RepresentationInfo
extends Section<SpatialRepresentation> {
    private ReferenceSystem referenceSystem;

    RepresentationInfo(MetadataSummary metadataSummary) {
        super(metadataSummary);
        this.finished();
    }

    @Override
    void setInformation(Metadata metadata) {
        this.referenceSystem = null;
        if (metadata != null) {
            for (ReferenceSystem referenceSystem : CollectionsExt.nonNull(metadata.getReferenceSystemInfo())) {
                if (referenceSystem == null) continue;
                this.referenceSystem = referenceSystem;
                break;
            }
        }
        this.setInformation(CollectionsExt.nonNull(metadata == null ? null : metadata.getSpatialRepresentationInfo()), SpatialRepresentation[]::new);
    }

    @Override
    void buildContent(SpatialRepresentation spatialRepresentation) {
        if (spatialRepresentation instanceof GridSpatialRepresentation) {
            this.build((GridSpatialRepresentation)spatialRepresentation);
        }
        this.addLine((short)168, IdentifiedObjects.getDisplayName((IdentifiedObject)this.referenceSystem, (Locale)this.owner.vocabulary.getLocale()));
    }

    private void build(GridSpatialRepresentation gridSpatialRepresentation) {
        Integer n = gridSpatialRepresentation.getNumberOfDimensions();
        if (n != null) {
            this.addLine((short)144, this.owner.getNumberFormat().format(n));
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        StringBuffer stringBuffer2 = new StringBuffer(20);
        for (Dimension dimension : CollectionsExt.nonNull(gridSpatialRepresentation.getAxisDimensionProperties())) {
            Double d;
            String string = this.owner.string(Types.getCodeTitle((CodeList)dimension.getDimensionName()));
            Integer n2 = dimension.getDimensionSize();
            if (string != null || n2 != null) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(" \u00d7 ");
                }
                if (n2 != null) {
                    this.owner.getNumberFormat().format(n2, stringBuffer, new FieldPosition(0));
                }
                if (string != null) {
                    if (n2 != null) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(string);
                }
            }
            if ((d = dimension.getResolution()) == null) continue;
            if (stringBuffer2.length() != 0) {
                stringBuffer2.append(" \u00d7 ");
            }
            this.owner.getNumberFormat().format(d, stringBuffer2, new FieldPosition(0));
        }
        if (stringBuffer.length() != 0) {
            this.addLine((short)65, stringBuffer.toString());
        }
        if (stringBuffer2.length() != 0) {
            this.addLine((short)172, stringBuffer2.toString());
        }
        this.addLine((short)23, this.owner.string(Types.getCodeTitle((CodeList)gridSpatialRepresentation.getCellGeometry())));
    }
}

