/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.util.Callback;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.internal.util.PropertyFormat;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.InternationalString;

@DefaultProperty(value="content")
public class MetadataTree
extends TreeTableView<TreeTable.Node> {
    private final TreeTableColumn<TreeTable.Node, String> nameColumn;
    private final TreeTableColumn<TreeTable.Node, Object> valueColumn;
    TableColumn<?> valueSourceColumn;
    public final ObjectProperty<TreeTable> contentProperty;
    private final Formatter formatter;

    public MetadataTree() {
        this(null, false);
    }

    public MetadataTree(MetadataSummary metadataSummary) {
        this(metadataSummary, false);
    }

    MetadataTree(MetadataSummary metadataSummary, boolean bl) {
        Vocabulary vocabulary = metadataSummary != null ? metadataSummary.vocabulary : Vocabulary.getResources((Locale)null);
        this.formatter = new Formatter(vocabulary.getLocale());
        this.contentProperty = new ContentProperty(this);
        this.nameColumn = new TreeTableColumn(vocabulary.getString((short)238));
        this.valueColumn = new TreeTableColumn(vocabulary.getString((short)213));
        this.nameColumn.setCellValueFactory(MetadataTree::getPropertyName);
        this.valueColumn.setCellValueFactory((Callback)this.formatter);
        this.setColumnResizePolicy(CONSTRAINED_RESIZE_POLICY);
        this.getColumns().setAll((Object[])new TreeTableColumn[]{this.nameColumn, this.valueColumn});
        this.contentProperty.addListener(MetadataTree::applyChange);
        if (!bl) {
            this.setShowRoot(false);
            if (metadataSummary != null) {
                metadataSummary.nativeMetadataViews.add(this);
            }
        }
    }

    final Locale getLocale() {
        return this.formatter.getLocale();
    }

    public final void setContent(TreeTable treeTable) {
        this.contentProperty.setValue((Object)treeTable);
    }

    public final TreeTable getContent() {
        return (TreeTable)this.contentProperty.getValue();
    }

    private static void applyChange(ObservableValue<? extends TreeTable> observableValue, TreeTable treeTable, TreeTable treeTable2) {
        MetadataTree metadataTree = (MetadataTree)((Object)((ContentProperty)observableValue).getBean());
        Item item = null;
        if (treeTable2 != null) {
            item = new Item(treeTable2.getRoot());
            item.setExpanded(true);
        }
        metadataTree.setRoot(item);
    }

    private static <T> T getValue(TreeTableColumn.CellDataFeatures<TreeTable.Node, ?> cellDataFeatures, TableColumn<T> tableColumn) {
        TreeTable.Node node = (TreeTable.Node)cellDataFeatures.getValue().getValue();
        return node.getValue(tableColumn);
    }

    private static ObservableValue<String> getPropertyName(TreeTableColumn.CellDataFeatures<TreeTable.Node, String> cellDataFeatures) {
        String string;
        CharSequence charSequence = MetadataTree.getValue(cellDataFeatures, TableColumn.NAME);
        if (charSequence instanceof InternationalString) {
            MetadataTree metadataTree = (MetadataTree)cellDataFeatures.getTreeTableView();
            string = ((InternationalString)charSequence).toString(metadataTree.getLocale());
        } else {
            string = charSequence != null ? charSequence.toString() : null;
        }
        return new ReadOnlyStringWrapper(string);
    }

    private static final class Formatter
    extends PropertyFormat
    implements Callback<TreeTableColumn.CellDataFeatures<TreeTable.Node, Object>, ObservableValue<Object>> {
        private final Locale locale;

        Formatter(Locale locale) {
            super(new StringBuilder());
            this.locale = locale;
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }

        public ObservableValue<Object> call(TreeTableColumn.CellDataFeatures<TreeTable.Node, Object> cellDataFeatures) {
            MetadataTree metadataTree = (MetadataTree)cellDataFeatures.getTreeTableView();
            Object object = MetadataTree.getValue(cellDataFeatures, metadataTree.valueSourceColumn);
            if (object instanceof IdentifiedObject) {
                object = IdentifiedObjects.getDisplayName((IdentifiedObject)((IdentifiedObject)object), (Locale)this.locale);
            }
            try {
                this.clear();
                StringBuilder stringBuilder = (StringBuilder)this.out;
                stringBuilder.setLength(0);
                this.appendValue(object);
                this.flush();
                object = stringBuilder.toString();
            }
            catch (IOException iOException) {
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.gui"), Formatter.class, "call", iOException);
            }
            return new ReadOnlyObjectWrapper(object);
        }
    }

    private static final class ContentProperty
    extends SimpleObjectProperty<TreeTable> {
        private static final TableColumn<?>[] VALUES_COLUMNS = new TableColumn[]{TableColumn.VALUE, TableColumn.VALUE_AS_NUMBER, TableColumn.VALUE_AS_TEXT};

        ContentProperty(MetadataTree metadataTree) {
            super((Object)metadataTree, "content");
        }

        public void set(TreeTable treeTable) {
            if (treeTable != null) {
                List<TableColumn<?>> list = treeTable.getColumns();
                if (list.contains(TableColumn.NAME)) {
                    for (TableColumn<?> tableColumn : VALUES_COLUMNS) {
                        if (!list.contains(tableColumn)) continue;
                        ((MetadataTree)((Object)this.getBean())).valueSourceColumn = tableColumn;
                        break;
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
            super.set((Object)treeTable);
        }
    }

    private static final class Item
    extends TreeItem<TreeTable.Node> {
        private final boolean isLeaf;

        Item(TreeTable.Node node) {
            super((Object)node);
            this.isLeaf = node.isLeaf() || node.getChildren().isEmpty();
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public ObservableList<TreeItem<TreeTable.Node>> getChildren() {
            ObservableList observableList = super.getChildren();
            if (observableList.isEmpty()) {
                Collection<TreeTable.Node> collection = ((TreeTable.Node)this.getValue()).getChildren();
                ArrayList<Item> arrayList = new ArrayList<Item>(collection.size());
                for (TreeTable.Node node : collection) {
                    arrayList.add(new Item(node));
                }
                observableList.setAll(arrayList);
            }
            return observableList;
        }
    }
}

