/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.util.Callback;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;

public abstract class MapCanvasAWT
extends MapCanvas {
    private static final boolean NATIVE_ACCELERATION = false;
    public final ObjectProperty<Insets> imageMargin = new SimpleObjectProperty((Object)this, "imageMargin");
    private BufferedImage buffer;
    private VolatileImage doubleBuffer;
    private GraphicsConfiguration bufferConfiguration;
    private PixelBuffer<IntBuffer> bufferWrapper;
    protected final ImageView image = new ImageView();

    public MapCanvasAWT(Locale locale) {
        super(locale);
        this.image.setPreserveRatio(true);
        this.floatingPane.getChildren().add((Object)this.image);
    }

    private void clearBuffer() {
        this.buffer = null;
        this.doubleBuffer = null;
        this.bufferWrapper = null;
        this.bufferConfiguration = null;
    }

    @Override
    protected abstract Renderer createRenderer();

    @Override
    final Task<?> createWorker(MapCanvas.Renderer renderer) {
        assert (Platform.isFxApplicationThread());
        Renderer renderer2 = (Renderer)renderer;
        if (!renderer2.isValid((Insets)this.imageMargin.get(), this.buffer)) {
            this.clearBuffer();
            return new Creator(renderer2);
        }
        return new Updater(renderer2);
    }

    @Override
    protected void clear() {
        this.image.setImage(null);
        this.clearBuffer();
        super.clear();
    }

    protected static abstract class Renderer
    extends MapCanvas.Renderer {
        private int left;
        private int top;
        private int width;
        private int height;

        protected Renderer() {
        }

        private static int clamp(double d) {
            return (int)Math.max(0L, Math.min(32767L, Math.round(d)));
        }

        private boolean isValid(Insets insets, BufferedImage bufferedImage) {
            this.width = this.getWidth();
            this.height = this.getHeight();
            if (insets != null) {
                this.top = Renderer.clamp(insets.getTop());
                int n = Renderer.clamp(insets.getRight());
                int n2 = Renderer.clamp(insets.getBottom());
                this.left = Renderer.clamp(insets.getLeft());
                this.width = Math.addExact(this.width, this.left + n);
                this.height = Math.addExact(this.height, this.top + n2);
            }
            return bufferedImage != null && bufferedImage.getWidth() == this.width && bufferedImage.getHeight() == this.height;
        }

        private void translate(Graphics2D graphics2D) {
            graphics2D.translate(this.left, this.top);
        }

        private void translate(ImageView imageView) {
            imageView.setTranslateX((double)(-this.left));
            imageView.setTranslateY((double)(-this.top));
        }

        @Override
        protected void render() throws Exception {
        }

        protected abstract void paint(Graphics2D var1);

        @Override
        protected boolean commit(MapCanvas mapCanvas) {
            return true;
        }
    }

    private final class Creator
    extends Task<WritableImage> {
        private final Renderer renderer;
        private BufferedImage drawTo;
        private PixelBuffer<IntBuffer> wrapper;
        private GraphicsConfiguration configuration;

        Creator(Renderer renderer) {
            this.renderer = renderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WritableImage call() throws Exception {
            this.renderer.render();
            int n = this.renderer.width;
            int n2 = this.renderer.height;
            this.drawTo = new BufferedImage(n, n2, 3);
            Graphics2D graphics2D = this.drawTo.createGraphics();
            try {
                this.configuration = graphics2D.getDeviceConfiguration();
                this.renderer.translate(graphics2D);
                this.renderer.paint(graphics2D);
            }
            finally {
                graphics2D.dispose();
            }
            DataBufferInt dataBufferInt = (DataBufferInt)this.drawTo.getRaster().getDataBuffer();
            IntBuffer intBuffer = IntBuffer.wrap(dataBufferInt.getData(), dataBufferInt.getOffset(), dataBufferInt.getSize());
            this.wrapper = new PixelBuffer(n, n2, (Buffer)intBuffer, (PixelFormat)PixelFormat.getIntArgbPreInstance());
            return new WritableImage(this.wrapper);
        }

        protected void succeeded() {
            MapCanvasAWT.this.image.setImage((Image)this.getValue());
            this.renderer.translate(MapCanvasAWT.this.image);
            MapCanvasAWT.this.buffer = this.drawTo;
            MapCanvasAWT.this.bufferWrapper = this.wrapper;
            MapCanvasAWT.this.bufferConfiguration = this.configuration;
            boolean bl = this.renderer.commit(MapCanvasAWT.this);
            MapCanvasAWT.this.renderingCompleted(this);
            if (!bl || MapCanvasAWT.this.contentsChanged()) {
                MapCanvasAWT.this.repaint();
            }
        }

        protected void failed() {
            MapCanvasAWT.this.renderingCompleted(this);
        }

        protected void cancelled() {
            MapCanvasAWT.this.renderingCompleted(this);
        }
    }

    private final class Updater
    extends Task<VolatileImage>
    implements Callback<PixelBuffer<IntBuffer>, Rectangle2D> {
        private final Renderer renderer;
        private VolatileImage previousBuffer;
        private final GraphicsConfiguration configuration;
        private boolean contentsLost;

        Updater(Renderer renderer) {
            this.renderer = renderer;
            this.previousBuffer = MapCanvasAWT.this.doubleBuffer;
            this.configuration = MapCanvasAWT.this.bufferConfiguration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected VolatileImage call() throws Exception {
            this.renderer.render();
            int n = this.renderer.width;
            int n2 = this.renderer.height;
            VolatileImage volatileImage = this.previousBuffer;
            this.previousBuffer = null;
            if (volatileImage == null) {
                volatileImage = this.configuration.createCompatibleVolatileImage(n, n2, 3);
            }
            boolean bl = true;
            try {
                do {
                    if (volatileImage.validate(this.configuration) == 2) {
                        volatileImage = this.configuration.createCompatibleVolatileImage(n, n2, 3);
                    }
                    Graphics2D graphics2D = volatileImage.createGraphics();
                    try {
                        graphics2D.setBackground(ColorModelFactory.TRANSPARENT);
                        graphics2D.clearRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
                        this.renderer.translate(graphics2D);
                        this.renderer.paint(graphics2D);
                    }
                    finally {
                        graphics2D.dispose();
                    }
                } while ((bl = volatileImage.contentsLost()) && !this.isCancelled());
            }
            finally {
                if (bl) {
                    volatileImage.flush();
                }
            }
            return volatileImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Rectangle2D call(PixelBuffer<IntBuffer> pixelBuffer) {
            VolatileImage volatileImage = MapCanvasAWT.this.doubleBuffer;
            Graphics2D graphics2D = MapCanvasAWT.this.buffer.createGraphics();
            try {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.drawImage(volatileImage, 0, 0, null);
                this.contentsLost = volatileImage.contentsLost();
            }
            finally {
                graphics2D.dispose();
            }
            return null;
        }

        protected void succeeded() {
            VolatileImage volatileImage;
            MapCanvasAWT.this.doubleBuffer = volatileImage = (VolatileImage)this.getValue();
            try {
                MapCanvasAWT.this.bufferWrapper.updateBuffer((Callback)this);
            }
            finally {
                volatileImage.flush();
            }
            this.renderer.translate(MapCanvasAWT.this.image);
            boolean bl = this.renderer.commit(MapCanvasAWT.this);
            MapCanvasAWT.this.renderingCompleted(this);
            if (!bl || this.contentsLost || MapCanvasAWT.this.contentsChanged()) {
                MapCanvasAWT.this.repaint();
            }
        }

        protected void failed() {
            MapCanvasAWT.this.renderingCompleted(this);
        }

        protected void cancelled() {
            MapCanvasAWT.this.renderingCompleted(this);
        }
    }
}

