/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.Region;
import org.apache.sis.gui.coverage.CoverageExplorer;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.dataset.FeatureTable;
import org.apache.sis.gui.dataset.LoadEvent;
import org.apache.sis.gui.dataset.LogViewer;
import org.apache.sis.gui.dataset.ResourceTree;
import org.apache.sis.gui.dataset.SelectedData;
import org.apache.sis.gui.dataset.WindowManager;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.gui.metadata.MetadataTree;
import org.apache.sis.gui.metadata.StandardMetadataTree;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.resources.Vocabulary;

public class ResourceExplorer
extends WindowManager {
    private final ResourceTree resources = new ResourceTree();
    private final ReadOnlyObjectWrapper<Resource> selectedResource;
    private final MetadataSummary metadata;
    private CoverageExplorer coverage;
    private FeatureTable features;
    private final SplitPane controls;
    private final SplitPane content;
    private final Tab viewTab;
    private final Tab tableTab;
    private boolean isDataTabSet;
    private double dividerPosition;
    private transient DataTabBuilder builder;

    public ResourceExplorer() {
        this.resources.getSelectionModel().getSelectedItems().addListener(this::onResourceSelected);
        this.resources.setPrefWidth(400.0);
        this.selectedResource = new ReadOnlyObjectWrapper((Object)this, "selectedResource");
        this.metadata = new MetadataSummary();
        Vocabulary vocabulary = Vocabulary.getResources(this.resources.locale);
        this.viewTab = new Tab(vocabulary.getString((short)221));
        this.tableTab = new Tab(vocabulary.getString((short)47));
        this.tableTab.setContextMenu(new ContextMenu(new MenuItem[]{SelectedData.setTabularView(this.createNewWindowMenu())}));
        LogViewer logViewer = new LogViewer(vocabulary);
        logViewer.source.bind(this.selectedResource);
        String string = vocabulary.getString((short)85);
        MetadataTree metadataTree = new MetadataTree(this.metadata);
        Tab tab = new Tab(string, (Node)metadataTree);
        tab.setDisable(true);
        metadataTree.contentProperty.addListener((observableValue, treeTable, treeTable2) -> {
            tab.setDisable(treeTable2 == null);
            CharSequence charSequence = treeTable2 != null ? treeTable2.getRoot().getValue(TableColumn.NAME) : null;
            tab.setText(Objects.toString(charSequence, string));
        });
        Tab tab2 = new Tab(vocabulary.getString((short)244), (Node)logViewer.getView());
        tab2.disableProperty().bind((ObservableValue)logViewer.isEmptyProperty());
        TabPane tabPane = new TabPane(new Tab[]{new Tab(vocabulary.getString((short)189), (Node)this.metadata.getView()), this.viewTab, this.tableTab, new Tab(vocabulary.getString((short)131), (Node)new StandardMetadataTree(this.metadata)), tab, tab2});
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane.setTabDragPolicy(TabPane.TabDragPolicy.REORDER);
        this.controls = new SplitPane(new Node[]{this.resources});
        this.controls.setOrientation(Orientation.VERTICAL);
        this.content = new SplitPane(new Node[]{this.controls, tabPane});
        this.content.setDividerPosition(0, 0.2);
        this.dividerPosition = Double.NaN;
        SplitPane.setResizableWithParent((Node)this.resources, (Boolean)Boolean.FALSE);
        SplitPane.setResizableWithParent((Node)tabPane, (Boolean)Boolean.TRUE);
        this.viewTab.selectedProperty().addListener((observableValue, bl, bl2) -> this.dataTabShown((Boolean)bl2, true));
        this.tableTab.selectedProperty().addListener((observableValue, bl, bl2) -> this.dataTabShown((Boolean)bl2, false));
        this.builder = new DataTabBuilder(null);
        BackgroundThreads.execute((Runnable)((Object)this.builder));
    }

    @Override
    final Resources localized() {
        return this.resources.localized();
    }

    @Override
    public final Region getView() {
        return this.content;
    }

    public EventHandler<LoadEvent> getOnResourceLoaded() {
        return (EventHandler)this.resources.onResourceLoaded.get();
    }

    public void setOnResourceLoaded(EventHandler<LoadEvent> eventHandler) {
        this.resources.onResourceLoaded.set(eventHandler);
    }

    public void loadResources(Collection<?> collection) {
        for (Object obj : collection) {
            this.resources.loadResource(obj);
        }
    }

    public void removeAndClose(Resource resource) {
        this.resources.removeAndClose(resource);
    }

    private void onResourceSelected(ListChangeListener.Change<? extends TreeItem<Resource>> change) {
        TreeItem treeItem;
        Resource resource = null;
        Iterator iterator = change.getList().iterator();
        while (iterator.hasNext() && ((treeItem = (TreeItem)iterator.next()) == null || (resource = (Resource)treeItem.getValue()) == null)) {
        }
        this.selectedResource.set(resource);
        this.metadata.setMetadata(resource);
        this.isDataTabSet = this.isDataTabSelected();
        this.updateDataTab((Resource)(this.isDataTabSet ? resource : null), true);
        if (!this.isDataTabSet) {
            this.setNewWindowDisabled(!(resource instanceof GridCoverageResource) && !(resource instanceof FeatureSet));
        }
    }

    private boolean isDataTabSelected() {
        return this.viewTab.isSelected() || this.tableTab.isSelected();
    }

    private void updateDataTab(Resource resource, boolean bl) {
        if (this.builder != null) {
            this.builder.resource = resource;
            return;
        }
        Region region = null;
        FeatureTable featureTable = null;
        FeatureSet featureSet = null;
        ImageRequest imageRequest = null;
        CoverageExplorer.View view = null;
        if (resource instanceof GridCoverageResource) {
            if (this.coverage == null) {
                this.builder = new DataTabBuilder(resource);
                BackgroundThreads.execute((Runnable)((Object)this.builder));
                return;
            }
            imageRequest = new ImageRequest((GridCoverageResource)resource, null, null);
            region = this.coverage.getDataView(CoverageExplorer.View.IMAGE);
            featureTable = this.coverage.getDataView(CoverageExplorer.View.TABLE);
            view = this.viewTab.isSelected() ? CoverageExplorer.View.IMAGE : CoverageExplorer.View.TABLE;
            bl = false;
        } else if (resource instanceof FeatureSet) {
            featureSet = (FeatureSet)resource;
            if (this.features == null) {
                this.features = new FeatureTable();
            }
            featureTable = this.features;
            bl = false;
        }
        if (this.coverage != null) {
            this.coverage.setCoverage(imageRequest);
        }
        if (this.features != null) {
            this.features.setFeatures(featureSet);
        }
        if (region != null) {
            this.viewTab.setContent(region);
        }
        if (featureTable != null) {
            this.tableTab.setContent((Node)featureTable);
        }
        if (this.isDataTabSet) {
            this.setNewWindowDisabled(region == null && featureTable == null);
            this.updateControls(view);
        }
        if (bl) {
            this.defaultIfNotViewable(resource);
        }
    }

    private void dataTabShown(Boolean bl, boolean bl2) {
        CoverageExplorer.View view = null;
        if (bl.booleanValue()) {
            if (!this.isDataTabSet) {
                this.isDataTabSet = true;
                this.updateDataTab(this.getSelectedResource(), true);
            }
            if (this.coverage != null) {
                view = bl2 ? CoverageExplorer.View.IMAGE : CoverageExplorer.View.TABLE;
            }
        }
        this.updateControls(view);
    }

    private void updateControls(CoverageExplorer.View view) {
        Region region = view != null ? this.coverage.getControls(view) : null;
        ObservableList observableList = this.controls.getItems();
        if (observableList.size() >= 2) {
            if (region != null) {
                observableList.set(1, (Object)region);
            } else {
                this.dividerPosition = this.controls.getDividerPositions()[0];
                observableList.remove(1);
            }
        } else if (region != null) {
            observableList.add((Object)region);
            if (this.dividerPosition >= 0.0) {
                this.controls.setDividerPosition(0, this.dividerPosition);
            }
        }
    }

    @Override
    final SelectedData getSelectedData() {
        Resource resource = this.getSelectedResource();
        if (resource == null) {
            return null;
        }
        ImageRequest imageRequest = null;
        FeatureTable featureTable = null;
        if (resource instanceof GridCoverageResource) {
            imageRequest = new ImageRequest((GridCoverageResource)resource, null, null);
        } else if (resource instanceof FeatureSet) {
            if (this.features == null || !this.isDataTabSet) {
                this.isDataTabSet = true;
                this.updateDataTab(resource, true);
            }
            featureTable = this.features;
        } else {
            return null;
        }
        return new SelectedData(this.resources.getTitle(resource, false), featureTable, imageRequest, this.localized());
    }

    public final Resource getSelectedResource() {
        return (Resource)this.selectedResource.get();
    }

    public final ReadOnlyProperty<Resource> selectedResourceProperty() {
        return this.selectedResource.getReadOnlyProperty();
    }

    private void defaultIfNotViewable(final Resource resource) {
        if (resource instanceof Aggregate && !(resource instanceof DataSet)) {
            BackgroundThreads.execute((Runnable)new Task<Resource>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Resource call() throws DataStoreException {
                    Long l = LogHandler.loadingStart(resource);
                    try {
                        for (Resource resource3 : ((Aggregate)resource).components()) {
                            if (!(resource3 instanceof DataSet)) continue;
                            Resource resource2 = resource3;
                            return resource2;
                        }
                    }
                    finally {
                        LogHandler.loadingStop(l);
                    }
                    return null;
                }

                protected void succeeded() {
                    if (ResourceExplorer.this.getSelectedResource() == resource) {
                        ResourceExplorer.this.updateDataTab((Resource)this.getValue(), false);
                    }
                }

                protected void failed() {
                    ObservableList<LogRecord> observableList = LogHandler.getRecords(resource);
                    if (observableList != null) {
                        Throwable throwable = this.getException();
                        LogRecord logRecord = new LogRecord(Level.WARNING, throwable.getLocalizedMessage());
                        logRecord.setSourceClassName(ResourceExplorer.class.getName());
                        logRecord.setSourceMethodName("defaultIfNotViewable");
                        logRecord.setThrown(throwable);
                        observableList.add((Object)logRecord);
                    }
                }
            });
        }
    }

    private final class DataTabBuilder
    extends Task<CoverageExplorer> {
        volatile Resource resource;

        DataTabBuilder(Resource resource) {
            this.resource = resource;
        }

        protected CoverageExplorer call() {
            return new CoverageExplorer();
        }

        protected void succeeded() {
            ResourceExplorer.this.builder = null;
            ResourceExplorer.this.coverage = (CoverageExplorer)this.getValue();
            ResourceExplorer.this.updateDataTab(this.resource, true);
        }

        protected void failed() {
            ResourceExplorer.this.builder = null;
            ExceptionReporter.show((Node)ResourceExplorer.this.getView(), this);
        }

        protected void cancelled() {
            ResourceExplorer.this.builder = null;
        }
    }
}

