/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.gui.dataset.ExpandableList;
import org.apache.sis.gui.dataset.FeatureList;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.IdentityValueFactory;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.util.logging.Logging;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@DefaultProperty(value="features")
public class FeatureTable
extends TableView<AbstractFeature> {
    final Locale textLocale;
    private DefaultFeatureType featureType;
    public final ObjectProperty<FeatureSet> featuresProperty = new SimpleObjectProperty((Object)this, "features");
    private boolean isSharingList;

    public FeatureTable() {
        super((ObservableList)new FeatureList());
        this.textLocale = Locale.getDefault(Locale.Category.DISPLAY);
        this.initialize();
    }

    public FeatureTable(final FeatureTable featureTable) {
        super((ObservableList)featureTable.getFeatureList());
        featureTable.isSharingList = true;
        this.isSharingList = true;
        this.textLocale = featureTable.textLocale;
        this.featureType = featureTable.featureType;
        this.setFeatures(featureTable.getFeatures());
        this.initialize();
        if (this.featureType != null) {
            this.createColumns();
        } else if (this.getFeatures() != null) {
            featureTable.getColumns().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    observable.removeListener((InvalidationListener)this);
                    if (featureTable.getFeatures() == FeatureTable.this.getFeatures()) {
                        FeatureTable.this.featureType = featureTable.featureType;
                        if (FeatureTable.this.featureType != null) {
                            FeatureTable.this.createColumns();
                        }
                    }
                }
            });
        }
    }

    private void initialize() {
        this.featuresProperty.addListener((observableValue, featureSet, featureSet2) -> this.startFeaturesLoading((FeatureSet)featureSet2));
        this.setColumnResizePolicy(CONSTRAINED_RESIZE_POLICY);
        this.setTableMenuButtonVisible(true);
    }

    final FeatureList getFeatureList() {
        ObservableList observableList = this.getItems();
        if (observableList instanceof FeatureList) {
            return (FeatureList)observableList;
        }
        return (FeatureList)((ExpandableList)observableList).getSource();
    }

    private ExpandableList getExpandableList() {
        ObservableList observableList = this.getItems();
        if (observableList instanceof ExpandableList) {
            return (ExpandableList)observableList;
        }
        return new ExpandableList((FeatureList)observableList);
    }

    public final FeatureSet getFeatures() {
        return (FeatureSet)this.featuresProperty.get();
    }

    public final void setFeatures(FeatureSet featureSet) {
        this.featuresProperty.set((Object)featureSet);
    }

    private void startFeaturesLoading(FeatureSet featureSet) {
        FeatureList featureList;
        if (this.isSharingList) {
            featureList = new FeatureList();
            this.isSharingList = false;
            this.setItems((ObservableList)featureList);
        } else {
            featureList = this.getFeatureList();
            featureList.interrupt();
        }
        if (!featureList.startFeaturesLoading(this, featureSet)) {
            this.featureType = null;
            this.getColumns().clear();
            this.setPlaceholder(null);
        }
    }

    final void setFeatureType(DefaultFeatureType defaultFeatureType) {
        this.setPlaceholder(null);
        this.getItems().clear();
        boolean bl = defaultFeatureType != null && !defaultFeatureType.equals((Object)this.featureType);
        this.featureType = defaultFeatureType;
        if (bl) {
            this.createColumns();
        }
    }

    private void createColumns() {
        Collection collection = this.featureType.getProperties(true);
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        for (AbstractIdentifiedType abstractIdentifiedType : collection) {
            GenericName genericName = abstractIdentifiedType.getName();
            String string = genericName.toString();
            String string2 = this.string(abstractIdentifiedType.getDesignation());
            if (string2 == null && (string2 = this.string(genericName.toInternationalString())) == null) {
                string2 = string;
            }
            boolean bl = false;
            if (abstractIdentifiedType instanceof DefaultAttributeType) {
                boolean bl2 = bl = ((DefaultAttributeType)abstractIdentifiedType).getMaximumOccurs() > 1;
            }
            if (bl) {
                arrayList2.add(string);
            }
            TableColumn tableColumn = new TableColumn(string2);
            tableColumn.setCellValueFactory((Callback)new ValueGetter(string));
            tableColumn.setCellFactory(bl ? ElementCell::new : ValueCell::new);
            if (AttributeConvention.contains((GenericName)genericName)) {
                tableColumn.setVisible(false);
            }
            arrayList.add(tableColumn);
        }
        if (arrayList2.isEmpty()) {
            this.setItems((ObservableList)this.getFeatureList());
        } else {
            AbstractIdentifiedType abstractIdentifiedType;
            ExpandableList expandableList = this.getExpandableList();
            expandableList.setMultivaluedColumns(arrayList2);
            abstractIdentifiedType = new TableColumn("\u25a4");
            abstractIdentifiedType.setCellValueFactory(IdentityValueFactory.instance());
            abstractIdentifiedType.setCellFactory((Callback)expandableList);
            abstractIdentifiedType.setReorderable(false);
            abstractIdentifiedType.setSortable(false);
            abstractIdentifiedType.setResizable(false);
            abstractIdentifiedType.setMinWidth(20.0);
            abstractIdentifiedType.setMaxWidth(20.0);
            arrayList.add(0, abstractIdentifiedType);
            this.setItems((ObservableList)expandableList);
        }
        this.getColumns().setAll(arrayList);
    }

    private String string(InternationalString internationalString) {
        return internationalString != null ? Strings.trimOrNull(internationalString.toString(this.textLocale)) : null;
    }

    public void interrupt() {
        this.getFeatureList().interrupt();
    }

    final void setException(Throwable throwable) {
        this.getItems().clear();
        Region region = new ExceptionReporter(throwable).getView();
        StackPane.setAlignment((Node)region, (Pos)Pos.TOP_LEFT);
        this.setPlaceholder((Node)region);
    }

    static void unexpectedException(String string, Throwable throwable) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.gui"), FeatureTable.class, string, throwable);
    }

    static void recoverableException(String string, Exception exception) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.gui"), FeatureTable.class, string, exception);
    }

    private static final class ValueGetter
    implements Callback<TableColumn.CellDataFeatures<AbstractFeature, Object>, ObservableValue<Object>> {
        private final String name;

        ValueGetter(String string) {
            this.name = string;
        }

        public ObservableValue<Object> call(TableColumn.CellDataFeatures<AbstractFeature, Object> cellDataFeatures) {
            Object object = null;
            AbstractFeature abstractFeature = (AbstractFeature)cellDataFeatures.getValue();
            if (abstractFeature != null) {
                object = abstractFeature.getPropertyValue(this.name);
            }
            return new ReadOnlyObjectWrapper(object);
        }
    }

    private static final class ElementCell
    extends ValueCell {
        ElementCell(TableColumn<AbstractFeature, Object> tableColumn) {
            super(tableColumn);
        }

        @Override
        protected void updateItem(Object object, boolean bl) {
            if (object instanceof List) {
                List list = (List)object;
                object = list.isEmpty() ? null : list.get(0);
            } else if (object instanceof Iterable) {
                Iterator iterator = ((Iterable)object).iterator();
                object = iterator.hasNext() ? iterator.next() : null;
            }
            super.updateItem(object, bl);
        }
    }

    private static class ValueCell
    extends TableCell<AbstractFeature, Object> {
        ValueCell(TableColumn<AbstractFeature, Object> tableColumn) {
        }

        protected void updateItem(Object object, boolean bl) {
            if (object == this.getItem()) {
                return;
            }
            super.updateItem(object, bl);
            String string = null;
            if (object != null) {
                string = object.toString();
            }
            this.setText(string);
        }
    }
}

