/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Spliterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.concurrent.Task;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.gui.dataset.FeatureList;
import org.apache.sis.gui.dataset.FeatureTable;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.util.collection.BackingStoreException;

final class FeatureLoader
extends Task<Boolean>
implements Consumer<AbstractFeature> {
    private static final int PAGE_SIZE = 100;
    private final FeatureTable table;
    private final FeatureSet initializer;
    private Stream<AbstractFeature> toClose;
    private Spliterator<AbstractFeature> iterator;
    private AbstractFeature[] loaded;
    private int count;

    FeatureLoader(FeatureTable featureTable, FeatureSet featureSet) {
        this.table = featureTable;
        this.initializer = featureSet;
    }

    private FeatureLoader(FeatureLoader featureLoader) {
        this.table = featureLoader.table;
        this.toClose = featureLoader.toClose;
        this.iterator = featureLoader.iterator;
        this.initializer = null;
    }

    @Override
    public void accept(AbstractFeature abstractFeature) {
        this.loaded[this.count++] = abstractFeature;
    }

    protected Boolean call() throws DataStoreException {
        boolean bl;
        if (this.initializer != null) {
            bl = this.setType(this.initializer.getType());
            this.toClose = this.initializer.features(false);
            this.iterator = this.toClose.spliterator();
        } else {
            bl = true;
        }
        long l = this.iterator.estimateSize();
        int n = l > 100L ? 100 : 1 + (int)l;
        this.loaded = new AbstractFeature[n];
        try {
            while (this.iterator.tryAdvance(this)) {
                if (this.count >= n) {
                    this.setMissingType(bl);
                    return Boolean.TRUE;
                }
                if (!this.isCancelled()) continue;
                this.close();
                return Boolean.FALSE;
            }
        }
        catch (BackingStoreException backingStoreException) {
            try {
                this.close();
            }
            catch (DataStoreException dataStoreException) {
                backingStoreException.addSuppressed(dataStoreException);
            }
            throw backingStoreException.unwrapOrRethrow(DataStoreException.class);
        }
        this.close();
        this.setMissingType(bl);
        return Boolean.FALSE;
    }

    private void close() throws DataStoreException {
        this.iterator = null;
        Stream<AbstractFeature> stream = this.toClose;
        if (stream != null) {
            try {
                this.toClose = null;
                stream.close();
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrapOrRethrow(DataStoreException.class);
            }
        }
    }

    final void waitAndClose() {
        Throwable throwable = null;
        try {
            this.get();
        }
        catch (InterruptedException | CancellationException exception) {
            FeatureTable.recoverableException("interrupt", exception);
        }
        catch (ExecutionException executionException) {
            throwable = executionException.getCause();
        }
        try {
            this.close();
        }
        catch (DataStoreException dataStoreException) {
            if (throwable != null) {
                throwable.addSuppressed(dataStoreException);
            }
            throwable = dataStoreException;
        }
        if (throwable != null) {
            FeatureTable.unexpectedException("interrupt", throwable);
        }
    }

    protected void succeeded() {
        FeatureList featureList = this.table.getFeatureList();
        if (featureList.isCurrentLoader(this)) {
            boolean bl = (Boolean)this.getValue();
            if (this.initializer != null) {
                int n;
                long l;
                if (bl) {
                    l = this.iterator.estimateSize();
                    n = this.iterator.characteristics();
                } else {
                    l = 0L;
                    n = 64;
                }
                featureList.setFeatures(l, n, this.loaded, this.count, bl);
            } else {
                featureList.addFeatures(this.loaded, this.count, bl);
            }
            featureList.setNextPage(bl ? new FeatureLoader(this) : null);
        } else {
            try {
                this.close();
            }
            catch (DataStoreException dataStoreException) {
                FeatureTable.unexpectedException("setFeatures", dataStoreException);
            }
        }
    }

    protected void cancelled() {
        this.stop("cancelled");
    }

    protected void failed() {
        this.stop("failed");
    }

    private void stop(String string) {
        FeatureList featureList = this.table.getFeatureList();
        boolean bl = featureList.isCurrentLoader(this);
        if (bl) {
            featureList.setNextPage(null);
        }
        Throwable throwable = this.getException();
        try {
            this.close();
        }
        catch (DataStoreException dataStoreException) {
            if (throwable == null) {
                throwable = dataStoreException;
            }
            throwable.addSuppressed(dataStoreException);
        }
        if (throwable != null) {
            if (bl) {
                this.table.setException(throwable);
            } else {
                FeatureTable.unexpectedException(string, throwable);
            }
        }
    }

    private boolean setType(DefaultFeatureType defaultFeatureType) {
        if (defaultFeatureType != null) {
            Platform.runLater(() -> this.table.setFeatureType(defaultFeatureType));
            return true;
        }
        return false;
    }

    private void setMissingType(boolean bl) throws DataStoreException {
        if (!bl) {
            for (int i = 0; i < this.count; ++i) {
                AbstractFeature abstractFeature = this.loaded[i];
                if (abstractFeature == null || !this.setType(abstractFeature.getType())) continue;
                return;
            }
            throw new DataStoreException(Resources.forLocale(this.table.textLocale).getString((short)27));
        }
    }
}

