/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.j2d.EmptyShape;
import org.apache.sis.internal.feature.j2d.FlatShape;
import org.apache.sis.internal.gui.control.ColorRamp;
import org.apache.sis.internal.gui.control.ValueColorMapper;
import org.apache.sis.internal.processing.image.Isolines;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class IsolineRenderer {
    private final CoverageCanvas canvas;
    private Band[] bands;

    public IsolineRenderer(CoverageCanvas coverageCanvas) {
        if (coverageCanvas.isolines != null) {
            throw new IllegalArgumentException();
        }
        this.canvas = coverageCanvas;
        coverageCanvas.isolines = this;
    }

    private boolean isEmpty() {
        if (this.bands != null) {
            for (Band band : this.bands) {
                for (ValueColorMapper.Step step : band.steps) {
                    if (!step.visible.get()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    final void clear() {
        assert (Platform.isFxApplicationThread());
        if (this.bands != null) {
            for (Band band : this.bands) {
                band.clear();
            }
        }
    }

    public void setIsolineTables(List<ObservableList<ValueColorMapper.Step>> list) {
        if (this.bands != null) {
            for (Band band : this.bands) {
                band.dispose();
            }
        }
        this.bands = null;
        if (list != null && !list.isEmpty()) {
            this.bands = new Band[list.size()];
            for (int i = 0; i < this.bands.length; ++i) {
                this.bands[i] = new Band(list.get(i));
            }
        }
    }

    final Snapshot[] prepare() {
        assert (Platform.isFxApplicationThread());
        if (this.isEmpty()) {
            return null;
        }
        Snapshot[] snapshotArray = new Snapshot[this.bands.length];
        HashSet<Double> hashSet = new HashSet<Double>();
        for (int i = 0; i < snapshotArray.length; ++i) {
            snapshotArray[i] = this.bands[i].prepare(hashSet);
        }
        return snapshotArray;
    }

    static Future<Isolines[]> generate(Snapshot[] snapshotArray, RenderedImage renderedImage, MathTransform mathTransform) throws TransformException {
        assert (!Platform.isFxApplicationThread());
        double[][] dArrayArray = null;
        int n = ImageUtilities.getNumBands((RenderedImage)renderedImage);
        int n2 = Math.min(n, snapshotArray.length);
        for (int i = 0; i < n2; ++i) {
            Snapshot snapshot = snapshotArray[i];
            int n3 = snapshot.missingLevels.size();
            if (n3 == 0) continue;
            if (dArrayArray == null) {
                dArrayArray = new double[n][];
                Arrays.fill((Object[])dArrayArray, ArraysExt.EMPTY_DOUBLE);
            }
            double[] dArray = new double[n3];
            for (Double d : snapshot.missingLevels.keySet()) {
                dArray[--n3] = d;
            }
            assert (n3 == 0) : n3;
            dArrayArray[i] = dArray;
        }
        if (dArrayArray != null) {
            return Isolines.parallelGenerate((RenderedImage)renderedImage, dArrayArray, (MathTransform)mathTransform);
        }
        return null;
    }

    static void complete(Snapshot[] snapshotArray, Future<Isolines[]> future) throws ExecutionException, InterruptedException {
        int n;
        Isolines[] isolinesArray = future.get();
        int n2 = Math.min(snapshotArray.length, isolinesArray.length);
        for (n = 0; n < n2; ++n) {
            snapshotArray[n].complete(isolinesArray[n]);
        }
        while (n < snapshotArray.length) {
            snapshotArray[n++].clear();
        }
    }

    private final class Band
    implements ListChangeListener<ValueColorMapper.Step>,
    ChangeListener<Object> {
        final ObservableList<ValueColorMapper.Step> steps;
        private Map<Double, Shape> isolines;

        Band(ObservableList<ValueColorMapper.Step> observableList) {
            this.steps = observableList;
            this.addListeners((List<? extends ValueColorMapper.Step>)observableList);
            observableList.addListener((ListChangeListener)this);
        }

        final void clear() {
            this.isolines = null;
        }

        final void dispose() {
            this.clear();
            this.removeListeners((List<? extends ValueColorMapper.Step>)this.steps);
        }

        public void onChanged(ListChangeListener.Change<? extends ValueColorMapper.Step> change) {
            while (change.next()) {
                if (change.wasPermutated() || change.wasUpdated()) continue;
                this.removeListeners(change.getRemoved());
                this.addListeners(change.getAddedSubList());
            }
            IsolineRenderer.this.canvas.requestRepaint();
        }

        private void removeListeners(List<? extends ValueColorMapper.Step> list) {
            for (ValueColorMapper.Step step : list) {
                step.value.removeListener((ChangeListener)this);
                step.color.removeListener((ChangeListener)this);
                step.visible.removeListener((ChangeListener)this);
            }
        }

        private void addListeners(List<? extends ValueColorMapper.Step> list) {
            for (ValueColorMapper.Step step : list) {
                step.value.addListener((ChangeListener)this);
                step.color.addListener((ChangeListener)this);
                step.visible.addListener((ChangeListener)this);
            }
        }

        public void changed(ObservableValue<?> observableValue, Object object, Object object2) {
            IsolineRenderer.this.canvas.requestRepaint();
        }

        final Snapshot prepare(Set<Double> set) {
            if (this.isolines == null) {
                this.isolines = new HashMap<Double, Shape>();
            }
            Snapshot snapshot = new Snapshot(this.isolines, this.steps.size());
            for (ValueColorMapper.Step step : this.steps) {
                ColorRamp colorRamp;
                Double d = step.value.get();
                if (d.isNaN()) continue;
                set.add(d);
                if (!step.visible.get() || (colorRamp = (ColorRamp)step.color.get()) == null || colorRamp.isTransparent()) continue;
                snapshot.add(d, colorRamp.colors[0]);
            }
            this.isolines.keySet().retainAll(set);
            set.clear();
            return snapshot;
        }
    }

    static final class Snapshot {
        private final Map<Double, Shape> isolines;
        private final Map<Double, Integer> missingLevels;
        private Map<Double, Shape> newIsolines;
        private final Shape[] shapes;
        private final int[] colors;
        private int count;

        private Snapshot(Map<Double, Shape> map, int n) {
            this.isolines = map;
            this.missingLevels = new HashMap<Double, Integer>();
            this.shapes = new Shape[n];
            this.colors = new int[n];
        }

        private void clear() {
            this.isolines.clear();
            this.missingLevels.clear();
            this.newIsolines = null;
            Arrays.fill(this.shapes, null);
            this.count = 0;
        }

        private void add(Double d, int n) {
            Shape shape = this.isolines.putIfAbsent(d, EmptyShape.INSTANCE);
            if (shape == null) {
                this.missingLevels.put(d, this.count);
            }
            this.shapes[this.count] = shape;
            this.colors[this.count] = n;
            ++this.count;
        }

        private void complete(Isolines isolines) {
            this.newIsolines = isolines.polylines();
            for (Map.Entry<Double, Shape> entry : this.newIsolines.entrySet()) {
                Integer n = this.missingLevels.get(entry.getKey());
                if (n == null) continue;
                this.shapes[n.intValue()] = entry.getValue();
            }
        }

        final void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            for (int i = 0; i < this.count; ++i) {
                Shape shape = this.shapes[i];
                if (shape == null || rectangle2D != null && shape instanceof FlatShape && (shape = ((FlatShape)shape).fastClip(rectangle2D)) == null) continue;
                graphics2D.setColor(new Color(this.colors[i], true));
                graphics2D.draw(shape);
            }
        }

        final void commit() {
            assert (Platform.isFxApplicationThread());
            if (this.newIsolines != null) {
                this.isolines.putAll(this.newIsolines);
            }
        }
    }
}

