/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.image.RenderedImage;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.gui.coverage.CoverageExplorer;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.operation.MathTransform;

public class ImageRequest {
    private static final int BIDIMENSIONAL = 2;
    final GridCoverageResource resource;
    private GridCoverage coverage;
    private final GridGeometry domain;
    private final int[] range;
    private GridExtent sliceExtent;
    private static final double SLICE_RATIO = 0.0;
    CoverageExplorer listener;

    public ImageRequest(GridCoverageResource gridCoverageResource, GridGeometry gridGeometry, int ... nArray) {
        ArgumentChecks.ensureNonNull("source", gridCoverageResource);
        this.resource = gridCoverageResource;
        this.domain = gridGeometry;
        this.range = nArray != null && nArray.length != 0 ? nArray : null;
    }

    public ImageRequest(GridCoverage gridCoverage, GridExtent gridExtent) {
        ArgumentChecks.ensureNonNull("source", gridCoverage);
        this.resource = null;
        this.domain = null;
        this.range = null;
        this.coverage = gridCoverage;
        this.sliceExtent = gridExtent;
    }

    public final Optional<GridCoverage> getCoverage() {
        return Optional.ofNullable(this.coverage);
    }

    public final Optional<GridGeometry> getDomain() {
        return Optional.ofNullable(this.domain);
    }

    public final Optional<int[]> getRange() {
        return Optional.ofNullable(this.range);
    }

    public final Optional<GridExtent> getSliceExtent() {
        return Optional.ofNullable(this.sliceExtent);
    }

    public final void setSliceExtent(GridExtent gridExtent) {
        this.sliceExtent = gridExtent;
    }

    private static GridDerivation slice(GridGeometry gridGeometry) {
        GridExtent gridExtent = gridGeometry.getExtent();
        int n = gridExtent.getDimension();
        int[] nArray = new int[2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (gridExtent.getLow(i) == gridExtent.getHigh(i)) continue;
            nArray[n2] = i;
            if (++n2 >= 2) break;
        }
        return gridGeometry.derive().sliceByRatio(0.0, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized RenderedImage load(FutureTask<?> futureTask, boolean bl) throws DataStoreException {
        Long l = LogHandler.loadingStart((Resource)this.resource);
        try {
            Object object;
            GridGeometry gridGeometry;
            if (this.coverage == null) {
                gridGeometry = this.domain;
                if (gridGeometry == null) {
                    gridGeometry = this.resource.getGridGeometry();
                }
                if (gridGeometry != null && gridGeometry.getDimension() > 2) {
                    gridGeometry = ImageRequest.slice(gridGeometry).build();
                }
                this.coverage = this.resource.read(gridGeometry, this.range);
                this.coverage = this.coverage.forConvertedValues(bl);
            }
            if (futureTask.isCancelled()) {
                gridGeometry = null;
                return gridGeometry;
            }
            gridGeometry = this.sliceExtent;
            if (gridGeometry == null && (object = this.coverage.getGridGeometry()) != null && object.getDimension() > 2) {
                gridGeometry = ImageRequest.slice(object).getIntersection();
            }
            object = this.coverage.render((GridExtent)gridGeometry);
            return object;
        }
        finally {
            LogHandler.loadingStop(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void configure(StatusBar statusBar) {
        Long l = LogHandler.loadingStart((Resource)this.resource);
        try {
            GridCoverage gridCoverage = this.coverage;
            GridExtent gridExtent = this.sliceExtent;
            statusBar.applyCanvasGeometry(gridCoverage != null ? gridCoverage.getGridGeometry() : null);
            if (gridExtent != null) {
                double[] dArray = new double[gridExtent.getDimension()];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = gridExtent.getLow(i);
                }
                statusBar.localToObjectiveCRS.set((Object)MathTransforms.concatenate((MathTransform)MathTransforms.translation((double[])dArray), (MathTransform)((MathTransform)statusBar.localToObjectiveCRS.get())));
            }
        }
        finally {
            LogHandler.loadingStop(l);
        }
    }
}

