/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.apache.sis.gui.coverage.GridRowSkin;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.gui.coverage.GridViewSkin;

final class GridRow
extends IndexedCell<Void> {
    final GridView view;
    private int tileY;

    GridRow(VirtualFlow<GridRow> virtualFlow) {
        this.view = (GridView)virtualFlow.getParent();
        this.setPrefWidth(this.view.getContentWidth());
        this.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)-1.0));
        this.setOnMouseMoved((GridViewSkin)this.view.getSkin());
        this.setManaged(false);
    }

    public void updateIndex(int n) {
        super.updateIndex(n);
        this.tileY = this.view.toTileY(n);
        Skin skin = this.getSkin();
        if (skin != null) {
            ((GridRowSkin)skin).setRowIndex(n);
        }
        this.updateItem(null, n < 0 || n >= this.view.getImageHeight());
    }

    final String getSampleValue(int n) {
        return this.view.getSampleValue(this.tileY, this.getIndex(), n);
    }

    protected Skin<GridRow> createDefaultSkin() {
        return new GridRowSkin(this);
    }
}

