/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Rectangle;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.sis.gui.coverage.GridTile;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.gui.coverage.GridViewSkin;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.util.resources.Vocabulary;

final class GridError
extends VBox {
    private final GridTile tile;
    private final Throwable exception;
    private final String header;
    private final Label message;
    private final Rectangle region;

    GridError(GridView gridView, GridTile gridTile, Throwable throwable) {
        super(9.0);
        this.tile = gridTile;
        this.exception = throwable;
        this.region = gridView.getTileBounds(gridTile.tileX, gridTile.tileY);
        this.header = Resources.format((short)5, gridTile.tileX, gridTile.tileY);
        Button button = new Button(Vocabulary.format((short)62));
        Button button2 = new Button(Vocabulary.format((short)175));
        TilePane tilePane = new TilePane(12.0, 0.0, new Node[]{button, button2});
        tilePane.setPrefRows(1);
        tilePane.setPrefColumns(2);
        tilePane.setAlignment(Pos.CENTER);
        button.setMaxWidth(100.0);
        button2.setMaxWidth(100.0);
        button.setFocusTraversable(false);
        button2.setFocusTraversable(false);
        String string = throwable.getLocalizedMessage();
        this.message = new Label((String)(string == null ? this.header : this.header + System.lineSeparator() + string));
        this.message.setTextFill((Paint)Color.RED);
        this.message.setLabelFor((Node)tilePane);
        this.getChildren().addAll((Object[])new Node[]{this.message, tilePane});
        this.setAlignment(Pos.CENTER);
        this.setPadding(new Insets(12.0, 18.0, 24.0, 18.0));
        button.setOnAction(actionEvent -> this.showDetails());
        button2.setOnAction(actionEvent -> this.retry());
    }

    final Rectangle getVisibleRegion(Rectangle rectangle) {
        return rectangle.intersection(this.region);
    }

    private void showDetails() {
        ExceptionReporter.show((Node)this, Resources.format((short)16), this.header, this.exception);
    }

    private void retry() {
        GridView gridView = (GridView)this.getParent();
        ((GridViewSkin)gridView.getSkin()).removeError(this);
        this.tile.clear();
    }
}

