/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.apache.sis.coverage.Category;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.internal.coverage.j2d.Colorizer;
import org.apache.sis.internal.gui.ImmutableObjectProperty;
import org.apache.sis.internal.gui.control.ColorColumnHandler;
import org.apache.sis.internal.gui.control.ColorRamp;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

final class CoverageStyling
extends ColorColumnHandler<Category>
implements Function<Category, Color[]> {
    private final Map<String, int[]> customizedColors = new HashMap<String, int[]>();
    private final Function<Category, Color[]> fallback;
    private final CoverageCanvas canvas;

    CoverageStyling(CoverageCanvas coverageCanvas) {
        Function<Category, Color[]> function;
        this.canvas = coverageCanvas;
        if (coverageCanvas != null && (function = coverageCanvas.getCategoryColors()) != null) {
            this.fallback = function;
            return;
        }
        this.fallback = Colorizer.GRAYSCALE;
    }

    private static String key(Category category) {
        return category.getName().toString(Locale.ENGLISH);
    }

    final void setARGB(Category category, int[] nArray) {
        String string = CoverageStyling.key(category);
        int[] nArray2 = nArray != null && nArray.length != 0 ? this.customizedColors.put(string, nArray) : this.customizedColors.remove(string);
        if (this.canvas != null && !Arrays.equals(nArray, nArray2)) {
            this.canvas.setCategoryColors(this);
        }
    }

    @Override
    protected int[] getARGB(Category category) {
        Color[] colorArray;
        int[] nArray = this.customizedColors.get(CoverageStyling.key(category));
        if (nArray == null && (colorArray = this.fallback.apply(category)) != null) {
            nArray = new int[colorArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                nArray[i] = colorArray[i].getRGB();
            }
        }
        return nArray;
    }

    @Override
    public Color[] apply(Category category) {
        int[] nArray = this.customizedColors.get(CoverageStyling.key(category));
        if (nArray != null) {
            Color[] colorArray = new Color[nArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                colorArray[i] = new Color(nArray[i], true);
            }
            return colorArray;
        }
        return this.fallback.apply(category);
    }

    @Override
    protected ColorRamp.Type applyColors(Category category, ColorRamp colorRamp) {
        this.setARGB(category, colorRamp != null ? colorRamp.colors : null);
        return category.isQuantitative() ? ColorRamp.Type.GRADIENT : ColorRamp.Type.SOLID;
    }

    final TableView<Category> createCategoryTable(Vocabulary vocabulary) {
        TableColumn tableColumn = new TableColumn(vocabulary.getString((short)139));
        tableColumn.setCellValueFactory(CoverageStyling::getCategoryName);
        tableColumn.setCellFactory(CoverageStyling::createNameCell);
        tableColumn.setEditable(false);
        tableColumn.setId("name");
        TableView tableView = new TableView();
        tableView.getColumns().add((Object)tableColumn);
        this.addColumnTo(tableView, vocabulary.getString((short)228));
        return tableView;
    }

    private static TableCell<Category, String> createNameCell(TableColumn<Category, String> tableColumn) {
        TableCell tableCell = (TableCell)TableColumn.DEFAULT_CELL_FACTORY.call(tableColumn);
        tableCell.setAlignment(Pos.CENTER_LEFT);
        return tableCell;
    }

    private static ObservableValue<String> getCategoryName(TableColumn.CellDataFeatures<Category, String> cellDataFeatures) {
        InternationalString internationalString = ((Category)cellDataFeatures.getValue()).getName();
        return internationalString != null ? new ImmutableObjectProperty<String>(internationalString.toString()) : null;
    }
}

