/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui;

import java.awt.SplashScreen;
import java.awt.im.InputContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.sis.gui.AboutDialog;
import org.apache.sis.gui.RecentFiles;
import org.apache.sis.gui.dataset.LogViewer;
import org.apache.sis.gui.dataset.ResourceExplorer;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.internal.gui.RecentChoices;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Vocabulary;

public class DataViewer
extends Application {
    private static volatile DataViewer running;
    private Stage window;
    private ResourceExplorer content;
    private FileChooser.ExtensionFilter[] openFilters;
    private FileChooser.ExtensionFilter[] saveFilters;
    private FileChooser.ExtensionFilter lastFilter;
    private Stage systemLogsWindow;

    public static void main(String[] stringArray) {
        LogHandler.register(true);
        InputContext.getInstance();
        DataViewer.launch(DataViewer.class, (String[])stringArray);
    }

    public void start(Stage stage) {
        MenuItem menuItem;
        MenuItem menuItem2;
        this.window = stage;
        this.content = new ResourceExplorer();
        Resources resources = Resources.getInstance();
        Vocabulary vocabulary = Vocabulary.getResources(resources.getLocale());
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu(vocabulary.getString((short)82));
        Menu menu2 = RecentFiles.create(this.content, resources);
        menu.getItems().addAll((Object[])new MenuItem[]{menuItem2 = resources.menu((short)28, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.showOpenFileDialog())), menu2, menuItem = resources.menu((short)10, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.closeSelectedFile())), new SeparatorMenuItem(), resources.menu((short)20, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> Platform.exit()))});
        menuItem2.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+O"));
        menuItem.setDisable(true);
        this.content.selectedResourceProperty().addListener((observableValue, resource, resource2) -> menuItem.setDisable(!(resource2 instanceof DataStore)));
        menuItem2 = new Menu(resources.getString((short)47));
        menuItem = new MenuItem(vocabulary.getString((short)244));
        menuItem.setOnAction(actionEvent -> this.showSystemLogsWindow());
        menuItem2.getItems().addAll((Object[])new MenuItem[]{resources.menu((short)48, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.getHostServices().showDocument("https://sis.apache.org/"))), new SeparatorMenuItem(), menuItem, resources.menu((short)46, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> AboutDialog.show()))});
        menuItem = new Menu(resources.getString((short)21));
        menuItem.getItems().add((Object)this.content.createNewWindowMenu());
        this.content.setWindowsItems(menuItem.getItems());
        menuBar.getMenus().addAll((Object[])new Menu[]{menu, menuItem, menuItem2});
        menu2 = new BorderPane();
        menu2.setTop((Node)menuBar);
        menu2.setCenter((Node)this.content.getView());
        Scene scene = new Scene((Parent)menu2);
        scene.getStylesheets().add((Object)"org/apache/sis/gui/pseudo-classes.css");
        Rectangle2D rectangle2D = Screen.getPrimary().getVisualBounds();
        stage.setTitle("Apache Spatial Information System");
        stage.getIcons().addAll((Object[])new Image[]{new Image(DataViewer.class.getResourceAsStream("SIS_64px.png")), new Image(DataViewer.class.getResourceAsStream("SIS_128px.png"))});
        stage.setScene(scene);
        stage.setWidth(0.75 * rectangle2D.getWidth());
        stage.setHeight(0.75 * rectangle2D.getHeight());
        stage.show();
        SplashScreen splashScreen = SplashScreen.getSplashScreen();
        if (splashScreen != null) {
            splashScreen.close();
        }
        running = this;
    }

    private void createFileFilters() {
        Resources resources = Resources.getInstance();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ArrayList<FileChooser.ExtensionFilter> arrayList = new ArrayList<FileChooser.ExtensionFilter>();
        ArrayList<FileChooser.ExtensionFilter> arrayList2 = new ArrayList<FileChooser.ExtensionFilter>();
        arrayList.add(new FileChooser.ExtensionFilter(resources.getString((short)1), new String[]{"*.*"}));
        for (DataStoreProvider dataStoreProvider : DataStores.providers()) {
            String[] stringArray;
            StoreMetadata storeMetadata = dataStoreProvider.getClass().getAnnotation(StoreMetadata.class);
            if (storeMetadata == null || (stringArray = storeMetadata.fileSuffixes()).length == 0) continue;
            boolean bl = ArraysExt.contains(storeMetadata.capabilities(), Capability.READ);
            boolean bl2 = ArraysExt.contains(storeMetadata.capabilities(), Capability.WRITE);
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                stringArray[i] = string = "*.".concat(stringArray[i]);
                if (!bl) continue;
                linkedHashSet.add(string);
            }
            FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter(storeMetadata.formatName() + " (" + stringArray[0] + ")", stringArray);
            if (bl) {
                arrayList.add(extensionFilter);
            }
            if (!bl2) continue;
            arrayList2.add(extensionFilter);
        }
        arrayList.add(1, new FileChooser.ExtensionFilter(resources.getString((short)23), linkedHashSet.toArray(new String[linkedHashSet.size()])));
        this.openFilters = arrayList.toArray(new FileChooser.ExtensionFilter[arrayList.size()]);
        this.saveFilters = arrayList2.toArray(new FileChooser.ExtensionFilter[arrayList2.size()]);
    }

    private void showOpenFileDialog() {
        if (this.openFilters == null) {
            this.createFileFilters();
            this.lastFilter = this.openFilters[1];
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Resources.format((short)29));
        fileChooser.getExtensionFilters().addAll((Object[])this.openFilters);
        fileChooser.setSelectedExtensionFilter(this.lastFilter);
        fileChooser.setInitialDirectory(RecentChoices.getOpenDirectory());
        List list = fileChooser.showOpenMultipleDialog((Window)this.window);
        if (list != null) {
            RecentChoices.setOpenDirectory(list);
            this.lastFilter = fileChooser.getSelectedExtensionFilter();
            this.content.loadResources(list);
        }
    }

    private void showSystemLogsWindow() {
        if (this.systemLogsWindow == null) {
            LogViewer logViewer = new LogViewer();
            logViewer.systemLogs.set(true);
            Stage stage = new Stage();
            stage.setTitle(Vocabulary.format((short)244) + " \u2014 Apache SIS");
            stage.getIcons().setAll((Collection)this.window.getIcons());
            stage.setScene(new Scene((Parent)logViewer.getView()));
            stage.setWidth(800.0);
            stage.setHeight(600.0);
            this.window.setOnHidden(windowEvent -> stage.hide());
            this.systemLogsWindow = stage;
        }
        this.systemLogsWindow.show();
    }

    private void closeSelectedFile() {
        this.content.removeAndClose(this.content.getSelectedResource());
    }

    public void stop() throws Exception {
        running = null;
        LogHandler.register(false);
        BackgroundThreads.stop();
        RecentChoices.saveReferenceSystems();
        super.stop();
    }

    public static Stage getCurrentStage() {
        DataViewer dataViewer = running;
        return dataViewer != null ? dataViewer.window : null;
    }
}

