/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.GridAdjustment;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.ChannelDecoder;
import org.apache.sis.internal.netcdf.impl.DimensionInfo;
import org.apache.sis.internal.netcdf.impl.GridInfo;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.HyperRectangleReader;
import org.apache.sis.internal.storage.io.Region;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;

final class VariableInfo
extends Variable
implements Comparable<VariableInfo> {
    private static final String[] DESCRIPTION_ATTRIBUTES = new String[]{"long_name", "description", "title", "standard_name"};
    private final HyperRectangleReader reader;
    private final String name;
    final DimensionInfo[] dimensions;
    private long offsetToNextRecord;
    private final Map<String, Object> attributes;
    private final Set<String> attributeNames;
    private final DataType dataType;
    GridInfo grid;
    boolean isCoordinateSystemAxis;

    VariableInfo(Decoder decoder, ChannelDataInput channelDataInput, String string, DimensionInfo[] dimensionInfoArray, Map<String, Object> map, Set<String> set, DataType dataType, int n, long l) throws DataStoreContentException {
        super(decoder);
        this.name = string;
        this.dimensions = dimensionInfoArray;
        this.attributes = map;
        this.attributeNames = set;
        Object object = this.getAttributeValue("_Unsigned", "_unsigned");
        if (object instanceof String) {
            dataType = dataType.unsigned(Boolean.valueOf((String)object));
        }
        this.dataType = dataType;
        if (dataType != null && (this.offsetToNextRecord = (long)dataType.size()) != 0L) {
            for (int i = 0; i < dimensionInfoArray.length; ++i) {
                DimensionInfo dimensionInfo = dimensionInfoArray[i];
                if (!dimensionInfo.isUnlimited) {
                    this.offsetToNextRecord = Math.multiplyExact(this.offsetToNextRecord, dimensionInfo.length());
                    continue;
                }
                if (i == 0) continue;
                throw new DataStoreContentException(this.getLocale(), "netCDF", channelDataInput.filename, null);
            }
            this.reader = new HyperRectangleReader(dataType.number, channelDataInput);
            this.reader.setOrigin(l);
        } else {
            this.reader = null;
        }
        if (n != -1) {
            long l2 = this.paddedSize();
            long l3 = Integer.toUnsignedLong(n);
            if (l3 != l2) {
                if (l2 != 0L) {
                    this.warning(ChannelDecoder.class, "readVariables", (short)8, this.getFilename(), string, l3 - l2);
                }
                if (l3 > this.offsetToNextRecord) {
                    this.offsetToNextRecord = l3;
                }
            }
        }
        boolean bl = this.isCoordinateSystemAxis = (dimensionInfoArray.length == 1 || dimensionInfoArray.length == 2) && this.getAxisType() != null;
        if (!this.isCoordinateSystemAxis && dimensionInfoArray.length == 1) {
            Object object2 = this.getAttributeValue("_CoordinateAliasForDimension", "_coordinatealiasfordimension");
            if (object2 == null && (object2 = this.getAttributeValue("_CoordinateVariableAlias", "_coordinatevariablealias")) == null) {
                object2 = string;
            }
            this.isCoordinateSystemAxis = dimensionInfoArray[0].name.equals(object2);
        }
        this.split("flag_names");
        this.split("flag_meanings");
        this.setEnumeration(null);
    }

    private void split(String string) {
        Object object;
        CharSequence[] charSequenceArray = this.getAttributeAsStrings(string, ' ');
        if (charSequenceArray != null && (object = this.attributes.put(string, charSequenceArray)) instanceof Vector) {
            this.attributes.put(string, object);
        }
    }

    private long paddedSize() {
        return Math.addExact(this.offsetToNextRecord, 3L) & 0xFFFFFFFFFFFFFFFCL;
    }

    static void complete(VariableInfo[] variableInfoArray) {
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
        VariableInfo[] variableInfoArray2 = new VariableInfo[variableInfoArray.length];
        int n = 0;
        long l = 0L;
        boolean bl = false;
        for (VariableInfo variableInfo : variableInfoArray) {
            hashSet.addAll(Arrays.asList(variableInfo.getCoordinateVariables()));
            if (!variableInfo.isUnlimited()) continue;
            long l2 = variableInfo.paddedSize();
            variableInfoArray2[n++] = variableInfo;
            bl |= l2 == 0L;
            l = Math.addExact(l, l2);
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                variableInfoArray2[i].offsetToNextRecord = -1L;
            }
        } else if (n == 1) {
            variableInfoArray2[0].offsetToNextRecord = 0L;
        } else {
            for (int i = 0; i < n; ++i) {
                variableInfoArray2[i].offsetToNextRecord = Math.subtractExact(l, variableInfoArray2[i].offsetToNextRecord);
            }
        }
        if (!hashSet.isEmpty()) {
            for (VariableInfo variableInfo : variableInfoArray) {
                if (!hashSet.remove(variableInfo.name)) continue;
                variableInfo.isCoordinateSystemAxis = true;
                if (hashSet.isEmpty()) break;
            }
        }
    }

    @Override
    public String getFilename() {
        String string;
        if (this.reader != null && (string = this.reader.filename()) != null) {
            return string;
        }
        return super.getFilename();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        for (String string : DESCRIPTION_ATTRIBUTES) {
            String string2 = this.getAttributeAsString(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    @Override
    protected String getUnitsString() {
        return this.getAttributeAsString("units");
    }

    @Override
    protected Unit<?> parseUnit(String string) {
        Unit<?> unit;
        Matcher matcher = TIME_UNIT_PATTERN.matcher(string);
        DateTimeParseException dateTimeParseException = null;
        if (matcher.matches()) {
            try {
                this.epoch = StandardDateFormat.parseInstantUTC(matcher.group(2));
            }
            catch (DateTimeParseException dateTimeParseException2) {
                dateTimeParseException = dateTimeParseException2;
            }
            string = matcher.group(1);
        }
        try {
            unit = Units.valueOf(string);
        }
        catch (ParserException parserException) {
            if (dateTimeParseException != null) {
                parserException.addSuppressed((Throwable)dateTimeParseException);
            }
            throw parserException;
        }
        if (dateTimeParseException != null) {
            this.error(Variable.class, "getUnit", dateTimeParseException, (short)183, this.getName(), string);
        }
        return unit;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    protected boolean isUnlimited() {
        return this.dimensions.length != 0 && this.dimensions[0].isUnlimited;
    }

    @Override
    protected boolean isCoordinateSystemAxis() {
        return this.isCoordinateSystemAxis;
    }

    @Override
    protected String getAxisType() {
        Object object = this.getAttributeValue("_CoordinateAxisType", "_coordinateaxistype");
        return object != null ? object.toString() : null;
    }

    final CharSequence[] getCoordinateVariables() {
        return CharSequences.split(this.getAttributeAsString("coordinates"), ' ');
    }

    @Override
    protected Grid getGrid(GridAdjustment gridAdjustment) throws IOException, DataStoreException {
        if (this.grid == null) {
            this.decoder.getGrids();
            if (this.grid == null) {
                this.grid = (GridInfo)super.getGrid(gridAdjustment);
            }
        }
        return this.grid;
    }

    @Override
    public int getNumDimensions() {
        return this.dimensions.length;
    }

    @Override
    public List<Dimension> getGridDimensions() {
        return UnmodifiableArrayList.wrap(this.dimensions);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributeNames);
    }

    @Override
    public Class<?> getAttributeType(String string) {
        return Classes.getClass(this.getAttributeValue(string));
    }

    private Object getAttributeValue(String string, String string2) {
        Object object = this.getAttributeValue(string);
        if (object == null) {
            object = this.attributes.get(string2);
        }
        return object;
    }

    @Override
    protected Object getAttributeValue(String string) {
        return this.attributes.get(string);
    }

    final void addAttributesTo(TreeTable.Node node) {
        VariableInfo.addAttributesTo(node, this.attributeNames, this.attributes);
    }

    static void addAttributesTo(TreeTable.Node node, Set<String> set, Map<String, Object> map) {
        for (String string : set) {
            TreeTable.Node node2 = node.newChild();
            node2.setValue(TableColumn.NAME, string);
            Object[] objectArray = map.get(string);
            if (objectArray == null) continue;
            if (objectArray instanceof Vector) {
                objectArray = ((Vector)objectArray).toArray();
            }
            node2.setValue(TableColumn.VALUE, objectArray);
        }
    }

    @Override
    protected Object readFully() throws IOException, DataStoreException {
        return this.readArray(null, null);
    }

    @Override
    public Vector read(GridExtent gridExtent, int[] nArray) throws IOException, DataStoreException {
        return Vector.create(this.readArray(gridExtent, nArray), this.dataType.isUnsigned);
    }

    @Override
    public List<?> readAnyType(GridExtent gridExtent, int[] nArray) throws IOException, DataStoreException {
        Object object = this.readArray(gridExtent, nArray);
        if (this.dataType == DataType.CHAR && this.dimensions.length >= 2) {
            return this.createStringList(object, gridExtent);
        }
        return Vector.create(object, this.dataType.isUnsigned);
    }

    private Object readArray(GridExtent gridExtent, int[] nArray) throws IOException, DataStoreException {
        float[] fArray;
        if (this.reader == null) {
            throw new DataStoreContentException(this.unknownType());
        }
        int n = this.dimensions.length;
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        long[] lArray3 = gridExtent != null ? new long[n] : lArray2;
        for (int i = 0; i < n; ++i) {
            lArray3[i] = this.dimensions[n - 1 - i].length();
            if (gridExtent == null) continue;
            lArray[i] = gridExtent.getLow(i);
            lArray2[i] = Math.incrementExact(gridExtent.getHigh(i));
        }
        if (nArray == null) {
            nArray = new int[n];
            Arrays.fill(nArray, 1);
        }
        Region region = new Region(lArray3, lArray, lArray2, nArray);
        if (this.isUnlimited()) {
            if (this.offsetToNextRecord < 0L) {
                throw this.canNotComputePosition(null);
            }
            region.setAdditionalByteOffset(this.dimensions.length - 1, this.offsetToNextRecord);
        }
        Object object = this.reader.read(region);
        this.replaceNaN(object);
        if (gridExtent == null && object instanceof double[] && (fArray = ArraysExt.copyAsFloatsIfLossless((double[])object)) != null) {
            object = fArray;
        }
        return object;
    }

    @Override
    protected String[] createStringArray(Object object, int n, int n2) {
        byte[] byArray = (byte[])object;
        Charset charset = ((ChannelDecoder)this.decoder).getEncoding();
        String[] stringArray = new String[n];
        int n3 = 0;
        String string = "";
        if (StoreUtilities.basedOnASCII(charset)) {
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                int n6;
                String string2 = "";
                int n7 = n6 = n3 + n2;
                while (--n7 >= n3) {
                    if (Byte.toUnsignedInt(byArray[n7]) <= 32) continue;
                    while (Byte.toUnsignedInt(byArray[n3]) <= 32) {
                        ++n3;
                    }
                    if (JDK9.equals(byArray, n3, ++n7, byArray, n4, n5)) {
                        string2 = string;
                        break;
                    }
                    string = string2 = new String(byArray, n3, n7 - n3, charset);
                    n4 = n3;
                    n5 = n7;
                    break;
                }
                stringArray[i] = string2;
                n3 = n6;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                String string3 = new String(byArray, n3, n2, charset).trim();
                if (!string.equals(string3)) {
                    string = string3;
                }
                stringArray[i] = string;
                n3 += n2;
            }
        }
        return stringArray;
    }

    @Override
    protected double coordinateForAxis(int n, int n2) throws IOException, DataStoreException {
        assert (n >= 0 && n < this.dimensions[0].length) : n;
        assert (n2 >= 0 && n2 < this.dimensions[1].length) : n2;
        long l = this.dimensions[1].length();
        return this.read().doubleValue(Math.toIntExact((long)n2 + l * (long)n));
    }

    private String unknownType() {
        return this.resources().getString((short)5, this.getFilename(), this.name, (Object)this.dataType);
    }

    @Override
    public int compareTo(VariableInfo variableInfo) {
        int n = Long.compare(this.reader.getOrigin(), variableInfo.reader.getOrigin());
        if (n == 0) {
            n = this.name.compareTo(variableInfo.name);
        }
        return n;
    }
}

