/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.console.FormattedOutputCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.console.OutputFormat;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.storage.CodeType;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.LineAppender;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

final class TransformCommand
extends FormattedOutputCommand {
    private CoordinateOperation operation;
    private MathTransform toDomainOfValidity;
    private final Vocabulary resources;
    private TableAppender outHeader;
    private NumberFormat coordinateFormat;
    private int coordinateWidth;
    private int[] numFractionDigits;
    private double[] thresholdForScientificNotation;
    private String errorMessage;
    private NumberFormatException errorCause;

    private static EnumSet<Option> options() {
        return EnumSet.of(Option.SOURCE_CRS, new Option[]{Option.TARGET_CRS, Option.VERBOSE, Option.LOCALE, Option.TIMEZONE, Option.ENCODING, Option.COLORS, Option.HELP, Option.DEBUG});
    }

    TransformCommand(int n, String ... stringArray) throws InvalidOptionException {
        super(n, stringArray, TransformCommand.options(), OutputFormat.WKT, OutputFormat.TEXT);
        this.resources = Vocabulary.getResources((Locale)this.locale);
    }

    private CoordinateReferenceSystem fetchCRS(Option option) throws InvalidOptionException, FactoryException, DataStoreException {
        Metadata metadata;
        String string = (String)this.options.get((Object)option);
        if (string == null) {
            String string2 = option.label();
            throw new InvalidOptionException(Errors.format((short)88, (Object)string2), string2);
        }
        if (CodeType.guess((String)string).isCRS) {
            try {
                return CRS.forCode((String)string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                String string3 = option.label();
                throw new InvalidOptionException(Errors.format((short)56, (Object)string3, (Object)string), noSuchAuthorityCodeException, string3);
            }
        }
        try (DataStore dataStore = DataStores.open((Object)string);){
            metadata = dataStore.getMetadata();
        }
        if (metadata != null) {
            for (ReferenceSystem referenceSystem : metadata.getReferenceSystemInfo()) {
                if (!(referenceSystem instanceof CoordinateReferenceSystem)) continue;
                return (CoordinateReferenceSystem)referenceSystem;
            }
        }
        throw new InvalidOptionException(Errors.format((short)157), option.label());
    }

    @Override
    public int run() throws Exception {
        CoordinateReferenceSystem coordinateReferenceSystem = this.fetchCRS(Option.SOURCE_CRS);
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.fetchCRS(Option.TARGET_CRS);
        GeographicBoundingBox geographicBoundingBox = null;
        List<double[]> list = Collections.emptyList();
        boolean bl = this.useStandardInput();
        if (bl || !this.files.isEmpty()) {
            Object object;
            if (bl) {
                object = new LineNumberReader(new InputStreamReader(System.in, this.encoding));
                try {
                    list = this.readCoordinates((LineNumberReader)object, "stdin");
                }
                finally {
                    ((BufferedReader)object).close();
                }
            } else {
                for (String string : this.files) {
                    try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(string), this.encoding));){
                        list = this.readCoordinates(lineNumberReader, string);
                    }
                }
            }
            try {
                object = ReferencingUtilities.toNormalizedGeographicCRS((CoordinateReferenceSystem)coordinateReferenceSystem, (boolean)false, (boolean)false);
                if (object != null) {
                    this.toDomainOfValidity = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)object, null).getMathTransform();
                    geographicBoundingBox = this.computeAreaOfInterest(list);
                }
            }
            catch (FactoryException factoryException) {
                TransformCommand.warning((Exception)((Object)factoryException));
            }
        }
        this.operation = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)coordinateReferenceSystem2, geographicBoundingBox);
        this.outHeader = new TableAppender((Appendable)new LineAppender((Appendable)this.out), " ");
        this.outHeader.setMultiLinesCells(true);
        this.printHeader((short)182);
        this.printNameAndIdentifier((IdentifiedObject)this.operation.getSourceCRS(), false);
        this.printHeader((short)61);
        this.printNameAndIdentifier((IdentifiedObject)this.operation.getTargetCRS(), false);
        this.printHeader((short)151);
        this.printOperations(this.operation, false);
        this.outHeader.nextLine();
        this.printDomainOfValidity(this.operation.getDomainOfValidity());
        this.printAccuracy(CRS.getLinearAccuracy((CoordinateOperation)this.operation));
        if (this.options.containsKey((Object)Option.VERBOSE)) {
            this.printDetails();
        }
        this.outHeader.flush();
        this.outHeader = null;
        if (!list.isEmpty()) {
            this.coordinateWidth = 15;
            this.coordinateFormat = NumberFormat.getInstance(Locale.US);
            this.coordinateFormat.setGroupingUsed(false);
            this.computeNumFractionDigits(this.operation.getTargetCRS().getCoordinateSystem());
            this.out.println();
            this.printAxes(this.operation.getTargetCRS().getCoordinateSystem());
            this.out.println();
            this.transform(list);
            if (this.errorMessage != null) {
                this.error(this.errorMessage, this.errorCause);
            }
        }
        return 0;
    }

    private void printCommentLinePrefix() {
        if (this.colors) {
            this.outHeader.append((CharSequence)X364.FOREGROUND_GRAY.sequence());
        }
        this.outHeader.append((CharSequence)"# ");
        if (this.colors) {
            this.outHeader.append((CharSequence)X364.FOREGROUND_DEFAULT.sequence());
        }
    }

    private void printHeader(short s) throws IOException {
        this.printCommentLinePrefix();
        this.resources.appendLabel(s, (Appendable)this.outHeader);
        this.outHeader.nextColumn();
    }

    private boolean printNameAndIdentifier(IdentifiedObject identifiedObject, boolean bl) {
        String string = IdentifiedObjects.toString((Identifier)IdentifiedObjects.getIdentifier((IdentifiedObject)identifiedObject, null));
        if (bl && string == null) {
            return false;
        }
        this.outHeader.append((CharSequence)identifiedObject.getName().getCode());
        if (string != null) {
            this.outHeader.append(' ');
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_CYAN.sequence());
            }
            this.outHeader.append('(');
            this.outHeader.append((CharSequence)string);
            this.outHeader.append(')');
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_DEFAULT.sequence());
            }
        }
        if (!bl) {
            this.outHeader.nextLine();
        }
        return true;
    }

    private void printOperations(CoordinateOperation coordinateOperation, boolean bl) {
        if (bl) {
            bl = false;
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_GREEN.sequence());
            }
            this.outHeader.append((CharSequence)" \u2192 ");
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_DEFAULT.sequence());
            }
        }
        if (!this.printNameAndIdentifier((IdentifiedObject)coordinateOperation, true)) {
            if (coordinateOperation instanceof ConcatenatedOperation) {
                for (CoordinateOperation coordinateOperation2 : ((ConcatenatedOperation)coordinateOperation).getOperations()) {
                    this.printOperations(coordinateOperation2, bl);
                    bl = true;
                }
            } else if (coordinateOperation instanceof PassThroughOperation) {
                this.printOperations((CoordinateOperation)((PassThroughOperation)coordinateOperation).getOperation(), false);
            } else if (coordinateOperation instanceof SingleOperation) {
                this.outHeader.append((CharSequence)((SingleOperation)coordinateOperation).getMethod().getName().getCode());
            }
        }
    }

    private void printAccuracy(double d) throws IOException {
        if (d >= 0.0) {
            if (d == 0.0) {
                d = 0.01;
            }
            this.printHeader((short)2);
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_YELLOW.sequence());
            }
            this.outHeader.append((CharSequence)Double.toString(d));
            if (this.colors) {
                this.outHeader.append((CharSequence)X364.FOREGROUND_DEFAULT.sequence());
            }
            this.outHeader.append((CharSequence)" metres");
            this.outHeader.nextLine();
        }
    }

    private void printDomainOfValidity(Extent extent) throws IOException {
        InternationalString internationalString;
        if (extent != null && (internationalString = extent.getDescription()) != null) {
            int n;
            String string = internationalString.toString(this.locale);
            if (string.length() >= 80 && (n = string.indexOf(59)) >= 0) {
                int n2 = string.lastIndexOf(45, n);
                if (n2 >= 0) {
                    n = n2;
                }
                string = string.substring(0, n).trim();
            }
            this.printHeader((short)69);
            this.outHeader.append((CharSequence)string);
            this.outHeader.nextLine();
        }
    }

    private void printDetails() throws IOException {
        boolean bl = this.options.containsKey((Object)Option.DEBUG);
        WKTFormat wKTFormat = new WKTFormat(this.locale, this.timezone);
        if (this.colors) {
            wKTFormat.setColors(Colors.DEFAULT);
        }
        wKTFormat.setConvention(this.convention);
        CharSequence[] charSequenceArray = CharSequences.splitOnEOL((CharSequence)wKTFormat.format(bl ? this.operation.getMathTransform() : this.operation));
        for (int i = 0; i < charSequenceArray.length; ++i) {
            if (i == 0) {
                this.printHeader((short)62);
            } else {
                this.printCommentLinePrefix();
                this.outHeader.nextColumn();
            }
            this.outHeader.append(charSequenceArray[i]);
            this.outHeader.nextLine();
        }
        Warnings warnings = wKTFormat.getWarnings();
        if (warnings != null && (charSequenceArray = CharSequences.splitOnEOL((CharSequence)warnings.toString())).length != 0) {
            this.printHeader((short)143);
            this.outHeader.append(charSequenceArray[0]);
            this.outHeader.nextLine();
        }
    }

    private void printQuotedText(String string, int n, X364 x364) {
        boolean bl;
        if (string.indexOf(34) >= 0) {
            string = string.replace("\"", "\"\"");
            bl = true;
        } else {
            boolean bl2 = bl = string.indexOf(44) >= 0;
        }
        if (bl) {
            n -= 2;
        }
        this.out.print(CharSequences.spaces((int)(n - string.length())));
        if (this.colors) {
            this.out.print(x364.sequence());
        }
        if (bl) {
            this.out.print('\"');
        }
        this.out.print(string);
        if (bl) {
            this.out.print('\"');
        }
        if (this.colors) {
            this.out.print(X364.FOREGROUND_DEFAULT.sequence());
        }
    }

    private void printAxes(CoordinateSystem coordinateSystem) {
        int n = coordinateSystem.getDimension();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                this.out.print(',');
            }
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            String string = coordinateSystemAxis.getName().getCode();
            string = Transliterator.DEFAULT.toShortAxisName(coordinateSystem, coordinateSystemAxis.getDirection(), string);
            String string2 = coordinateSystemAxis.getUnit().toString();
            if (!string2.isEmpty()) {
                string = string + " (" + string2 + ')';
            }
            this.printQuotedText(string, this.coordinateWidth, X364.FOREGROUND_CYAN);
        }
    }

    private void computeNumFractionDigits(CoordinateSystem coordinateSystem) throws IncommensurableException {
        int n = coordinateSystem.getDimension();
        this.numFractionDigits = new int[n];
        this.thresholdForScientificNotation = new double[n];
        for (int i = 0; i < n; ++i) {
            Unit unit;
            double d;
            Unit unit2 = coordinateSystem.getAxis(0).getUnit();
            if (Units.isLinear((Unit)unit2)) {
                d = 0.01;
                unit = Units.METRE;
            } else if (Units.isAngular((Unit)unit2)) {
                d = 8.999280057595393E-8;
                unit = Units.DEGREE;
            } else {
                d = 0.001;
                unit = unit2;
            }
            d = unit.getConverterToAny(unit2).convert(d);
            if (d > 0.0) {
                this.numFractionDigits[i] = Math.max(DecimalFunctions.fractionDigitsForDelta((double)d, (boolean)false) + 1, 0);
            }
            this.thresholdForScientificNotation[i] = MathFunctions.pow10((int)(this.coordinateWidth - 1 - this.numFractionDigits[i]));
        }
    }

    private List<double[]> readCoordinates(LineNumberReader lineNumberReader, String string) throws IOException {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        try {
            String string2;
            while ((string2 = lineNumberReader.readLine()) != null) {
                int n = CharSequences.skipLeadingWhitespaces((CharSequence)string2, (int)0, (int)string2.length());
                if (n >= string2.length() || string2.charAt(n) == '#') continue;
                arrayList.add(CharSequences.parseDoubles((CharSequence)string2, (char)','));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.errorMessage = Errors.format((short)33, (Object)string, (Object)lineNumberReader.getLineNumber());
            this.errorCause = numberFormatException;
        }
        return arrayList;
    }

    private GeographicBoundingBox computeAreaOfInterest(List<double[]> list) {
        int n = this.toDomainOfValidity.getSourceDimensions();
        double[] dArray = new double[this.toDomainOfValidity.getTargetDimensions()];
        if (dArray.length >= 2) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            double d4 = Double.NEGATIVE_INFINITY;
            for (double[] dArray2 : list) {
                if (dArray2.length != n) continue;
                try {
                    this.toDomainOfValidity.transform(dArray2, 0, dArray, 0, 1);
                }
                catch (TransformException transformException) {
                    TransformCommand.warning((Exception)((Object)transformException));
                    continue;
                }
                double d5 = dArray[0];
                double d6 = dArray[1];
                if (d5 < d) {
                    d = d5;
                }
                if (d5 > d3) {
                    d3 = d5;
                }
                if (d6 < d2) {
                    d2 = d6;
                }
                if (!(d6 > d4)) continue;
                d4 = d6;
            }
            if (d < d3 && d2 < d4) {
                return new DefaultGeographicBoundingBox(d, d3, d2, d4);
            }
        }
        return null;
    }

    private void transform(List<double[]> list) throws TransformException {
        DirectPositionView.Double double_;
        double[] dArray;
        ImmutableEnvelope immutableEnvelope;
        GeographicBoundingBox geographicBoundingBox;
        int n = this.operation.getSourceCRS().getCoordinateSystem().getDimension();
        MathTransform mathTransform = this.operation.getMathTransform();
        double[] dArray2 = new double[mathTransform.getTargetDimensions()];
        if (this.toDomainOfValidity != null && (geographicBoundingBox = CRS.getGeographicBoundingBox((CoordinateOperation)this.operation)) != null) {
            immutableEnvelope = new ImmutableEnvelope(geographicBoundingBox);
            dArray = new double[this.toDomainOfValidity.getTargetDimensions()];
            double_ = new DirectPositionView.Double(dArray);
        } else {
            immutableEnvelope = null;
            dArray = null;
            double_ = null;
        }
        for (double[] dArray3 : list) {
            int n2;
            if (dArray3.length != n) {
                throw new MismatchedDimensionException(Errors.format((short)79, (Object)this.operation.getSourceCRS().getName().getCode(), (Object)n, (Object)dArray3.length));
            }
            mathTransform.transform(dArray3, 0, dArray2, 0, 1);
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                String string;
                double d;
                if (n2 != 0) {
                    this.out.print(',');
                }
                if (Math.abs(d = dArray2[n2]) >= this.thresholdForScientificNotation[n2]) {
                    string = Double.toString(d);
                } else {
                    this.coordinateFormat.setMinimumFractionDigits(this.numFractionDigits[n2]);
                    this.coordinateFormat.setMaximumFractionDigits(this.numFractionDigits[n2]);
                    string = this.coordinateFormat.format(d);
                }
                this.out.print(CharSequences.spaces((int)(this.coordinateWidth - string.length())));
                this.out.print(string);
            }
            if (immutableEnvelope != null) {
                try {
                    this.toDomainOfValidity.transform(dArray3, 0, dArray, 0, 1);
                    n2 = immutableEnvelope.contains((DirectPosition)double_) ? 1 : 0;
                }
                catch (TransformException transformException) {
                    n2 = 0;
                    TransformCommand.warning((Exception)((Object)transformException));
                }
                if (n2 == 0) {
                    this.out.print(",    ");
                    this.printQuotedText(Errors.getResources((Locale)this.locale).getString((short)119), 0, X364.FOREGROUND_RED);
                }
            }
            this.out.println();
        }
    }

    private static void warning(Exception exception) {
        Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.console"), TransformCommand.class, (String)"run", (Throwable)exception);
    }
}

